/*
 * Decompiled with CFR 0.152.
 */
package eva2.tools.chart2d;

import eva2.tools.chart2d.DArray;
import eva2.tools.chart2d.DBorder;
import eva2.tools.chart2d.DComponent;
import eva2.tools.chart2d.DIntDoubleMap;
import eva2.tools.chart2d.DMeasures;
import eva2.tools.chart2d.DPoint;
import eva2.tools.chart2d.DPointIcon;
import eva2.tools.chart2d.DRectangle;
import eva2.tools.math.Mathematics;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.util.ArrayList;

public class DPointSet
extends DComponent {
    protected DPointIcon icon = null;
    protected DIntDoubleMap x;
    protected DIntDoubleMap y;
    protected boolean connected;
    protected Stroke stroke = new BasicStroke();
    protected JumpManager jumper = new JumpManager();

    public DPointSet() {
        this(10, 2);
    }

    public DPointSet(int initial_capacity) {
        this(initial_capacity, 2);
    }

    public DPointSet(int initial_capacity, int length_multiplier) {
        this(new DArray(initial_capacity, length_multiplier), new DArray(initial_capacity, length_multiplier));
    }

    public DPointSet(DIntDoubleMap x_values, DIntDoubleMap y_values) {
        if (x_values.getSize() != y_values.getSize()) {
            throw new IllegalArgumentException("The number of x-values has to be the same than the number of y-values");
        }
        this.x = x_values;
        this.y = y_values;
        this.restore();
        this.setDBorder(new DBorder(1, 1, 1, 1));
    }

    @Override
    public void paint(DMeasures m) {
        Graphics2D g = (Graphics2D)m.getGraphics();
        g.setStroke(this.stroke);
        if (this.color != null) {
            g.setColor(this.color);
        }
        int size = this.getSize();
        if (this.connected && size > 1) {
            this.jumper.restore();
            while (this.jumper.hasMoreIntervals()) {
                int[] interval = this.jumper.nextInterval();
                Point p1 = null;
                for (int i = interval[0]; i < interval[1]; ++i) {
                    Point p2 = m.getPoint(this.x.getImage(i), this.y.getImage(i));
                    if (p1 != null) {
                        g.drawLine(p1.x, p1.y, p2.x, p2.y);
                    }
                    if (this.icon != null) {
                        g.setStroke(new BasicStroke());
                        g.translate(p2.x, p2.y);
                        this.icon.paint(g);
                        g.translate(-p2.x, -p2.y);
                        g.setStroke(this.stroke);
                    }
                    p1 = p2;
                }
            }
        } else {
            for (int i = 0; i < size; ++i) {
                Point p = m.getPoint(this.x.getImage(i), this.y.getImage(i));
                if (this.icon == null) {
                    g.drawLine(p.x - 1, p.y - 1, p.x + 1, p.y + 1);
                    g.drawLine(p.x + 1, p.y - 1, p.x - 1, p.y + 1);
                    continue;
                }
                g.setStroke(new BasicStroke());
                g.translate(p.x, p.y);
                this.icon.paint(g);
                g.translate(-p.x, -p.y);
            }
        }
        g.setStroke(new BasicStroke());
    }

    public void addDPoint(DPoint p) {
        this.x.addImage(p.x);
        this.y.addImage(p.y);
        this.rectangle.insert(p);
        this.repaint();
    }

    public void addDPoint(double x, double y) {
        this.addDPoint(new DPoint(x, y));
    }

    public void jump() {
        this.jumper.addJump();
    }

    public void removeJumps() {
        this.jumper.reset();
    }

    public DPoint getDPoint(int index) {
        if (index >= this.x.getSize()) {
            System.out.println("getDPoint() index" + index);
            System.out.println("x.getSize() " + this.x.getSize());
            throw new ArrayIndexOutOfBoundsException(index);
        }
        DPoint p = new DPoint(this.x.getImage(index), this.y.getImage(index));
        p.setIcon(this.icon);
        p.setColor(this.color);
        return p;
    }

    public void setDPoint(int index, DPoint p) {
        if (index >= this.x.getSize()) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        this.rectangle.insert(p);
        this.x.setImage(index, p.x);
        this.y.setImage(index, p.y);
        this.restore();
        this.repaint();
    }

    public void setIcon(DPointIcon icon) {
        this.icon = icon;
        if (icon == null) {
            this.setDBorder(new DBorder(1, 1, 1, 1));
        } else {
            this.setDBorder(icon.getDBorder());
        }
    }

    public DPointIcon getIcon() {
        return this.icon;
    }

    public void setStroke(Stroke s) {
        if (s == null) {
            s = new BasicStroke();
        }
        this.stroke = s;
        this.repaint();
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public double getMinYVal() {
        return this.y.getMinImageValue();
    }

    public double getMinPositiveYValue() {
        return this.y.getMinPositiveImageValue();
    }

    public void setConnected(boolean aFlag) {
        boolean changed = aFlag != this.connected;
        this.connected = aFlag;
        if (changed) {
            this.repaint();
        }
    }

    public void removeAllPoints() {
        if (this.x.getSize() == 0) {
            return;
        }
        this.x.reset();
        this.y.reset();
        this.jumper.reset();
        this.repaint();
        this.rectangle = DRectangle.getEmpty();
    }

    public String toString() {
        String text = "eva2.tools.chart2d.DPointSet[size:" + this.getSize();
        for (int i = 0; i < this.x.getSize(); ++i) {
            text = text + ",(" + this.x.getImage(i) + "," + this.y.getImage(i) + ")";
        }
        text = text + "]";
        return text;
    }

    public int getNearestDPointIndex(DPoint point) {
        double minValue = Double.MAX_VALUE;
        int minIndex = -1;
        for (int i = 0; i < this.x.getSize(); ++i) {
            double dy;
            double dx = point.x - this.x.getImage(i);
            double dummy = dx * dx + (dy = point.y - this.y.getImage(i)) * dy;
            if (!(dummy < minValue)) continue;
            minValue = dummy;
            minIndex = i;
        }
        return minIndex;
    }

    public DPoint getNearestDPoint(DPoint point) {
        int minIndex = this.getNearestDPointIndex(point);
        if (minIndex == -1) {
            return null;
        }
        return new DPoint(this.x.getImage(minIndex), this.y.getImage(minIndex));
    }

    public int getSize() {
        int size = this.x.getSize();
        if (size <= this.y.getSize()) {
            return size;
        }
        return this.x.getSize();
    }

    protected void restore() {
        if (this.getSize() == 0) {
            this.rectangle = DRectangle.getEmpty();
            return;
        }
        double min_x = this.x.getMinImageValue();
        double max_x = this.x.getMaxImageValue();
        double min_y = this.y.getMinImageValue();
        double max_y = this.y.getMaxImageValue();
        if (Mathematics.areFinite(min_x, max_x, min_y, max_y) == -1) {
            this.rectangle = new DRectangle(min_x, min_y, max_x - min_x, max_y - min_y);
        }
    }

    class JumpManager {
        protected ArrayList<Integer> jumps = new ArrayList();
        protected int index = -1;

        JumpManager() {
        }

        public void addJump() {
            this.jumps.add(DPointSet.this.getSize());
        }

        public int[] nextInterval() {
            int noJumps = this.jumps.size();
            if (this.index >= noJumps) {
                throw new ArrayIndexOutOfBoundsException("No more intervals in JumpManager");
            }
            int[] inter = new int[2];
            inter[0] = this.index == -1 ? 0 : this.jumps.get(this.index);
            ++this.index;
            inter[1] = this.index < noJumps ? this.jumps.get(this.index).intValue() : DPointSet.this.getSize();
            return inter;
        }

        public boolean hasMoreIntervals() {
            return this.index < this.jumps.size();
        }

        public void restore() {
            this.index = -1;
        }

        public void reset() {
            this.index = -1;
            this.jumps.clear();
        }
    }
}

