/*
 * Decompiled with CFR 0.152.
 */
package eva2.tools.chart2d;

import eva2.tools.EVAERROR;
import eva2.tools.chart2d.DComponent;
import eva2.tools.chart2d.DMeasures;
import eva2.tools.chart2d.DPoint;
import eva2.tools.chart2d.SlimRect;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;

public class DRectangle
extends DComponent {
    private double x;
    private double y;
    private double width;
    private double height;
    public static final int PART = 0;
    public static final int ALL = 1;
    public static final int EMPTY = 2;
    protected int status;
    protected Color fillColor;

    private DRectangle(int status) {
        super(true);
        this.status = status;
    }

    public DRectangle(double x, double y, double width, double height) {
        super(true);
        this.x = x;
        this.y = y;
        if (width < 0.0 || Double.isInfinite(width) || Double.isNaN(width)) {
            throw new IllegalArgumentException("Width of a DRectangle is invalid (" + width + ")");
        }
        this.width = width;
        if (height < 0.0 || Double.isInfinite(height) || Double.isNaN(height)) {
            throw new IllegalArgumentException("Height of a DRectangle is invalid (" + height + ")");
        }
        this.height = height;
        this.status = 0;
    }

    @Override
    public DRectangle getRectangle() {
        return this;
    }

    @Override
    public void paint(DMeasures m) {
        if (this.isEmpty()) {
            return;
        }
        Graphics g = m.getGraphics();
        Color old_color = g.getColor();
        SlimRect rect = m.getSlimRectangle().getIntersection(this);
        Point p1 = m.getPoint(rect.x, rect.y);
        Point p2 = m.getPoint(rect.x + rect.width, rect.y + rect.height);
        if (this.fillColor != null) {
            g.setColor(this.fillColor);
            g.fillRect(p1.x, p2.y, p2.x - p1.x, p1.y - p2.y);
        }
        if (!this.isAll()) {
            if (this.color != null) {
                g.setColor(this.color);
            } else {
                g.setColor(DEFAULT_COLOR);
            }
            g.drawRect(p1.x, p2.y, p2.x - p1.x, p1.y - p2.y);
        }
        g.setColor(old_color);
    }

    public boolean contains(DPoint p) {
        if (this.status == 1) {
            return true;
        }
        if (this.status == 2) {
            return false;
        }
        if (p.x < this.x) {
            return false;
        }
        if (p.y < this.y) {
            return false;
        }
        if (p.x > this.x + this.width) {
            return false;
        }
        return p.y <= this.y + this.height;
    }

    public double getHeight() {
        return this.height;
    }

    public double getWidth() {
        return this.width;
    }

    public void setHeight(double h) {
        if (Double.isInfinite(h) || Double.isNaN(h)) {
            System.err.println("Warning, infinite vaule for height!");
        } else {
            this.height = h;
        }
    }

    public void setWidth(double w) {
        if (Double.isInfinite(w) || Double.isNaN(w)) {
            System.err.println("Warning, infinite vaule for width!");
        } else {
            this.width = w;
        }
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public void setX(double v) {
        if (Double.isInfinite(v) || Double.isNaN(v)) {
            System.err.println("Warning, infinite vaule for x!");
        } else {
            this.x = v;
        }
    }

    public void setY(double v) {
        if (Double.isInfinite(v) || Double.isNaN(v)) {
            System.err.println("Warning, infinite vaule for y!");
        } else {
            this.y = v;
        }
    }

    private boolean contains(double ox, double oy) {
        return !(ox < this.x || oy < this.y || ox > this.x + this.width || oy > this.y + this.height);
    }

    public boolean contains(DRectangle rect) {
        if (this.status == 1 || rect.isEmpty()) {
            return true;
        }
        if (this.status == 2 || rect.isAll()) {
            return false;
        }
        if (!this.contains(rect.x, rect.y)) {
            return false;
        }
        return this.contains(rect.x + rect.width, rect.y + rect.height);
    }

    public boolean contains(double ox, double oy, double width, double heigth) {
        if (this.status == 1) {
            return true;
        }
        if (this.status == 2) {
            return false;
        }
        if (!this.contains(ox, oy)) {
            return false;
        }
        return this.contains(ox + width, oy + this.height);
    }

    public DRectangle getIntersection(DRectangle r) {
        if (this.status == 2 || r.status == 2) {
            return DRectangle.getEmpty();
        }
        if (this.status == 1) {
            return (DRectangle)r.clone();
        }
        if (r.status == 1) {
            return (DRectangle)this.clone();
        }
        DRectangle s = (DRectangle)this.clone();
        if (s.x < r.x) {
            s.x = r.x;
            s.width -= r.x - s.x;
        }
        if (s.y < r.y) {
            s.y = r.y;
            s.height -= r.y - s.y;
        }
        if (s.x + s.width > r.x + r.width) {
            s.width = r.x + r.width - s.x;
        }
        if (s.y + s.height > r.y + r.height) {
            s.height = r.y + r.height - s.y;
        }
        if (s.width < 0.0 || s.height < 0.0) {
            return DRectangle.getEmpty();
        }
        return s;
    }

    public boolean insert(DPoint p) {
        if (p.x == Double.NaN || p.y == Double.NaN || Double.isInfinite(p.x) || Double.isInfinite(p.y)) {
            EVAERROR.errorMsgOnce("Warning, inserted invalid point (NaN/infinity) in " + this.getClass().getSimpleName());
            return false;
        }
        if (this.isAll()) {
            return false;
        }
        if (this.contains(p)) {
            return false;
        }
        if (this.isEmpty()) {
            this.x = p.x;
            this.y = p.y;
            this.height = 0.0;
            this.width = 0.0;
            this.status = 0;
            return true;
        }
        if (p.x < this.x) {
            this.width += this.x - p.x;
            this.x = p.x;
        } else if (p.x > this.x + this.width) {
            this.width = p.x - this.x;
        }
        if (p.y < this.y) {
            this.height += this.y - p.y;
            this.y = p.y;
        } else if (p.y > this.y + this.height) {
            this.height = p.y - this.y;
        }
        return true;
    }

    public boolean insert(DRectangle rect) {
        if (this.isAll() || rect.isEmpty()) {
            return false;
        }
        if (rect.isAll()) {
            this.status = 1;
            return true;
        }
        if (this.isEmpty()) {
            this.x = rect.x;
            this.y = rect.y;
            this.width = rect.width;
            this.height = rect.height;
            this.status = 0;
            return true;
        }
        boolean changed = false;
        changed = this.insert(new DPoint(rect.x, rect.y));
        changed = this.insert(new DPoint(rect.x + rect.width, rect.y + rect.height)) ? true : changed;
        return changed;
    }

    public Object clone() {
        DRectangle copy = new DRectangle(this.x, this.y, this.width, this.height);
        copy.status = this.status;
        if (this.color != null) {
            copy.color = new Color(this.color.getRGB());
        }
        return copy;
    }

    public String toString() {
        String text = "DRectangle[ ";
        switch (this.status) {
            case 1: {
                text = text + "all";
                break;
            }
            case 2: {
                text = text + "empty";
                break;
            }
            case 0: {
                text = text + this.x + ", " + this.y + ", " + this.width + ", " + this.height;
            }
        }
        text = text + " ]";
        return text;
    }

    public boolean equals(DRectangle r) {
        if (r.status != this.status) {
            return false;
        }
        if (r.x != this.x) {
            return false;
        }
        if (r.y != this.y) {
            return false;
        }
        if (r.width != this.width) {
            return false;
        }
        return r.height == this.height;
    }

    public void setFillColor(Color fill_color) {
        if (this.fillColor == null || !this.fillColor.equals(fill_color)) {
            this.fillColor = fill_color;
            this.repaint();
        }
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public static DRectangle getAll() {
        return new DRectangle(1);
    }

    public boolean isAll() {
        return this.status == 1;
    }

    public static DRectangle getEmpty() {
        return new DRectangle(2);
    }

    public boolean isEmpty() {
        return this.status == 2;
    }
}

