/*
 * Decompiled with CFR 0.152.
 */
package eva2.tools.chart2d;

import eva2.tools.chart2d.DArea;
import eva2.tools.chart2d.DFunction;
import eva2.tools.chart2d.DMeasures;
import eva2.tools.chart2d.SlimRect;
import eva2.tools.math.Mathematics;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.BorderFactory;
import javax.swing.border.Border;

public class ScaledBorder
implements Border {
    int markerLength = 2;
    int arrowLength = 10;
    public boolean showArrows = true;
    int xValue2value = 2;
    int yLabel2values = 1;
    int yValues2marker = 2;
    int xValues2arrow = 10;
    int yValues2arrow = 10;
    int axis2border = 4;
    public int xLabel2border = 6;
    public int yLabel2border = 6;
    SlimRect srcRect = null;
    public double minimalIncrement;
    public String xLabel;
    public String yLabel;
    public Color foreground;
    public Color background;
    Border outerBorder;
    boolean showOuterBorder = false;
    public DFunction xScale;
    public DFunction yScale;
    private NumberFormat formatX = new DecimalFormat();
    private NumberFormat formatY = new DecimalFormat();
    private String[] decPatterns = new String[]{"#,##0.###", "00.###E0"};
    private int nextYPattern = 1;
    private int nextXPattern = 1;
    private double srcDX = -1.0;
    private double srcDY = -1.0;
    private boolean doRefresh;
    private boolean autoScaleX = true;
    private boolean autoScaleY = true;
    private Insets oldInsets;
    private DMeasures m;

    public ScaledBorder() {
        this(BorderFactory.createBevelBorder(1, Color.white, Color.lightGray, Color.black, Color.lightGray));
    }

    public ScaledBorder(Border outer) {
        this.outerBorder = outer;
        this.m = new DMeasures(this);
    }

    public void setAutoScaleX() {
        this.autoScaleX = true;
    }

    public void setAutoScaleY() {
        this.autoScaleY = true;
    }

    public void setSrcdX(double dX) {
        this.autoScaleX = false;
        this.srcDX = dX;
    }

    public void setSrcdY(double dY) {
        this.autoScaleY = false;
        this.srcDY = dY;
    }

    public SlimRect getInnerRect(Component c) {
        Insets inner_insets = this.getBorderInsets(c);
        Dimension d = c.getSize();
        int width = d.width - inner_insets.left - inner_insets.right;
        int height = d.height - inner_insets.top - inner_insets.bottom;
        SlimRect rect = new SlimRect(inner_insets.left, inner_insets.top, width, height);
        return rect;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (this.foreground == null) {
            this.foreground = c.getForeground();
        }
        if (this.background == null) {
            this.background = c.getBackground();
        }
        Color oldColor = g.getColor();
        g.setColor(this.background);
        g.fillRect(x, y, width, height);
        g.setColor(oldColor);
        Insets outerInsets = new Insets(0, 0, 0, 0);
        if (this.showOuterBorder) {
            this.outerBorder.paintBorder(c, g, x, y, width, height);
            outerInsets = this.outerBorder.getBorderInsets(c);
        }
        this.doRefresh = true;
        Insets innerInsets = this.getBorderInsets(c);
        Dimension d = c.getSize();
        Dimension cd = new Dimension(d.width - innerInsets.left - innerInsets.right, d.height - innerInsets.top - innerInsets.bottom);
        FontMetrics fm = g.getFontMetrics();
        int fontAsc = fm.getAscent();
        this.doRefresh = false;
        this.m.update(c, innerInsets);
        g.setColor(this.foreground);
        g.drawLine(innerInsets.left, innerInsets.top, innerInsets.left, innerInsets.top + cd.height);
        g.drawLine(innerInsets.left, innerInsets.top + cd.height, innerInsets.left + cd.width, innerInsets.top + cd.height);
        if (this.showArrows) {
            g.drawLine(innerInsets.left, innerInsets.top, innerInsets.left, innerInsets.top - this.yValues2arrow);
            g.drawLine(innerInsets.left - this.markerLength, innerInsets.top - this.yValues2arrow, innerInsets.left, innerInsets.top - this.yValues2arrow - this.arrowLength);
            g.drawLine(innerInsets.left + this.markerLength, innerInsets.top - this.yValues2arrow, innerInsets.left, innerInsets.top - this.yValues2arrow - this.arrowLength);
            g.drawLine(innerInsets.left - this.markerLength, innerInsets.top - this.yValues2arrow, innerInsets.left + this.markerLength, innerInsets.top - this.yValues2arrow);
            g.drawLine(innerInsets.left + cd.width, innerInsets.top + cd.height, innerInsets.left + cd.width + this.xValues2arrow, innerInsets.top + cd.height);
            g.drawLine(innerInsets.left + cd.width + this.xValues2arrow, innerInsets.top + cd.height - this.markerLength, innerInsets.left + cd.width + this.xValues2arrow + this.arrowLength, innerInsets.top + cd.height);
            g.drawLine(innerInsets.left + cd.width + this.xValues2arrow, innerInsets.top + cd.height + this.markerLength, innerInsets.left + cd.width + this.xValues2arrow + this.arrowLength, innerInsets.top + cd.height);
            g.drawLine(innerInsets.left + cd.width + this.xValues2arrow, innerInsets.top + cd.height - this.markerLength, innerInsets.left + cd.width + this.xValues2arrow, innerInsets.top + cd.height + this.markerLength);
        }
        if (this.yLabel != null) {
            Dimension yld = new Dimension(fm.getAscent() + fm.getDescent(), fm.stringWidth(this.yLabel));
            ScaledBorder.drawRotate((Graphics2D)g, this.yLabel2border + fm.getAscent(), innerInsets.top + (cd.height + yld.height) / 2, 270, this.yLabel);
        }
        if (this.xLabel != null) {
            g.drawString(this.xLabel, innerInsets.left + (cd.width - fm.stringWidth(this.xLabel)) / 2, d.height - outerInsets.bottom - this.xLabel2border - fm.getDescent());
        }
        if (this.srcRect.x == 0.0 && this.srcRect.y == 0.0) {
            int v2m = fm.stringWidth("0") / this.yValues2marker;
            g.drawString("0", innerInsets.left - fm.stringWidth("0") - v2m - this.markerLength, innerInsets.top + cd.height + fontAsc);
            g.drawLine(innerInsets.left, innerInsets.top + cd.height + fm.getAscent(), innerInsets.left, innerInsets.top + cd.height);
            g.drawLine(innerInsets.left, innerInsets.top + cd.height, innerInsets.left - fm.stringWidth("0") - v2m - this.markerLength, innerInsets.top + cd.height);
        }
        this.drawYValues(g, innerInsets);
        this.drawXValues(g, innerInsets, cd);
        g.setColor(oldColor);
    }

    private static void drawRotate(Graphics2D g2d, double x, double y, int angle, String text) {
        g2d.translate((float)x, (float)y);
        g2d.rotate(Math.toRadians(angle));
        g2d.drawString(text, 0, 0);
        g2d.rotate(-Math.toRadians(angle));
        g2d.translate(-((float)x), -((float)y));
    }

    private void drawYValues(Graphics g, Insets insets) {
        FontMetrics fm = g.getFontMetrics();
        int fontAsc = fm.getAscent();
        int v2m = fm.stringWidth("0") / this.yValues2marker;
        double startVal = Mathematics.firstMultipleAbove(this.srcRect.y, this.srcDY);
        double minx = this.srcRect.x;
        if (this.xScale != null) {
            minx = this.xScale.getImageOf(minx);
        }
        for (double v = startVal; v <= this.srcRect.y + this.srcRect.height; v += this.srcDY) {
            double scaledV = this.yScale != null ? this.yScale.getImageOf(v) : v;
            String text = this.formatY.format(scaledV);
            try {
                scaledV = this.formatY.parse(text).doubleValue();
            }
            catch (ParseException ignored) {
                // empty catch block
            }
            Point p = this.m.getPoint(minx, scaledV);
            if (p != null) {
                g.drawString(this.formatScientificNumber(text).getIterator(), insets.left - fm.stringWidth(text) - v2m - this.markerLength, p.y + fontAsc / 2);
                g.drawLine(insets.left - this.markerLength, p.y, insets.left, p.y);
            }
            if (!(v + this.srcDY <= v)) continue;
            v *= 1.01;
        }
    }

    private AttributedString formatScientificNumber(String text) {
        int indexOfE = text.indexOf("E");
        if (indexOfE == -1) {
            return new AttributedString(text);
        }
        text = text.substring(0, indexOfE) + text.substring(indexOfE + 1);
        AttributedString scientificNumber = new AttributedString(text);
        scientificNumber.addAttribute(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUPER, indexOfE, text.length());
        return scientificNumber;
    }

    public double getSrcdY(FontMetrics fm, Dimension cd) {
        return this.getSrcdY(fm.getHeight(), cd.height);
    }

    public double getSrcdY(int fontMetricsHeight, int componentHeight) {
        if (!this.doRefresh && this.srcDY != -1.0 || !this.autoScaleY) {
            return this.srcDY;
        }
        int max = componentHeight / fontMetricsHeight;
        if (Double.isInfinite(this.srcRect.height) || Double.isInfinite(this.srcRect.width)) {
            System.err.println("Error, infinite value in ScaledBorder:getSrcdY !!");
        }
        double minsrc_dY = 2.0 * this.srcRect.height / (double)max;
        this.srcDY = ScaledBorder.aBitBigger(minsrc_dY);
        if (this.srcDY < this.minimalIncrement) {
            this.srcDY = this.minimalIncrement;
        }
        return this.srcDY;
    }

    private void drawXValues(Graphics g, Insets insets, Dimension cd) {
        FontMetrics fm = g.getFontMetrics();
        double mx = (double)cd.width / this.srcRect.width;
        int xnull = insets.left + (int)(-this.srcRect.x * mx);
        int n = (int)(this.srcRect.x / this.srcDX);
        if ((double)n * this.srcDX < this.srcRect.x || this.srcRect.x == 0.0 && this.srcRect.y == 0.0) {
            ++n;
        }
        int fontAsc = fm.getAscent();
        int xLineY = insets.top + cd.height;
        int labelX = xnull + (int)((double)n * this.srcDX * mx);
        while ((double)n * this.srcDX <= this.srcRect.x + this.srcRect.width) {
            double v = (double)n * this.srcDX;
            if (this.xScale != null) {
                v = this.xScale.getImageOf(v);
            }
            String text = this.formatX.format(v);
            try {
                v = this.formatX.parse(text).doubleValue();
            }
            catch (ParseException ex) {
                // empty catch block
            }
            int strW = fm.stringWidth(text);
            g.drawString(text, labelX - strW / 2, xLineY + fontAsc + this.markerLength);
            g.drawLine(labelX, xLineY, labelX, xLineY + this.markerLength);
            labelX = xnull + (int)((double)(++n) * this.srcDX * mx);
        }
    }

    public double getSrcdX(FontMetrics fm, Dimension cd) {
        if (!this.doRefresh && this.srcDX != -1.0 || !this.autoScaleX) {
            return this.srcDX;
        }
        int digit_width = fm.stringWidth("0");
        int max = cd.width / (digit_width * (this.xValue2value + 1));
        this.srcDX = this.srcRect.width / (double)max;
        boolean ok = false;
        while (!ok) {
            this.srcDX = ScaledBorder.aBitBigger(this.srcDX);
            int n = (int)(this.srcRect.x / this.srcDX);
            if ((double)n * this.srcDX < this.srcRect.x) {
                ++n;
            }
            int olsrc_dX = 0;
            boolean suits = true;
            boolean first = true;
            while (suits && (double)n * this.srcDX <= this.srcRect.x + this.srcRect.width) {
                double v = (double)n * this.srcDX;
                if (this.xScale != null) {
                    v = this.xScale.getImageOf(v);
                }
                String text = this.formatX.format(v);
                int strW = fm.stringWidth(text);
                int labelX = (int)(((double)n * this.srcDX - this.srcRect.x) / this.srcRect.width * (double)cd.width) - strW / 2;
                if (!first && labelX <= olsrc_dX + digit_width * this.xValue2value) {
                    suits = false;
                } else {
                    olsrc_dX = labelX + strW;
                    ++n;
                }
                first = false;
            }
            ok = suits;
        }
        if (this.srcDX < this.minimalIncrement) {
            this.srcDX = this.minimalIncrement;
        }
        return this.srcDX;
    }

    public static double aBitBigger(double min) {
        if (min <= 0.0 || Double.isInfinite(min) || Double.isNaN(min)) {
            return 1.0;
        }
        double d = 1.0;
        if (min < d) {
            while (d * 0.5 > min) {
                if ((d *= 0.5) * 0.4 > min) {
                    d *= 0.4;
                }
                if (!(d * 0.5 > min)) continue;
                d *= 0.5;
            }
        } else {
            while (d <= min) {
                if ((d *= 2.0) <= min) {
                    d *= 2.5;
                }
                if (!(d <= min)) continue;
                d *= 2.0;
            }
        }
        return d;
    }

    @Override
    public boolean isBorderOpaque() {
        return this.outerBorder.isBorderOpaque();
    }

    public void toggleDecPattern(boolean xOrY) {
        int current;
        if (xOrY) {
            current = this.nextXPattern;
            this.nextXPattern = (this.nextXPattern + 1) % this.decPatterns.length;
        } else {
            current = this.nextYPattern;
            this.nextYPattern = (this.nextYPattern + 1) % this.decPatterns.length;
        }
        this.applyPattern(xOrY, this.decPatterns[current]);
    }

    protected void setNextPattern(boolean xOrY, int next) {
        if (xOrY) {
            this.nextXPattern = next;
        } else {
            this.nextYPattern = next;
        }
        this.toggleDecPattern(xOrY);
    }

    public void setStandardPattern(boolean xOrY) {
        this.setNextPattern(xOrY, 0);
    }

    public void setScientificPattern(boolean xOrY) {
        this.setNextPattern(xOrY, 1);
    }

    public void applyPattern(boolean bXorY, String pattern) {
        if (bXorY) {
            ((DecimalFormat)this.formatX).applyPattern(pattern);
        } else {
            ((DecimalFormat)this.formatY).applyPattern(pattern);
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        int w;
        double inc;
        double start;
        if (!this.doRefresh && this.oldInsets != null) {
            return this.oldInsets;
        }
        Graphics g = c.getGraphics();
        Insets insets = new Insets(0, 0, 0, 0);
        if (this.showOuterBorder) {
            insets = this.outerBorder.getBorderInsets(c);
        }
        if (g == null) {
            return insets;
        }
        FontMetrics fm = g.getFontMetrics();
        int fontHeight = fm.getHeight();
        int digit_width = fm.stringWidth("0");
        if (c instanceof DArea) {
            DArea area = (DArea)c;
            DMeasures m = area.getDMeasures();
            this.srcRect = m.getSourceOf(area.getSlimRectangle());
            this.xScale = area.getDMeasures().xScale;
            this.yScale = area.getDMeasures().yScale;
        }
        if (this.yLabel != null) {
            insets.left += fm.getAscent() + fm.getDescent();
        }
        insets.left += this.yLabel2values * digit_width;
        this.getSrcdY(fm, c.getSize());
        int maxWidth = 0;
        double n = start = this.srcDY * (double)((int)(this.srcRect.y / this.srcDY));
        if (n < this.srcRect.y) {
            n += this.srcDY;
        }
        if (n + (inc = (this.srcRect.y + this.srcRect.height - start) / this.srcDY > 20.0 ? (this.srcRect.y + this.srcRect.height - start) / 20.0 : this.srcDY) == n) {
            System.err.println("Warning, too small increase step size!");
        }
        while (n <= this.srcRect.y + this.srcRect.height) {
            int w2;
            double v = n;
            if (this.yScale != null) {
                v = this.yScale.getImageOf(v);
            }
            if ((w2 = fm.stringWidth(this.formatY.format(v))) > maxWidth) {
                maxWidth = w2;
            }
            n += inc;
        }
        insets.left += 1 + this.yLabel2border + maxWidth + digit_width / this.yValues2marker + this.markerLength;
        insets.bottom += 1 + fontHeight + this.xLabel2border;
        if (this.xLabel != null) {
            insets.bottom += fontHeight;
        }
        if (this.showArrows) {
            insets.top += this.yValues2arrow + this.arrowLength;
        }
        insets.top += this.axis2border;
        if (this.showArrows) {
            insets.right += this.xValues2arrow + this.arrowLength;
        }
        insets.right += this.axis2border;
        this.getSrcdX(fm, c.getSize());
        int k = (int)(this.srcRect.x + this.srcRect.width / this.srcDX);
        if (k < 0) {
            ++k;
        }
        if ((w = fm.stringWidth(this.formatX.format((double)k * this.srcDX))) / 2 > insets.right) {
            insets.right = w / 2;
        }
        this.oldInsets = insets;
        return insets;
    }
}

