/*
 * Decompiled with CFR 0.152.
 */
package eva2.tools.chart2d;

import eva2.tools.chart2d.DRectangle;

public class SlimRect {
    double x;
    double y;
    double width;
    double height;

    public SlimRect(double xpos, double ypos, double wd, double ht) {
        this.x = xpos;
        this.y = ypos;
        this.width = wd;
        this.height = ht;
    }

    public SlimRect(SlimRect o) {
        this.x = o.x;
        this.y = o.y;
        this.width = o.width;
        this.height = o.height;
    }

    public boolean contains(double ox, double oy) {
        return !(ox < this.x || oy < this.y || ox > this.x + this.width || oy > this.y + this.height);
    }

    public boolean contains(double xpos, double ypos, double wd, double ht) {
        return this.contains(xpos, ypos) && this.contains(xpos + wd, ypos + ht);
    }

    public String toString() {
        return "SlimRect[" + this.x + "," + this.y + "/" + this.width + "," + this.height + "]";
    }

    public SlimRect getIntersection(SlimRect r) {
        return this.getIntersection(r.x, r.y, r.width, r.height);
    }

    public SlimRect getIntersection(DRectangle r) {
        return this.getIntersection(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public SlimRect getIntersection(double rx, double ry, double rwidth, double rheight) {
        SlimRect s = new SlimRect(this);
        if (s.x < rx) {
            s.x = rx;
            s.width -= rx - s.x;
        }
        if (s.y < ry) {
            s.y = ry;
            s.height -= ry - s.y;
        }
        if (s.x + s.width > rx + rwidth) {
            s.width = rx + rwidth - s.x;
        }
        if (s.y + s.height > ry + rheight) {
            s.height = ry + rheight - s.y;
        }
        if (s.width < 0.0 || s.height < 0.0) {
            return null;
        }
        return s;
    }

    public boolean hasEmptyIntersection(DRectangle r) {
        return this.getIntersection(r.getX(), r.getY(), r.getWidth(), r.getHeight()) == null;
    }

    public boolean hasEmptyIntersection(SlimRect r) {
        return this.getIntersection(r) == null;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }
}

