/*
 * Decompiled with CFR 0.152.
 */
package eva2.tools.diagram;

import java.awt.Color;

public class ColorBarCalculator {
    public static final int BLUE_TO_RED = 0;
    public static final int GREY_SCALE = 1;
    public static final int BLUE_SCALE = 2;
    public static final int ALL_COLORS = 3;
    public static final int GREY_EXTENDED_SCALE = 4;
    private int color_scale = 0;
    private boolean inverseScale = false;

    public ColorBarCalculator(int color_scale) {
        this.color_scale = color_scale;
    }

    public void setColorScale(int color_scale) {
        this.color_scale = color_scale;
    }

    public Color getColor(float value) {
        return new Color(this.getRGB(value));
    }

    public int getRGB(float value) {
        int rgbValue = 0;
        if (this.inverseScale) {
            value = 1.0f - value;
        }
        switch (this.color_scale) {
            case 0: {
                float hue = value * (value + value * 0.8f) / 2.65f - 1.0f;
                rgbValue = Color.HSBtoRGB(hue, 0.6f, 1.0f);
                break;
            }
            case 1: {
                rgbValue = Color.HSBtoRGB(0.0f, 0.0f, value * 0.8f + 0.1f);
                break;
            }
            case 2: {
                int rg = (int)(value * 0.95f * 256.0f);
                int b = (int)((value / 2.0f + 0.45f) * 256.0f);
                rgbValue = rg * 65536 + rg * 256 + b;
                break;
            }
            case 3: {
                rgbValue = Color.HSBtoRGB(value, 0.6f, 1.0f);
                break;
            }
            case 4: {
                rgbValue = Color.HSBtoRGB(0.0f, 0.0f, value);
            }
        }
        return rgbValue;
    }

    public void setInverseScale(boolean isInverse) {
        this.inverseScale = isInverse;
    }

    public boolean isInverseScale() {
        return this.inverseScale;
    }

    public static Color getDefaultColor(float value) {
        return new Color(ColorBarCalculator.getDefaultRGB(value));
    }

    public static int getDefaultRGB(float value) {
        float hue = value * (value + value * 0.8f) / 2.65f - 1.0f;
        return Color.HSBtoRGB(hue, 0.6f, 1.0f);
    }
}

