/*
 * Decompiled with CFR 0.152.
 */
package eva2.tools.math;

import eva2.gui.BeanInspector;
import eva2.optimization.enums.BOAScoringMethods;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceDataTypeBinary;
import eva2.optimization.individuals.InterfaceGAIndividual;
import eva2.optimization.population.Population;
import eva2.tools.Pair;
import eva2.tools.math.BayNode;
import eva2.tools.math.RNG;
import eva2.tools.math.SpecialFunction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public final class BayNet {
    private boolean[][] network = null;
    private int dimension = 3;
    private BayNode[] nodes = null;
    private List<Integer> rootNodes = new LinkedList<Integer>();
    private double upperProbLimit = 0.9;
    private double lowerProbLimit = 0.1;
    private BOAScoringMethods scoringMethod = BOAScoringMethods.BDM;
    private double[] scoreArray = null;

    public BayNet(int dimension, double upperLimit, double lowerLimit) {
        this.dimension = dimension;
        this.upperProbLimit = upperLimit;
        this.lowerProbLimit = lowerLimit;
        this.init();
    }

    public BayNet(BayNet b) {
        this.network = this.cloneNetwork(b.network);
        this.dimension = b.dimension;
        this.nodes = new BayNode[b.dimension];
        for (int i = 0; i < this.nodes.length; ++i) {
            this.nodes[i] = (BayNode)b.nodes[i].clone();
        }
        this.rootNodes = new LinkedList<Integer>();
        for (Integer node : b.rootNodes) {
            this.rootNodes.add(node);
        }
        this.upperProbLimit = b.upperProbLimit;
        this.lowerProbLimit = b.lowerProbLimit;
    }

    public Object clone() {
        return new BayNet(this);
    }

    private boolean[][] cloneNetwork(boolean[][] b) {
        boolean[][] result = new boolean[b.length][b.length];
        for (int i = 0; i < b.length; ++i) {
            for (int j = 0; j < b.length; ++j) {
                if (!b[i][j]) continue;
                result[i][j] = true;
            }
        }
        return result;
    }

    public void init() {
        this.network = new boolean[this.dimension][this.dimension];
        this.nodes = new BayNode[this.dimension];
        for (int i = 0; i < this.dimension; ++i) {
            this.nodes[i] = new BayNode(i);
            this.rootNodes.add(i);
        }
        this.scoreArray = new double[this.dimension];
        Arrays.fill(this.scoreArray, -1.0);
    }

    private static BitSet getBinaryData(AbstractEAIndividual indy) {
        if (indy instanceof InterfaceGAIndividual) {
            return ((InterfaceGAIndividual)((Object)indy)).getBGenotype();
        }
        if (indy instanceof InterfaceDataTypeBinary) {
            return ((InterfaceDataTypeBinary)((Object)indy)).getBinaryData();
        }
        throw new RuntimeException("Unable to get binary representation for " + indy.getClass());
    }

    public List<BayNode> getRootNodes() {
        LinkedList<BayNode> result = new LinkedList<BayNode>();
        for (Integer i : this.rootNodes) {
            result.add(this.nodes[i]);
        }
        return result;
    }

    public BayNode getNode(int i) {
        return this.nodes[i];
    }

    public List<BayNode> getChildren(BayNode n) {
        List<Integer> ids = n.getChildren();
        ArrayList<BayNode> result = new ArrayList<BayNode>();
        for (int i : ids) {
            result.add(this.nodes[i]);
        }
        return result;
    }

    public List<BayNode> getParents(BayNode n) {
        List<Integer> ids = n.getParents();
        LinkedList<BayNode> result = new LinkedList<BayNode>();
        for (int i : ids) {
            result.add(this.nodes[i]);
        }
        return result;
    }

    public List<BayNode> getChildren(List<BayNode> n) {
        ArrayList<BayNode> result = new ArrayList<BayNode>();
        for (BayNode node : n) {
            List<BayNode> children = this.getChildren(node);
            for (BayNode nod : children) {
                if (result.contains(nod)) continue;
                result.add(nod);
            }
        }
        return result;
    }

    public void removeEdge(Integer i, Integer j) {
        if (this.network[i][j]) {
            this.network[i.intValue()][j.intValue()] = false;
            this.nodes[j].decrNumberOfParents();
            this.nodes[i].removeChild(j);
            this.nodes[j].removeParent(i);
            this.nodes[j].generateNewPTable();
            if (this.nodes[j].getNumberOfParents() == 0) {
                this.rootNodes.add(j);
            }
        }
    }

    public void addEdge(Integer i, Integer j) {
        if (!i.equals(j) && !this.network[i][j]) {
            this.network[i.intValue()][j.intValue()] = true;
            this.rootNodes.remove(j);
            this.nodes[j].incrNumberOfParents();
            this.nodes[j].generateNewPTable();
            this.nodes[i].addChild(j);
            this.nodes[j].addParent(i);
        }
    }

    private int findNext(double[] probabilities) {
        int result = -1;
        for (int i = 0; i < probabilities.length; ++i) {
            if (probabilities[i] != -1.0) continue;
            BayNode currentNode = this.nodes[i];
            List<BayNode> parents = this.getParents(currentNode);
            boolean possible = true;
            for (BayNode node : parents) {
                if (probabilities[node.getId()] != -1.0) continue;
                possible = false;
            }
            if (!possible) continue;
            result = i;
            break;
        }
        return result;
    }

    private int findNext(double[] probabilities, List<BayNode> nodes) {
        nodes = this.removeDuplicate(nodes);
        for (BayNode node : nodes) {
            if (node.getCalculated()) continue;
            node.setCalculated(true);
            List<BayNode> parents = this.getParents(node);
            boolean possible = false;
            for (BayNode p : parents) {
                if (probabilities[p.getId()] != -1.0) {
                    possible = true;
                    continue;
                }
                possible = false;
                break;
            }
            if (!possible) continue;
            this.resetCalculated();
            return node.getId();
        }
        this.resetCalculated();
        return -1;
    }

    private List<BayNode> removeDuplicate(List<BayNode> nodes) {
        HashSet<BayNode> hashSet = new HashSet<BayNode>(nodes);
        ArrayList<BayNode> arrayList2 = new ArrayList<BayNode>(hashSet);
        return arrayList2;
    }

    public BitSet sample(BitSet data) {
        double[] probabilities = new double[this.network.length];
        for (int i = 0; i < probabilities.length; ++i) {
            probabilities[i] = -1.0;
        }
        List<BayNode> nodes = this.getRootNodes();
        for (BayNode node : nodes) {
            int id = node.getId();
            probabilities[id] = node.getProbability(0);
            data.set(id, RNG.flipCoin(probabilities[id]));
            node.setCalculated(true);
        }
        int next = this.findNext(probabilities);
        while (next != -1) {
            this.nodes[next].setCalculated(true);
            probabilities[next] = this.calculateNextProbability(data, next);
            data.set(next, RNG.flipCoin(probabilities[next]));
            next = this.findNext(probabilities);
        }
        this.resetCalculated();
        return data;
    }

    private List<BayNode> addToToCalculate(List<BayNode> toCalculate, BayNode next) {
        List<BayNode> toAdd = this.getChildren(next);
        for (int i = 0; i < toAdd.size(); ++i) {
            BayNode node = toAdd.get(i);
            if (toCalculate.contains(node) || node.getCalculated()) continue;
            toCalculate.add(node);
        }
        return toCalculate;
    }

    private double calculateNextProbability(BitSet data, int next) {
        int[] parId = this.calculateSortedParentIds(next);
        int par = 0;
        for (int i = parId.length - 1; i >= 0; --i) {
            if (!data.get(parId[i])) continue;
            par = (int)((double)par + Math.pow(2.0, i));
        }
        return this.nodes[next].getProbability(par);
    }

    private double calculateNextProbability(BitSet data, List<BayNode> toCalculate, int next) {
        toCalculate.addAll(this.getChildren(this.nodes[next]));
        int[] parId = this.calculateSortedParentIds(next);
        int prob = 0;
        int cnt = 0;
        for (int j = parId.length - 1; j >= 0; --j) {
            if (data.get(parId[j])) {
                prob += (int)Math.pow(2.0, j);
            }
            ++cnt;
        }
        return this.nodes[next].getProbability(prob);
    }

    private int[] calculateSortedParentIds(int id) {
        List<BayNode> parents = this.getParents(this.nodes[id]);
        int[] parId = new int[parents.size()];
        int i = 0;
        for (BayNode nod : parents) {
            parId[i] = nod.getId();
            ++i;
        }
        Arrays.sort(parId);
        return parId;
    }

    private void resetCalculated() {
        for (int i = 0; i < this.dimension; ++i) {
            this.nodes[i].setCalculated(false);
        }
    }

    public boolean isACyclic(int from, int to) {
        int cnt1 = 0;
        int cnt2 = 0;
        for (int i = 0; i < this.dimension; ++i) {
            if (this.network[i][from]) {
                ++cnt1;
            }
            if (!this.network[to][i]) continue;
            ++cnt2;
        }
        if (cnt1 == 0 || cnt2 == 0) {
            return true;
        }
        List<BayNode> toCalculate = this.getChildren(this.nodes[to]);
        while (!toCalculate.isEmpty()) {
            BayNode node = toCalculate.get(0);
            toCalculate.remove(node);
            if (node.getCalculated()) continue;
            node.setCalculated(true);
            if (from == node.getId()) {
                this.resetCalculated();
                return false;
            }
            List<BayNode> children = this.getChildren(node);
            toCalculate.addAll(children);
        }
        this.resetCalculated();
        return true;
    }

    public boolean isAcyclic() {
        LinkedList<Pair<Integer, Integer>> deletedEdges = new LinkedList<Pair<Integer, Integer>>();
        List<BayNode> nodes = this.getRootNodes();
        boolean res = false;
        for (int i = 0; i <= this.dimension; ++i) {
            for (BayNode node : nodes) {
                int id = node.getId();
                for (int j = 0; j < this.dimension; ++j) {
                    if (!this.network[id][j]) continue;
                    this.network[id][j] = false;
                    deletedEdges.add(new Pair<Integer, Integer>(id, j));
                }
            }
            nodes = this.getRootNodes();
            if (nodes.size() != this.nodes.length) continue;
            res = true;
            break;
        }
        for (Pair pair : deletedEdges) {
            this.network[((Integer)pair.head).intValue()][((Integer)pair.tail).intValue()] = true;
        }
        return res;
    }

    private double getPrior(List<BayNode> parents, Population pop) {
        double result = 1.0;
        switch (this.scoringMethod) {
            case BDM: {
                result = (double)pop.size() / Math.pow(2.0, parents.size());
                break;
            }
            case K2: {
                result = 2.0;
            }
        }
        return result;
    }

    private double getPrior(List<BayNode> parents, BayNode current, Population pop) {
        double result = 1.0;
        switch (this.scoringMethod) {
            case BDM: {
                result = this.getPrior(parents, pop) / 2.0;
                break;
            }
            case K2: {
                result = 1.0;
            }
        }
        return result;
    }

    public void setUpperProbLimit(double upperProbLimit) {
        this.upperProbLimit = upperProbLimit;
    }

    public void setLowerProbLimit(double lowerProbLimit) {
        this.lowerProbLimit = lowerProbLimit;
    }

    private double gamma(double x) {
        double result = 1.0;
        result = SpecialFunction.gamma(x);
        return result;
    }

    public double getScore(Population pop) {
        double result = 0.0;
        for (int i = 0; i < this.dimension; ++i) {
            BayNode currentNode = this.nodes[i];
            List<BayNode> parents = this.getParents(currentNode);
            int[] parId = new int[]{};
            if (!parents.isEmpty()) {
                parId = this.calculateSortedParentIds(i);
            }
            double[] pTable = currentNode.getPTable();
            switch (this.scoringMethod) {
                case BIC: {
                    result -= Math.log(pop.size()) * (double)pTable.length * 2.0 / 2.0;
                    break;
                }
            }
            for (int j = 0; j < pTable.length; ++j) {
                Population pop2 = this.numberSetCorrectly(pop, j, parId);
                switch (this.scoringMethod) {
                    case BDM: {
                        result += Math.log(this.firstFractionBDM(pop, parents, pop2));
                        break;
                    }
                    case K2: {
                        result += Math.log(this.firstFractionBDM(pop, parents, pop2));
                        break;
                    }
                    case BIC: {
                        result -= this.firstFractionBIC(pop2);
                    }
                }
                if (pop2.size() <= 0) continue;
                block15: for (int k = 0; k < 2; ++k) {
                    switch (this.scoringMethod) {
                        case BDM: {
                            result += Math.log(this.secondFractionBDM(pop, currentNode, parents, j, pop2, k));
                            continue block15;
                        }
                        case K2: {
                            result += Math.log(this.secondFractionBDM(pop, currentNode, parents, j, pop2, k));
                            continue block15;
                        }
                        case BIC: {
                            result += this.secondFractionBIC(pop2, currentNode, k, j);
                        }
                    }
                }
            }
        }
        return result;
    }

    public void initScoreArray(Population pop) {
        for (int i = 0; i < this.dimension; ++i) {
            double result = 0.0;
            BayNode currentNode = this.nodes[i];
            List<BayNode> parents = this.getParents(currentNode);
            int[] parId = new int[]{};
            if (!parents.isEmpty()) {
                parId = this.calculateSortedParentIds(i);
            }
            double[] pTable = currentNode.getPTable();
            switch (this.scoringMethod) {
                case BIC: {
                    result -= Math.log(pop.size()) * (double)pTable.length * 2.0 / 2.0;
                    break;
                }
            }
            for (int j = 0; j < pTable.length; ++j) {
                Population pop2 = this.numberSetCorrectly(pop, j, parId);
                switch (this.scoringMethod) {
                    case BDM: {
                        result += Math.log(this.firstFractionBDM(pop, parents, pop2));
                        break;
                    }
                    case K2: {
                        result += Math.log(this.firstFractionBDM(pop, parents, pop2));
                        break;
                    }
                    case BIC: {
                        result -= this.firstFractionBIC(pop2);
                    }
                }
                if (pop2.size() <= 0) continue;
                block15: for (int k = 0; k < 2; ++k) {
                    switch (this.scoringMethod) {
                        case BDM: {
                            result += Math.log(this.secondFractionBDM(pop, currentNode, parents, j, pop2, k));
                            continue block15;
                        }
                        case K2: {
                            result += Math.log(this.secondFractionBDM(pop, currentNode, parents, j, pop2, k));
                            continue block15;
                        }
                        case BIC: {
                            result += this.secondFractionBIC(pop2, currentNode, k, j);
                        }
                    }
                }
            }
            this.scoreArray[i] = result;
        }
    }

    public void updateScoreArray(Population pop, int i) {
        double result = 0.0;
        BayNode currentNode = this.nodes[i];
        List<BayNode> parents = this.getParents(currentNode);
        int[] parId = new int[]{};
        if (!parents.isEmpty()) {
            parId = this.calculateSortedParentIds(i);
        }
        double[] pTable = currentNode.getPTable();
        switch (this.scoringMethod) {
            case BIC: {
                result -= Math.log(pop.size()) * (double)pTable.length * 2.0 / 2.0;
                break;
            }
        }
        for (int j = 0; j < pTable.length; ++j) {
            Population pop2 = this.numberSetCorrectly(pop, j, parId);
            switch (this.scoringMethod) {
                case BDM: {
                    result += Math.log(this.firstFractionBDM(pop, parents, pop2));
                    break;
                }
                case K2: {
                    result += Math.log(this.firstFractionBDM(pop, parents, pop2));
                    break;
                }
                case BIC: {
                    result -= this.firstFractionBIC(pop2);
                }
            }
            if (pop2.size() <= 0) continue;
            block14: for (int k = 0; k < 2; ++k) {
                switch (this.scoringMethod) {
                    case BDM: {
                        result += Math.log(this.secondFractionBDM(pop, currentNode, parents, j, pop2, k));
                        continue block14;
                    }
                    case K2: {
                        result += Math.log(this.secondFractionBDM(pop, currentNode, parents, j, pop2, k));
                        continue block14;
                    }
                    case BIC: {
                        result += this.secondFractionBIC(pop2, currentNode, k, j);
                    }
                }
            }
        }
        this.scoreArray[i] = result;
    }

    public double getNewScore(Population pop, int i) {
        double result = 0.0;
        for (int j = 0; j < this.dimension; ++j) {
            if (j == i) {
                result += this.getSingleScore(pop, i);
                continue;
            }
            result += this.scoreArray[j];
        }
        return result;
    }

    private double getSingleScore(Population pop, int i) {
        double result = 0.0;
        BayNode currentNode = this.nodes[i];
        List<BayNode> parents = this.getParents(currentNode);
        int[] parId = new int[]{};
        if (!parents.isEmpty()) {
            parId = this.calculateSortedParentIds(i);
        }
        double[] pTable = currentNode.getPTable();
        switch (this.scoringMethod) {
            case BIC: {
                result -= Math.log(pop.size()) * (double)pTable.length * 2.0 / 2.0;
                break;
            }
        }
        for (int j = 0; j < pTable.length; ++j) {
            Population pop2 = this.numberSetCorrectly(pop, j, parId);
            switch (this.scoringMethod) {
                case BDM: {
                    result += Math.log(this.firstFractionBDM(pop, parents, pop2));
                    break;
                }
                case K2: {
                    result += Math.log(this.firstFractionBDM(pop, parents, pop2));
                    break;
                }
                case BIC: {
                    result -= this.firstFractionBIC(pop2);
                }
            }
            if (pop2.size() <= 0) continue;
            block14: for (int k = 0; k < 2; ++k) {
                switch (this.scoringMethod) {
                    case BDM: {
                        result += Math.log(this.secondFractionBDM(pop, currentNode, parents, j, pop2, k));
                        continue block14;
                    }
                    case K2: {
                        result += Math.log(this.secondFractionBDM(pop, currentNode, parents, j, pop2, k));
                        continue block14;
                    }
                    case BIC: {
                        result += this.secondFractionBIC(pop2, currentNode, k, j);
                    }
                }
            }
        }
        return result;
    }

    private double secondFractionBIC(Population pop2, BayNode currentNode, int k, int j) {
        double result = 0.0;
        double Nijk = this.numberSetCorrectly(pop2, k, currentNode.getId());
        if (Nijk > 0.0) {
            result = Nijk * Math.log(Nijk);
        }
        if (k == 1) {
            double prob = Nijk / (double)pop2.size();
            this.setProbability(currentNode, j, prob);
        }
        return result;
    }

    private double firstFractionBIC(Population pop2) {
        double result = 0.0;
        if (pop2.size() > 0) {
            result = (double)pop2.size() * Math.log(pop2.size());
        }
        return result;
    }

    private double secondFractionBDM(Population pop, BayNode currentNode, List<BayNode> parents, int j, Population pop2, int k) {
        double mXiPiXi = this.numberSetCorrectly(pop2, k, currentNode.getId());
        double mDashXiPiXi = this.getPrior(parents, currentNode, pop);
        double numeratorSecondFraction = this.gamma(mDashXiPiXi + mXiPiXi);
        double denumeratorSecondFraction = this.gamma(mDashXiPiXi);
        double secondFraction = numeratorSecondFraction / denumeratorSecondFraction;
        if (k == 1) {
            double prob = mXiPiXi / (double)pop2.size();
            this.setProbability(currentNode, j, prob);
        }
        return secondFraction;
    }

    private double firstFractionBDM(Population pop, List<BayNode> parents, Population pop2) {
        double mPiXi = pop2.size();
        double mDashPiXi = this.getPrior(parents, pop);
        double numeratorFirstFraction = this.gamma(mDashPiXi);
        double denominatorFirstFraction = this.gamma(mDashPiXi + mPiXi);
        double firstFraction = numeratorFirstFraction / denominatorFirstFraction;
        return firstFraction;
    }

    private void setProbability(BayNode n, int j, double prob) {
        n.setPTable(j, Math.min(this.upperProbLimit, Math.max(this.lowerProbLimit, prob)));
    }

    private double numberSetCorrectly(Population pop, int k, int Id) {
        double result = 0.0;
        for (int i = 0; i < pop.size(); ++i) {
            AbstractEAIndividual indy = pop.getEAIndividual(i);
            BitSet data = BayNet.getBinaryData(indy);
            int val = 0;
            if (data.get(Id)) {
                val = 1;
            }
            if (val != k) continue;
            result += 1.0;
        }
        return result;
    }

    private Population numberSetCorrectly(Population pop, int j, int[] Ids) {
        Population result = new Population();
        for (int i = 0; i < pop.size(); ++i) {
            AbstractEAIndividual indy = pop.getEAIndividual(i);
            BitSet data = ((InterfaceDataTypeBinary)((Object)indy)).getBinaryData();
            boolean setCorrectly = this.isSetCorrectly(Ids, data, j);
            if (!setCorrectly) continue;
            result.add(indy);
        }
        return result;
    }

    public static BitSet intToBitSet(BitSet bitSet, int offset, int length, int value) {
        if (length > 32) {
            throw new RuntimeException("You can not set a higher length than 32 bits.");
        }
        int absValue = Math.abs(value);
        if ((double)absValue > Math.pow(2.0, ++length - 1 - 1) * 2.0 - 1.0 || value == Integer.MIN_VALUE) {
            throw new RuntimeException("The value of " + value + " does not fit into a bit string of " + (length - 1) + " bits.");
        }
        bitSet.clear(offset, offset + length - 1);
        int mask = 1;
        int i = 0;
        while (i < length) {
            if ((mask & absValue) > 0) {
                bitSet.set(offset + i);
            }
            ++i;
            mask <<= 1;
        }
        if (value < 0) {
            bitSet.set(offset + length - 1);
        }
        return bitSet;
    }

    private boolean isSetCorrectly(int[] ids, BitSet data, int j) {
        int value = 0;
        for (int i = 0; i < ids.length; ++i) {
            if (!data.get(ids[i])) continue;
            value = (int)((double)value + Math.pow(2.0, ids.length - i - 1));
        }
        return value == j;
    }

    public void print() {
        int i;
        for (i = 0; i < this.dimension; ++i) {
            for (int j = 0; j < this.dimension; ++j) {
                if (this.network[i][j]) {
                    System.out.print("1");
                    continue;
                }
                System.out.print("0");
            }
            System.out.println();
        }
        for (i = 0; i < this.dimension; ++i) {
            System.out.println(BeanInspector.toString(this.nodes[i].getPTable()));
        }
    }

    public String generateYFilesCode() {
        String result = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n";
        result = result + "<graphml xmlns=\"http://graphml.graphdrawing.org/xmlns\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:y=\"http://www.yworks.com/xml/graphml\" xmlns:yed=\"http://www.yworks.com/xml/yed/3\" xsi:schemaLocation=\"http://graphml.graphdrawing.org/xmlns http://www.yworks.com/xml/schema/graphml/1.1/ygraphml.xsd\">\n";
        result = result + "  <!--Created by yFiles for Java HEAD-Current-->\n";
        result = result + "  <key for=\"graphml\" id=\"d0\" yfiles.type=\"resources\"/>\n";
        result = result + "  <key for=\"port\" id=\"d1\" yfiles.type=\"portgraphics\"/>\n";
        result = result + "  <key for=\"port\" id=\"d2\" yfiles.type=\"portgeometry\"/>\n";
        result = result + "  <key for=\"port\" id=\"d3\" yfiles.type=\"portuserdata\"/>\n";
        result = result + "  <key attr.name=\"url\" attr.type=\"string\" for=\"node\" id=\"d4\"/>\n";
        result = result + "  <key attr.name=\"description\" attr.type=\"string\" for=\"node\" id=\"d5\"/>\n";
        result = result + "  <key for=\"node\" id=\"d6\" yfiles.type=\"nodegraphics\"/>\n";
        result = result + "  <key attr.name=\"Beschreibung\" attr.type=\"string\" for=\"graph\" id=\"d7\"/>\n";
        result = result + "  <key attr.name=\"url\" attr.type=\"string\" for=\"edge\" id=\"d8\"/>\n";
        result = result + "  <key attr.name=\"description\" attr.type=\"string\" for=\"edge\" id=\"d9\"/>\n";
        result = result + "  <key for=\"edge\" id=\"d10\" yfiles.type=\"edgegraphics\"/>\n";
        result = result + "  <graph edgedefault=\"directed\" id=\"G\">\n";
        result = result + "    <data key=\"d7\"/>\n";
        for (int i = 0; i < this.nodes.length; ++i) {
            Pair<Integer, String> pair = this.generateTable(i);
            Integer length = pair.getHead();
            String table = pair.getTail();
            int x = 40 + 100 * (i % 20);
            int y = (int)(40.0 + 100.0 * Math.floor((double)i / 20.0));
            Double height = 40.0 + 11.0 * Math.pow(2.0, length - 1);
            Double width = 40 + 10 * length;
            result = result + "    <node id=\"n" + i + "\">\n";
            result = result + "      <data key=\"d5\"/>\n";
            result = result + "      <data key=\"d6\">\n";
            result = result + "        <y:ShapeNode>\n";
            result = result + "          <y:Geometry height=\"" + height + "\" width=\"" + width + "\" x=\"" + x + "\" y=\"" + y + "\"/>\n";
            result = result + "          <y:Fill color=\"#FFCC00\" transparent=\"false\"/>\n";
            result = result + "          <y:BorderStyle color=\"#000000\" type=\"line\" width=\"1.0\"/>\n";
            result = result + "          <y:NodeLabel alignment=\"center\" autoSizePolicy=\"content\" fontFamily=\"Dialog\" fontSize=\"12\" fontStyle=\"plain\" hasBackgroundColor=\"false\" hasLineColor=\"false\" height=\"18.701171875\" modelName=\"internal\" modelPosition=\"c\" textColor=\"#000000\" visible=\"true\" width=\"10.673828125\" x=\"9.6630859375\" y=\"5.6494140625\">" + i + table + "</y:NodeLabel>\n";
            result = result + "          <y:Shape type=\"roundrectangle\"/>\n";
            result = result + "        </y:ShapeNode>\n";
            result = result + "      </data>\n";
            result = result + "    </node>\n";
        }
        int cnt = 0;
        for (int i = 0; i < this.network.length; ++i) {
            for (int j = 0; j < this.network[i].length; ++j) {
                if (!this.network[i][j]) continue;
                result = result + "    <edge id=\"e" + cnt + "\" source=\"n" + i + "\" target=\"n" + j + "\">\n";
                result = result + "      <data key=\"d9\"/>\n";
                result = result + "      <data key=\"d10\">\n";
                result = result + "        <y:PolyLineEdge>\n";
                result = result + "          <y:Path sx=\"0.0\" sy=\"0.0\" tx=\"0.0\" ty=\"0.0\"/>\n";
                result = result + "          <y:LineStyle color=\"#000000\" type=\"line\" width=\"1.0\"/>\n";
                result = result + "          <y:Arrows source=\"none\" target=\"standard\"/>\n";
                result = result + "          <y:BendStyle smoothed=\"false\"/>\n";
                result = result + "        </y:PolyLineEdge>\n";
                result = result + "      </data>\n";
                result = result + "    </edge>\n";
                ++cnt;
            }
        }
        result = result + "  </graph>\n";
        result = result + "  <data key=\"d0\">\n";
        result = result + "    <y:Resources/>\n";
        result = result + "  </data>\n";
        result = result + "</graphml>\n";
        return result;
    }

    private Pair<Integer, String> generateTable(int i) {
        String result = "";
        double[] pTable = this.nodes[i].getPTable();
        int length = Integer.toBinaryString(pTable.length).length();
        for (int j = 0; j < pTable.length; ++j) {
            result = result + "\n";
            String line = Integer.toBinaryString(j);
            while (line.length() < length - 1) {
                line = "0" + line;
            }
            line = line + ": " + pTable[j];
            result = result + line;
        }
        Pair<Integer, String> p = new Pair<Integer, String>(length, result);
        return p;
    }

    public boolean hasEdge(int i, int j) {
        return this.network[i][j];
    }

    public static void main(String[] args) {
        double val = SpecialFunction.gamma(26.0);
        double val2 = SpecialFunction.gamma(51.0);
        double val3 = SpecialFunction.gamma(24.5) / SpecialFunction.gamma(12.5);
        double val4 = SpecialFunction.gamma(25.5) / SpecialFunction.gamma(12.5);
        double erg = val / val2;
        erg = erg * val3 * val4;
        System.out.println(erg);
    }

    public void setScoringMethod(BOAScoringMethods method) {
        this.scoringMethod = method;
    }

    public BOAScoringMethods getScoringMethod() {
        return this.scoringMethod;
    }

    public int[][] adaptEdgeRate(int[][] edgeRate) {
        for (int i = 0; i < edgeRate.length; ++i) {
            for (int j = 0; j < edgeRate.length; ++j) {
                if (!this.network[i][j]) continue;
                int[] nArray = edgeRate[i];
                int n = j;
                nArray[n] = nArray[n] + 1;
            }
        }
        return edgeRate;
    }
}

