/*
 * Decompiled with CFR 0.152.
 */
package eva2.tools.math;

import Jama.Matrix;
import eva2.optimization.tools.DoubleArrayComparator;
import eva2.tools.EVAERROR;
import eva2.tools.Pair;
import eva2.tools.math.RNG;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class Mathematics {
    private Mathematics() {
    }

    public static double[][] adjoint(double[][] a) {
        if (a == null) {
            return null;
        }
        if (a.length != a[0].length) {
            return null;
        }
        double[][] b = new double[a.length][a.length];
        for (int i = 0; i < a.length; ++i) {
            for (int j = 0; j < a.length; ++j) {
                b[i][j] = Mathematics.adjoint(a, i, j);
            }
        }
        return b;
    }

    public static double adjoint(double[][] a, int k, int l) {
        return Math.pow(-1.0, k + l + 2) * Mathematics.determinant(Mathematics.submatrix(a, k, l));
    }

    public static double determinant(double[][] matrix) {
        if (matrix == null) {
            return 0.0;
        }
        if (matrix.length != matrix[0].length) {
            return 0.0;
        }
        if (matrix.length == 1) {
            return matrix[0][0];
        }
        if (matrix.length == 2) {
            return matrix[0][0] * matrix[1][1] - matrix[0][1] * matrix[1][0];
        }
        if (matrix.length == 3) {
            return matrix[0][0] * matrix[1][1] * matrix[2][2] + matrix[0][1] * matrix[1][2] * matrix[2][0] + matrix[0][2] * matrix[1][0] * matrix[2][1] - matrix[2][0] * matrix[1][1] * matrix[0][2] - matrix[2][1] * matrix[1][2] * matrix[0][0] - matrix[2][2] * matrix[1][0] * matrix[0][1];
        }
        double det = 0.0;
        for (int k = 0; k < matrix.length; ++k) {
            if (matrix[0][k] == 0.0) continue;
            det += matrix[0][k] * Mathematics.adjoint(matrix, 0, k);
        }
        return det;
    }

    public static double dist(double[] x, double[] y, int root) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("The vectors x and y must have the same dimension");
        }
        if (root == 0) {
            throw new IllegalArgumentException("There is no 0-root!");
        }
        double d = 0.0;
        for (int i = 0; i < x.length; ++i) {
            d += Math.pow(Math.abs(x[i] - y[i]), root);
        }
        return Math.pow(d, 1.0 / (double)root);
    }

    public static double euclideanDist(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("The vectors x and y must have the same dimension");
        }
        double d = 0.0;
        for (int i = 0; i < x.length; ++i) {
            d += Math.pow(Math.abs(x[i] - y[i]), 2.0);
        }
        return Math.sqrt(d);
    }

    public static double[] expandVector(double[] x, int len, double v) {
        if (len <= x.length) {
            return x;
        }
        double[] expanded = new double[len];
        System.arraycopy(x, 0, expanded, 0, x.length);
        for (int i = x.length; i < expanded.length; ++i) {
            expanded[i] = v;
        }
        return expanded;
    }

    public static void fillFront(double[] dest, double[] src) {
        System.arraycopy(src, 0, dest, 0, Math.min(dest.length, src.length));
    }

    public static double firstMultipleAbove(double len, double interval) {
        double dn = len / interval;
        double startVal = (double)Math.round(dn - 0.5) * interval;
        if (startVal < len || len == 0.0) {
            startVal += interval;
        }
        return startVal;
    }

    public static double[] getAbsRange(double[][] range) {
        double[] ret = new double[range.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = range[i][1] - range[i][0];
        }
        return ret;
    }

    public static double getAvgRange(double[][] range) {
        double sum = 0.0;
        for (int i = 0; i < range.length; ++i) {
            sum += range[i][1] - range[i][0];
        }
        return sum / (double)range.length;
    }

    public static double getRelativeLength(double[] vector, double[][] range) {
        double sumV = 0.0;
        double sumR = 0.0;
        for (int i = 0; i < range.length; ++i) {
            sumV += Math.pow(vector[i], 2.0);
            sumR += Math.pow(range[i][1] - range[i][0], 2.0);
        }
        sumV = Math.sqrt(sumV);
        sumR = Math.sqrt(sumR);
        return sumV / sumR;
    }

    public static void getRotationEntriesSingleAxis(Matrix tmp, int i, int j, double w) {
        double cosw = Math.cos(w);
        double sinw = Math.sin(w);
        tmp.set(i, i, cosw);
        tmp.set(i, j, sinw);
        tmp.set(j, i, -sinw);
        tmp.set(j, j, cosw);
    }

    public static Matrix getRotationMatrix(double w, int dim) {
        Matrix A = Matrix.identity((int)dim, (int)dim);
        Matrix tmp = Matrix.identity((int)dim, (int)dim);
        for (int i = 1; i < dim; ++i) {
            Mathematics.getRotationEntriesSingleAxis(tmp, i - 1, i, w);
            A = tmp.times(A);
            Mathematics.resetRotationEntriesSingleAxis(tmp, i - 1, i);
        }
        return A;
    }

    public static Matrix outer(double[] a, double[] b) {
        double[][] M = new double[a.length][b.length];
        for (int i = 0; i < a.length; ++i) {
            for (int j = 0; j < b.length; ++j) {
                M[i][j] = a[i] * b[j];
            }
        }
        return new Matrix(M);
    }

    public static Pair<Double, Double> getMinMaxDiag(Matrix m) {
        if (m.getRowDimension() < 1 || m.getColumnDimension() < 1) {
            return null;
        }
        double v = m.get(0, 0);
        Pair<Double, Double> ret = new Pair<Double, Double>(v, v);
        for (int i = 1; i < Math.min(m.getRowDimension(), m.getColumnDimension()); ++i) {
            v = m.get(i, i);
            ret.head = Math.min((Double)ret.head, v);
            ret.tail = Math.max((Double)ret.tail, v);
        }
        return ret;
    }

    public static double[] getColumn(Matrix m, int k) {
        double[] vals = new double[m.getRowDimension()];
        for (int i = 0; i < m.getRowDimension(); ++i) {
            vals[i] = m.get(i, k);
        }
        return vals;
    }

    public static Matrix getRotationMatrix(Matrix vec) {
        Matrix A = Matrix.identity((int)vec.getRowDimension(), (int)vec.getRowDimension());
        Matrix tmp = Matrix.identity((int)vec.getRowDimension(), (int)vec.getRowDimension());
        Matrix z = (Matrix)vec.clone();
        z.times(1.0 / z.norm2());
        for (int i = 1; i < vec.getRowDimension(); ++i) {
            double w = Math.atan2(z.get(i, 0), z.get(0, 0));
            Mathematics.getRotationEntriesSingleAxis(tmp, 0, i, w);
            A = tmp.times(A);
            z = tmp.times(z);
            Mathematics.resetRotationEntriesSingleAxis(tmp, 0, i);
        }
        return A;
    }

    public static double[] getVectorFromTo(double[] a, double[] b) {
        return Mathematics.vvSub(b, a);
    }

    public static double hyperbolicInterpolation(double x, double x0, double x1, double f0, double f1) {
        if (x1 == 0.0) {
            return Mathematics.lerp(f0, f1, (x - x0) / -x0);
        }
        double l = Mathematics.lerp(x0 / x1, 1.0, x);
        if (l == 0.0) {
            return Mathematics.linearInterpolation(x, x0, x1, f0, f1);
        }
        return Mathematics.lerp(f0, f1, x / l);
    }

    public static void intersectRange(double[][] r1, double[][] r2, double[][] destRange) {
        for (int i = 0; i < r1.length && i < r2.length; ++i) {
            destRange[i][0] = Math.max(r1[i][0], r2[i][0]);
            destRange[i][1] = Math.min(r1[i][1], r2[i][1]);
        }
    }

    public static double[][] inverse(double[][] a) {
        if (a == null) {
            return null;
        }
        if (a.length != a[0].length) {
            return null;
        }
        double det = Mathematics.determinant(a);
        if (det == 0.0) {
            return null;
        }
        double[][] b = Mathematics.adjoint(a);
        for (int i = 0; i < a.length; ++i) {
            int j = 0;
            while (j < a.length) {
                double[] dArray = b[i];
                int n = j++;
                dArray[n] = dArray[n] / det;
            }
        }
        return b;
    }

    public static boolean isFinite(double v) {
        return !Double.isInfinite(v) && !Double.isNaN(v);
    }

    public static int areFinite(double[][] v) {
        for (int i = 0; i < v.length; ++i) {
            if (Mathematics.areFinite(v[i]) < 0) continue;
            return i;
        }
        return -1;
    }

    public static int areFinite(double ... v) {
        for (int i = 0; i < v.length; ++i) {
            if (!Double.isInfinite(v[i]) && !Double.isNaN(v[i])) continue;
            return i;
        }
        return -1;
    }

    public static boolean isInRange(double v, double lower, double upper) {
        return !(v < lower) && !(v > upper);
    }

    public static boolean isInRange(double[] x, double[][] range) {
        for (int i = 0; i < x.length; ++i) {
            if (!(x[i] < range[i][0]) && !(x[i] > range[i][1])) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidVec(double[][] d) {
        for (double[] vec : d) {
            if (Mathematics.isValidVector(vec)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidVector(double[] d) {
        double sum = 0.0;
        for (int i = 0; i < d.length; ++i) {
            if (Double.isNaN(d[i])) {
                return false;
            }
            sum += Math.pow(d[i], 2.0);
        }
        if (Double.isNaN(sum)) {
            return false;
        }
        return Math.abs(sum) >= 1.0E-17;
    }

    private static double lerp(double f0, double f1, double t) {
        return f0 + (f1 - f0) * t;
    }

    public static double linearInterpolation(double x, double x0, double x1, double f0, double f1) {
        if (x1 == x0) {
            return f0;
        }
        return Mathematics.lerp(f0, f1, (x - x0) / (x1 - x0));
    }

    public static double max(double[] vals) {
        double maxVal = vals[0];
        for (int i = 1; i < vals.length; ++i) {
            maxVal = Math.max(maxVal, vals[i]);
        }
        return maxVal;
    }

    public static double mean(double[] vector) {
        if (vector.length == 0) {
            return 0.0;
        }
        double sum = Mathematics.sum(vector);
        return sum / (double)vector.length;
    }

    public static double[] meanVect(double[][] d) {
        int i;
        double[] result = new double[d[0].length];
        for (i = 0; i < d.length; ++i) {
            for (int j = 0; j < d[i].length; ++j) {
                int n = j;
                result[n] = result[n] + d[i][j];
            }
        }
        i = 0;
        while (i < result.length) {
            int n = i++;
            result[n] = result[n] / (double)d.length;
        }
        return result;
    }

    public static double median(double[] x, boolean cloneX) {
        double[] in = cloneX ? (double[])x.clone() : x;
        Arrays.sort(in);
        if (in.length == 0) {
            return Double.NaN;
        }
        if (in.length == 1) {
            return in[0];
        }
        if (in.length == 2) {
            return (in[0] + in[1]) / 2.0;
        }
        if (in.length % 2 == 1) {
            return in[in.length / 2];
        }
        return (in[in.length / 2 - 1] + in[in.length / 2]) / 2.0;
    }

    public static double[] median(List<double[]> dblArrList, boolean interpolate) {
        Collections.sort(dblArrList, new DoubleArrayComparator());
        int len = dblArrList.size();
        if (len % 2 != 0) {
            return dblArrList.get((len - 1) / 2);
        }
        double[] med = (double[])dblArrList.get(len / 2).clone();
        if (interpolate) {
            Mathematics.vvAdd(med, dblArrList.get(len / 2 + 1), med);
            Mathematics.svDiv(2.0, med, med);
        }
        return med;
    }

    public static double variance(double[] vector) {
        double mean = Mathematics.mean(vector);
        double result = 0.0;
        for (int i = 0; i < vector.length; ++i) {
            result += Math.pow(vector[i] - mean, 2.0);
        }
        return result / (double)(vector.length - 1);
    }

    public static double stdDev(double[] vector) {
        double result = Mathematics.variance(vector);
        result = Math.sqrt(result);
        return result;
    }

    public static double tTestEqSizeEqVar(double[] vector1, double[] vector2) {
        double n = vector1.length;
        double mean1 = Mathematics.mean(vector1);
        double mean2 = Mathematics.mean(vector2);
        double stdDev1 = Mathematics.stdDev(vector1);
        double stdDev2 = Mathematics.stdDev(vector2);
        double sX1X2 = Math.sqrt((Math.pow(stdDev1, 2.0) + Math.pow(stdDev2, 2.0)) / 2.0);
        return (mean1 - mean2) / (Math.sqrt(2.0 / n) * sX1X2);
    }

    public static double tTestUnEqSizeEqVar(double[] vector1, double[] vector2) {
        double n1 = vector1.length;
        double n2 = vector2.length;
        double mean1 = Mathematics.mean(vector1);
        double mean2 = Mathematics.mean(vector2);
        double stdDev1 = Mathematics.stdDev(vector1);
        double stdDev2 = Mathematics.stdDev(vector2);
        double sX1X2 = Math.sqrt(((n1 - 1.0) * Math.pow(stdDev1, 2.0) + (n2 - 1.0) * Math.pow(stdDev2, 2.0)) / (n1 + n2 - 2.0));
        return (mean1 - mean2) / (sX1X2 * Math.sqrt(1.0 / n1 + 1.0 / n2));
    }

    public static double tTestUnEqSizeUnEqVar(double[] vector1, double[] vector2) {
        double n1 = vector1.length;
        double n2 = vector2.length;
        double mean1 = Mathematics.mean(vector1);
        double mean2 = Mathematics.mean(vector2);
        double stdDev1 = Mathematics.stdDev(vector1);
        double stdDev2 = Mathematics.stdDev(vector2);
        double sX1X2 = Math.sqrt(Math.pow(stdDev1, 2.0) / n1 + Math.pow(stdDev2, 2.0) / n2);
        return (mean1 - mean2) / sX1X2;
    }

    public static double min(double[] vals) {
        double minVal = vals[0];
        for (int i = 1; i < vals.length; ++i) {
            minVal = Math.min(minVal, vals[i]);
        }
        return minVal;
    }

    public static double norm(double[] d) {
        double sqSum = 0.0;
        for (double value : d) {
            sqSum += value * value;
        }
        return Math.sqrt(sqSum);
    }

    public static double[] normalizeSum(double[] v) {
        double[] res = new double[v.length];
        Mathematics.svMult(1.0 / Mathematics.sum(v), v, res);
        return res;
    }

    public static void normalizeSum(double[] v, double[] res) {
        Mathematics.svMult(1.0 / Mathematics.sum(v), v, res);
    }

    public static double[] normVect(double[] v) {
        return Mathematics.svDiv(Mathematics.norm(v), v);
    }

    public static void normVect(double[] v, double[] res) {
        Mathematics.svDiv(Mathematics.norm(v), v, res);
    }

    public static double product(double[] vals) {
        double prod = 1.0;
        for (double val : vals) {
            prod *= val;
        }
        return prod;
    }

    public static int projectToRange(double[] x, double[][] range) {
        int viols = 0;
        if (x.length > range.length) {
            System.err.println("Invalid vector length, x is longer than range! (Mathematics.projectToRange)");
        }
        for (int i = 0; i < x.length; ++i) {
            if (x[i] < range[i][0]) {
                ++viols;
                x[i] = range[i][0];
                continue;
            }
            if (!(x[i] > range[i][1])) continue;
            ++viols;
            x[i] = range[i][1];
        }
        return viols;
    }

    public static double projectValue(double v, double min, double max) {
        double value = v < min ? min : (v > max ? max : v);
        return value;
    }

    public static double[] randomVector(int dim, double stdDev) {
        double[] vect = new double[dim];
        for (int j = 0; j < vect.length; ++j) {
            vect[j] = RNG.gaussianDouble(stdDev);
        }
        return vect;
    }

    public static int reflectBounds(double[] x, double[][] range) {
        int viols = 0;
        for (int i = 0; i < x.length; ++i) {
            double d;
            double dimLen = range[i][1] - range[i][0];
            if (dimLen <= 0.0) {
                EVAERROR.errorMsgOnce("Error in reflectBounds: empty range! (possibly multiple errors)");
                continue;
            }
            if (x[i] < range[i][0]) {
                ++viols;
                for (d = range[i][0] - x[i]; d > dimLen; d -= dimLen) {
                }
                x[i] = range[i][0] + d;
                continue;
            }
            if (!(x[i] > range[i][1])) continue;
            ++viols;
            for (d = x[i] - range[i][1]; d > dimLen; d -= dimLen) {
            }
            x[i] = range[i][1] - d;
        }
        return viols;
    }

    public static double reflectValue(double val, double step, double min, double max) {
        while (step > max - min) {
            step -= max - min;
        }
        if (val + step > max) {
            return 2.0 * max - val - step;
        }
        if (val + step < min) {
            return 2.0 * min - val - step;
        }
        return val + step;
    }

    public static double relDist(double[] x, double[] y, double def) throws Exception {
        if (x.length != y.length) {
            throw new Exception("The vectors x and y must have the same dimension");
        }
        double d = 0.0;
        for (int i = 0; i < x.length; ++i) {
            if (y[i] != 0.0) {
                d += Math.pow((x[i] - y[i]) / y[i], 2.0);
                continue;
            }
            d += def;
        }
        return d;
    }

    public static void resetRotationEntriesSingleAxis(Matrix tmp, int i, int j) {
        tmp.set(i, i, 1.0);
        tmp.set(i, j, 0.0);
        tmp.set(j, i, 0.0);
        tmp.set(j, j, 1.0);
    }

    public static void revertArray(Object[] src, Object[] dst) {
        if (dst.length >= src.length) {
            for (int i = 0; i < src.length; ++i) {
                dst[src.length - i - 1] = src[i];
            }
        } else {
            System.err.println("Mismatching array lengths!");
        }
    }

    public static void rotate(double[] vect, double alpha, int i, int j) {
        double xi = vect[i];
        double xj = vect[j];
        vect[i] = xi * Math.cos(alpha) - xj * Math.sin(alpha);
        vect[j] = xi * Math.sin(alpha) + xj * Math.cos(alpha);
    }

    public static double[] rotate(double[] x, Matrix rotMatrix) {
        if (rotMatrix != null) {
            Matrix resVec = rotMatrix.times(new Matrix(x, x.length));
            x = resVec.getColumnPackedCopy();
            return x;
        }
        return x;
    }

    public static void rotateAllAxes(double[] vect, double alpha, boolean randomize) {
        for (int i = 0; i < vect.length - 1; ++i) {
            for (int j = i + 1; j < vect.length; ++j) {
                if (randomize) {
                    Mathematics.rotate(vect, RNG.randomDouble(-alpha, alpha), i, j);
                    continue;
                }
                Mathematics.rotate(vect, alpha, i, j);
            }
        }
    }

    public static void rotateAllAxes(double[] vect, double[][] alphas) {
        for (int i = 0; i < vect.length - 1; ++i) {
            for (int j = i + 1; j < vect.length; ++j) {
                Mathematics.rotate(vect, alphas[i][j], i, j);
            }
        }
    }

    public static void scaleRange(double rangeScaleFact, double[][] range) {
        double[] intervalLengths = Mathematics.getAbsRange(range);
        double[] tmpInts = Mathematics.svMult(rangeScaleFact, intervalLengths);
        Mathematics.vvSub(tmpInts, intervalLengths, tmpInts);
        for (int i = 0; i < range.length; ++i) {
            double[] dArray = range[i];
            dArray[0] = dArray[0] - tmpInts[i] / 2.0;
            double[] dArray2 = range[i];
            dArray2[1] = dArray2[1] + tmpInts[i] / 2.0;
        }
    }

    public static void shiftRange(double[][] range, double dist) {
        for (int i = 0; i < range.length; ++i) {
            Mathematics.svAdd(dist, range[i]);
        }
    }

    public static void shiftRange(double[][] range, double[] dists) {
        for (int i = 0; i < range.length; ++i) {
            Mathematics.svAdd(dists[i], range[i]);
        }
    }

    public static double[][] submatrix(double[][] a, int k, int l) {
        double[][] b = new double[a.length - 1][a[0].length - 1];
        int m = 0;
        int n = 0;
        for (int i = 0; i < a.length; ++i) {
            if (i == k) continue;
            for (int j = 0; j < a[0].length; ++j) {
                if (j == l) continue;
                b[m][n++] = a[i][j];
            }
            ++m;
            n = 0;
        }
        return b;
    }

    public static double sum(double[] doubles) {
        double sum = 0.0;
        for (double value : doubles) {
            sum += value;
        }
        return sum;
    }

    public static int sum(int[] ints) {
        int sum = 0;
        for (int value : ints) {
            sum += value;
        }
        return sum;
    }

    public static double[] svAdd(double s, double[] v) {
        double[] res = new double[v.length];
        Mathematics.svAdd(s, v, res);
        return res;
    }

    public static void svAdd(double s, double[] v, double[] res) {
        for (int i = 0; i < v.length; ++i) {
            res[i] = v[i] + s;
        }
    }

    public static double[] svDiv(double s, double[] v) {
        double[] res = new double[v.length];
        Mathematics.svDiv(s, v, res);
        return res;
    }

    public static void svDiv(double s, double[] v, double[] res) {
        for (int i = 0; i < v.length; ++i) {
            res[i] = v[i] / s;
        }
    }

    public static double[] svMult(double s, double[] v) {
        double[] res = new double[v.length];
        Mathematics.svMult(s, v, res);
        return res;
    }

    public static void svMult(double s, double[] v, double[] res) {
        for (int i = 0; i < v.length; ++i) {
            res[i] = v[i] * s;
        }
    }

    public static void svvAddScaled(double s, double[] v, double[] w, double[] res) {
        for (int i = 0; i < v.length; ++i) {
            res[i] = s * v[i] + w[i];
        }
    }

    public static void svvAddAndScale(double s, double[] v, double[] w, double[] res) {
        for (int i = 0; i < v.length; ++i) {
            res[i] = s * (v[i] + w[i]);
        }
    }

    public static double[] vvAdd(double[] a, double[] b) {
        double[] result = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            result[i] = a[i] + b[i];
        }
        return result;
    }

    public static void vvAdd(double[] v1, double[] v2, double[] res) {
        Mathematics.vvAddOffs(v1, 0, v2, 0, res, 0, v1.length);
    }

    public static double getAvgRangeL2(double[][] range) {
        double sum = 0.0;
        for (int i = 0; i < range.length; ++i) {
            double d = range[i][1] - range[i][0];
            sum += d * d;
        }
        return Math.sqrt(sum) / 2.0;
    }

    public static void vvAddOffs(double[] v1, int v1Offs, double[] v2, int v2Offs, double[] res, int resOffs, int len) {
        for (int i = 0; i < len; ++i) {
            res[resOffs + i] = v1[v1Offs + i] + v2[v2Offs + i];
        }
    }

    public static double vvMult(double[] a, double[] b) {
        double result = 0.0;
        for (int i = 0; i < a.length; ++i) {
            result += a[i] * b[i];
        }
        return result;
    }

    public static void vvMultCw(double[] u, double[] v, double[] res) {
        for (int i = 0; i < res.length; ++i) {
            res[i] = u[i] * v[i];
        }
    }

    public static double[] vvSub(double[] a, double[] b) {
        double[] result = new double[a.length];
        Mathematics.vvSub(a, b, result);
        return result;
    }

    public static void vvSub(double[] a, double[] b, double[] res) {
        for (int i = 0; i < a.length; ++i) {
            res[i] = a[i] - b[i];
        }
    }

    public static double[] zeroes(int n) {
        return Mathematics.makeVector(0.0, n);
    }

    public static double[] makeVector(double d, int dim) {
        double[] ret = new double[dim];
        Arrays.fill(ret, d);
        return ret;
    }

    public static void scale(double scale, double[] vec) {
        int i = 0;
        while (i < vec.length) {
            int n = i++;
            vec[n] = vec[n] * scale;
        }
    }

    public static boolean contains(int[] list, int i) {
        for (int k : list) {
            if (k != i) continue;
            return true;
        }
        return false;
    }
}

