/*
 * Decompiled with CFR 0.152.
 */
package eva2.tools.math;

import eva2.tools.EVAERROR;
import eva2.tools.math.Mathematics;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Random;

public final class RNG {
    private static Random random;
    private static long randomSeed;

    public static void setRandomSeed(long newSeed) {
        randomSeed = newSeed;
        if (randomSeed == 0L) {
            RNG.setRandomSeed();
        } else {
            random = new Random();
            random.setSeed(randomSeed);
        }
    }

    public static void setRandomSeedStrict(long newSeed) {
        randomSeed = newSeed;
        random.setSeed(randomSeed);
    }

    public static void setRandomSeed() {
        randomSeed = System.currentTimeMillis();
        random = new Random();
        random.setSeed(randomSeed);
    }

    public static void setRandom(Random baseRandom) {
        random = baseRandom;
    }

    public static long getRandomSeed() {
        return randomSeed;
    }

    public static int randomInt() {
        return RNG.randomInt(0, 1);
    }

    public static int randomInt(int upperLim) {
        return RNG.randomInt(0, upperLim - 1);
    }

    public static int randomIntWithout(int ignore, int lo, int hi) {
        int result = ignore;
        while (result == ignore) {
            result = RNG.randomInt(lo, hi);
        }
        return result;
    }

    public static int randomInt(int lo, int hi) {
        if (hi < lo) {
            System.err.println("Invalid boundary values! Returning zero.");
            return -1;
        }
        int result = Math.abs(random.nextInt()) % (hi - lo + 1) + lo;
        if (result < lo || result > hi) {
            System.err.println("Error, invalid value " + result + " in RNG.randomInt! boundaries were lo/hi: " + lo + " / " + hi);
            result = Math.abs(random.nextInt() % (hi - lo + 1)) + lo;
        }
        return result;
    }

    public static int[] randomPerm(int length) {
        int i;
        ArrayList<Integer> intList = new ArrayList<Integer>(length);
        int[] result = new int[length];
        for (i = 0; i < length; ++i) {
            intList.add(i);
        }
        for (i = 0; i < length - 1; ++i) {
            int index = RNG.randomInt(intList.size());
            result[i] = (Integer)intList.get(index);
            intList.remove(index);
        }
        if (intList.size() > 1) {
            System.err.println("Error in randomPerm!");
        }
        result[length - 1] = (Integer)intList.get(0);
        return result;
    }

    public static int randomInt(Random rand, int lo, int hi) {
        if (hi < lo) {
            System.err.println("Invalid boundary values! Returning zero.");
            return -1;
        }
        int result = Math.abs(rand.nextInt()) % (hi - lo + 1) + lo;
        if (result < lo || result > hi) {
            System.err.println("Error, invalid value " + result + " in RNG.randomInt! boundaries were lo/hi: " + lo + " / " + hi);
            result = Math.abs(rand.nextInt() % (hi - lo + 1)) + lo;
        }
        return result;
    }

    public static long randomLong() {
        return RNG.randomLong(0L, 0x7FFFFFFFFFFFFFFEL);
    }

    public static long randomLong(long lo, long hi) {
        return Math.abs(random.nextLong()) % (hi - lo + 1L) + lo;
    }

    public static float randomFloat() {
        return random.nextFloat();
    }

    public static float randomFloat(float lo, float hi) {
        return (hi - lo) * random.nextFloat() + lo;
    }

    public static double randomDouble() {
        return random.nextDouble();
    }

    public static double randomDouble(double lo, double hi) {
        return (hi - lo) * random.nextDouble() + lo;
    }

    public static double randomDouble(Random rand, double lo, double hi) {
        return (hi - lo) * rand.nextDouble() + lo;
    }

    public static double[] randomDoubleArray(double[] lo, double[] hi) {
        double[] xin = new double[lo.length];
        for (int i = 0; i < lo.length; ++i) {
            xin[i] = (hi[i] - lo[i]) * random.nextDouble() + lo[i];
        }
        return xin;
    }

    public static double[] randomDoubleArray(double[][] range) {
        double[] xin = new double[range.length];
        for (int i = 0; i < xin.length; ++i) {
            xin[i] = (range[i][1] - range[i][0]) * random.nextDouble() + range[i][0];
        }
        return xin;
    }

    public static double[] randomDoubleArray(double lower, double upper, int size) {
        double[] result = new double[size];
        for (int i = 0; i < result.length; ++i) {
            result[i] = RNG.randomDouble(lower, upper);
        }
        return result;
    }

    public static double[] randomDoubleArray(Random rand, double lower, double upper, int size) {
        double[] result = new double[size];
        for (int i = 0; i < result.length; ++i) {
            result[i] = RNG.randomDouble(rand, lower, upper);
        }
        return result;
    }

    public static double[] randomDoubleArray(double[] lo, double[] hi, double[] xin) {
        for (int i = 0; i < lo.length; ++i) {
            xin[i] = (hi[i] - lo[i]) * random.nextDouble() + lo[i];
        }
        return xin;
    }

    public static int[] randomIntArray(int lower, int upper, int size) {
        int[] result = new int[size];
        for (int i = 0; i < result.length; ++i) {
            result[i] = RNG.randomInt(lower, upper);
        }
        return result;
    }

    public static int[] randomIntArray(Random rand, int lower, int upper, int size) {
        int[] result = new int[size];
        for (int i = 0; i < result.length; ++i) {
            result[i] = RNG.randomInt(rand, lower, upper);
        }
        return result;
    }

    public static boolean randomBoolean() {
        return RNG.randomInt() == 1;
    }

    public static int randomBit() {
        return RNG.randomInt();
    }

    public static BitSet randomBitSet(int cardinality, int length) {
        if (cardinality > length) {
            EVAERROR.errorMsgOnce("Error, invalid cardinality " + cardinality + " requested for bit length " + length + ", cardinality will be reduced.");
            cardinality = length;
        }
        BitSet bs = new BitSet(length);
        int[] perm = RNG.randomPerm(length);
        for (int i = 0; i < cardinality; ++i) {
            bs.set(perm[i]);
        }
        return bs;
    }

    public static BitSet randomBitSet(double pSet, int length) {
        BitSet bs = new BitSet(length);
        for (int i = 0; i < length; ++i) {
            if (!RNG.flipCoin(pSet)) continue;
            bs.set(i);
        }
        return bs;
    }

    public static boolean flipCoin(double p) {
        return RNG.randomDouble() < p;
    }

    public static float gaussianFloat(float dev) {
        return (float)random.nextGaussian() * dev;
    }

    public static double gaussianDouble(double dev) {
        return random.nextGaussian() * dev;
    }

    public static float exponentialFloat(float mean) {
        return (float)((double)(-mean) * Math.log(RNG.randomDouble()));
    }

    public static double exponentialDouble(double mean) {
        return -mean * Math.log(RNG.randomDouble());
    }

    public static double[] randHypersphere(double[] center, double radius, double nonUnif) {
        double r;
        int j;
        double[] x = new double[center.length];
        int D = center.length;
        double xLen = 0.0;
        for (j = 0; j < D; ++j) {
            x[j] = r = RNG.gaussianDouble(1.0);
            xLen += x[j] * x[j];
        }
        xLen = Math.sqrt(xLen);
        r = RNG.randomDouble();
        r = nonUnif < 0.0 ? RNG.gaussianDouble(r / 2.0) : (nonUnif > 0.0 ? Math.pow(r, nonUnif) : Math.pow(r, 1.0 / (double)D));
        for (j = 0; j < D; ++j) {
            x[j] = center[j] + radius * r * x[j] / xLen;
        }
        return x;
    }

    public static void addNoise(double[] v, double dev) {
        int i = 0;
        while (i < v.length) {
            int n = i++;
            v[n] = v[n] + RNG.gaussianDouble(dev);
        }
    }

    public static double[] gaussianVector(int n, double dev, boolean normalize) {
        double[] result = new double[n];
        RNG.gaussianVector(dev, result, normalize);
        return result;
    }

    public static double[] gaussianVector(double dev, double[] result, boolean normalize) {
        for (int i = 0; i < result.length; ++i) {
            result[i] = RNG.gaussianDouble(dev);
        }
        if (normalize) {
            Mathematics.normVect(result, result);
        }
        return result;
    }

    static {
        randomSeed = System.currentTimeMillis();
        random = new Random();
        random.setSeed(randomSeed);
    }
}

