/*
 * Decompiled with CFR 0.152.
 */
package eva2.tools.math;

import Jama.Matrix;
import java.util.ArrayList;
import java.util.Collections;

public final class StatisticUtils {
    public static double log2 = Math.log(2.0);
    public static double SMALL = 1.0E-6;

    public static double correlation(double[] y1, double[] y2) {
        int i;
        double av1 = 0.0;
        double av2 = 0.0;
        double y11 = 0.0;
        double y22 = 0.0;
        double y12 = 0.0;
        int n = y1.length;
        if (n != y2.length) {
            throw new IllegalArgumentException("Error, mismatching vectors for correlation calculation in StatisticUtils.correlation(double[], double[])");
        }
        if (n <= 1) {
            return 1.0;
        }
        for (i = 0; i < n; ++i) {
            av1 += y1[i];
            av2 += y2[i];
        }
        av1 /= (double)n;
        av2 /= (double)n;
        for (i = 0; i < n; ++i) {
            y11 += (y1[i] - av1) * (y1[i] - av1);
            y22 += (y2[i] - av2) * (y2[i] - av2);
            y12 += (y1[i] - av1) * (y2[i] - av2);
        }
        double c = y11 * y22 == 0.0 ? 1.0 : y12 / Math.sqrt(Math.abs(y11 * y22));
        return c;
    }

    public static double differentialShannon(int[] counts1, int[] counts2, int n, int countsSum1, int countsSum2) {
        double seA = 0.0;
        double seB = 0.0;
        double seAB = 0.0;
        int allSum = countsSum1 + countsSum2;
        for (int i = 0; i < n; ++i) {
            int AB = counts1[i] + counts2[i];
            seA -= StatisticUtils.xlogx((double)counts1[i] / (double)countsSum1);
            seB -= StatisticUtils.xlogx((double)counts2[i] / (double)countsSum2);
            seAB -= StatisticUtils.xlogx((double)AB / (double)allSum);
        }
        return seAB - 0.5 * (seA + seB);
    }

    public static double info(int[] counts) {
        int total = 0;
        double x = 0.0;
        for (int j = 0; j < counts.length; ++j) {
            x -= StatisticUtils.xlogx(counts[j]);
            total += counts[j];
        }
        return x + StatisticUtils.xlogx(total);
    }

    public static double shannon(int[] counts, int countsSum) {
        double x = 0.0;
        for (int j = 0; j < counts.length; ++j) {
            x -= StatisticUtils.xlogx((double)counts[j] / (double)countsSum);
        }
        return x;
    }

    public static double log2(double a) {
        return Math.log(a) / log2;
    }

    public static int maxIndex(double[] doubles) {
        double maximum = 0.0;
        int maxIndex = 0;
        for (int i = 0; i < doubles.length; ++i) {
            if (i != 0 && !(doubles[i] > maximum)) continue;
            maxIndex = i;
            maximum = doubles[i];
        }
        return maxIndex;
    }

    public static int maxIndex(int[] ints) {
        int maximum = 0;
        int maxIndex = 0;
        for (int i = 0; i < ints.length; ++i) {
            if (i != 0 && ints[i] <= maximum) continue;
            maxIndex = i;
            maximum = ints[i];
        }
        return maxIndex;
    }

    public static int minIndex(int[] ints) {
        int minimum = 0;
        int minIndex = 0;
        for (int i = 0; i < ints.length; ++i) {
            if (i != 0 && ints[i] >= minimum) continue;
            minIndex = i;
            minimum = ints[i];
        }
        return minIndex;
    }

    public static int minIndex(double[] doubles) {
        double minimum = 0.0;
        int minIndex = 0;
        for (int i = 0; i < doubles.length; ++i) {
            if (i != 0 && !(doubles[i] < minimum)) continue;
            minIndex = i;
            minimum = doubles[i];
        }
        return minIndex;
    }

    public static double variance(double[] vector, boolean finiteSet) {
        double sum = 0.0;
        double sumSquared = 0.0;
        int n = vector.length;
        if (n <= 1) {
            return 0.0;
        }
        for (double value : vector) {
            sum += value;
            sumSquared += value * value;
        }
        double denom = finiteSet ? (double)n : (double)(n - 1);
        return (sumSquared - sum * sum / (double)n) / denom;
    }

    public static double xlogx(int c) {
        if (c == 0) {
            return 0.0;
        }
        return (double)c * StatisticUtils.log2(c);
    }

    public static double xlogx(double c) {
        if (c == 0.0) {
            return 0.0;
        }
        return c * StatisticUtils.log2(c);
    }

    public static boolean eq(double a, double b) {
        return a - b < SMALL && b - a < SMALL;
    }

    public static boolean smOrEq(double a, double b) {
        return a - b < SMALL;
    }

    public static boolean grOrEq(double a, double b) {
        return b - a < SMALL;
    }

    public static boolean sm(double a, double b) {
        return b - a > SMALL;
    }

    public static boolean gr(double a, double b) {
        return a - b > SMALL;
    }

    public static double rmsError(double[] array1, double[] array2) {
        if (array1 == null || array2 == null) {
            return -1.0;
        }
        double errorValueRMS = 0.0;
        for (int i = 0; i < array1.length; ++i) {
            errorValueRMS += (array1[i] - array2[i]) * (array1[i] - array2[i]);
        }
        errorValueRMS = Math.sqrt(errorValueRMS / (double)array1.length);
        return errorValueRMS;
    }

    public static double getCorrelationCoefficient(double[] array1, double[] array2) {
        if (array1 == null || array2 == null) {
            return -2.0;
        }
        double sumA = 0.0;
        double sumB = 0.0;
        double sumAB = 0.0;
        double sumAA = 0.0;
        double sumBB = 0.0;
        for (int i = 0; i < array1.length; ++i) {
            double a = array1[i];
            double b = array2[i];
            sumA += a;
            sumB += b;
            sumAA += a * a;
            sumBB += b * b;
            sumAB += a * b;
        }
        double n = array1.length;
        double numerator = sumAB - sumA * sumB / n;
        double denominator = Math.sqrt((sumAA - sumA * sumA / n) * (sumBB - sumB * sumB / n));
        double corrCoefficient = numerator / denominator;
        corrCoefficient *= corrCoefficient;
        return corrCoefficient;
    }

    public static double entropy(double[] array) {
        double returnValue = 0.0;
        double sum = 0.0;
        for (int i = 0; i < array.length; ++i) {
            returnValue -= StatisticUtils.lnFunc(array[i]);
            sum += array[i];
        }
        if (StatisticUtils.eq(sum, 0.0)) {
            return 0.0;
        }
        return (returnValue + StatisticUtils.lnFunc(sum)) / (sum * log2);
    }

    private static double lnFunc(double num) {
        if (num < 1.0E-7) {
            return 0.0;
        }
        return num * Math.log(num);
    }

    public static Matrix rlh(int samples, double[][] range, boolean edges) {
        Matrix rlhM = StatisticUtils.rlh(samples, range.length, 0.0, 1.0, edges);
        for (int j = 0; j < samples; ++j) {
            for (int i = 0; i < range.length; ++i) {
                rlhM.set(j, i, range[i][0] + rlhM.get(j, i) * (range[i][1] - range[i][0]));
            }
        }
        return rlhM;
    }

    public static Matrix rlh(int samples, int dim, double lb, double ub, boolean edges) {
        double v;
        int j;
        int i;
        Matrix X = new Matrix(samples, dim);
        ArrayList<Integer> indices = new ArrayList<Integer>(samples);
        for (i = 0; i < samples; ++i) {
            indices.add(i);
        }
        for (i = 0; i < dim; ++i) {
            Collections.shuffle(indices);
            for (j = 0; j < indices.size(); ++j) {
                X.set(j, i, (double)((Integer)indices.get(j)).intValue());
            }
        }
        if (edges) {
            for (i = 0; i < X.getRowDimension(); ++i) {
                for (j = 0; j < X.getColumnDimension(); ++j) {
                    v = X.get(i, j);
                    X.set(i, j, v /= (double)(samples - 1));
                }
            }
        } else {
            for (i = 0; i < X.getRowDimension(); ++i) {
                for (j = 0; j < X.getColumnDimension(); ++j) {
                    v = X.get(i, j);
                    v = (v + 0.5) / (double)samples;
                    X.set(i, j, v);
                }
            }
        }
        for (i = 0; i < X.getRowDimension(); ++i) {
            for (j = 0; j < X.getColumnDimension(); ++j) {
                v = X.get(i, j);
                v = (ub - lb) * v + lb;
                X.set(i, j, v);
            }
        }
        return X;
    }

    public static ArrayList<Matrix> rlhPoints(int samples, int dim, double lb, double ub, boolean edges) {
        ArrayList<Matrix> samplePoints = new ArrayList<Matrix>(samples);
        Matrix p = StatisticUtils.rlh(samples, dim, lb, ub, edges);
        for (int i = 0; i < samples; ++i) {
            Matrix x = new Matrix(dim, 1);
            for (int j = 0; j < dim; ++j) {
                x.set(j, 0, p.get(i, j));
            }
            samplePoints.add(x);
        }
        return samplePoints;
    }

    public static ArrayList<Matrix> rlhPoints(int samples, double[][] range, boolean edges) {
        ArrayList<Matrix> rlhM = StatisticUtils.rlhPoints(samples, range.length, 0.0, 1.0, edges);
        for (int i = 0; i < rlhM.size(); ++i) {
            Matrix p = rlhM.get(i);
            for (int j = 0; j < range.length; ++j) {
                p.set(j, 0, range[j][0] + p.get(j, 0) * (range[j][1] - range[j][0]));
            }
        }
        return rlhM;
    }
}

