/*
 * Decompiled with CFR 0.152.
 */
package eva2.tools.print;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class PagePrinter {
    Component c;
    Graphics g;
    PageFormat pf;
    public boolean fit_in_possible = true;

    public PagePrinter(Component c, Graphics g, PageFormat pf) {
        this.c = c;
        this.g = g;
        this.pf = pf;
    }

    public int print() {
        Dimension old = this.c.getSize();
        int x = (int)this.pf.getImageableX();
        int y = (int)this.pf.getImageableY();
        this.g.translate(x, y);
        double w = (int)this.pf.getImageableWidth();
        double h = (int)this.pf.getImageableHeight();
        if ((double)old.width > w || (double)old.height > h) {
            boolean rec_turn = false;
            boolean rec_fit_in = false;
            if (old.width > old.height && h > w || old.width < old.height && h < w) {
                rec_turn = true;
                if ((double)old.width > h || (double)old.height > w) {
                    rec_fit_in = true;
                }
            } else {
                rec_fit_in = true;
            }
            JLabel[] text = new JLabel[4];
            text[0] = new JLabel("The component which should be printed");
            text[1] = new JLabel("is too large.");
            text[2] = new JLabel("You can choose if the component should be");
            JCheckBox cbFitIn = new JCheckBox("fitted-in", rec_fit_in);
            JCheckBox cbTurn = new JCheckBox("turned", rec_turn);
            text[3] = new JLabel("(Recommended choice is pre-selected)");
            if (!this.fit_in_possible) {
                cbFitIn.setEnabled(false);
                cbFitIn.setSelected(false);
            }
            GridBagLayout gbl = new GridBagLayout();
            JPanel panel = new JPanel(gbl);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridy = 0;
            gbc.gridx = 0;
            gbc.weighty = 0.5;
            gbc.weightx = 0.5;
            gbc.gridwidth = 2;
            gbl.setConstraints(text[0], gbc);
            panel.add(text[0]);
            ++gbc.gridy;
            gbl.setConstraints(text[1], gbc);
            panel.add(text[1]);
            ++gbc.gridy;
            gbl.setConstraints(text[2], gbc);
            panel.add(text[2]);
            ++gbc.gridy;
            gbc.gridwidth = 1;
            gbl.setConstraints(cbFitIn, gbc);
            panel.add(cbFitIn);
            ++gbc.gridx;
            gbl.setConstraints(cbTurn, gbc);
            panel.add(cbTurn);
            gbc.gridx = 0;
            gbc.gridwidth = 2;
            ++gbc.gridy;
            gbl.setConstraints(text[3], gbc);
            panel.add(text[3]);
            int choice = JOptionPane.showOptionDialog(this.c, panel, "Fit-in", 2, 3, null, null, null);
            if (choice == 2 || choice == -1) {
                return 1;
            }
            if (choice == 0) {
                if (cbTurn.isSelected()) {
                    BufferedImage img;
                    if (cbFitIn.isSelected()) {
                        double m = Math.min(h / (double)old.width, w / (double)old.height);
                        img = (BufferedImage)this.c.createImage((int)((double)old.height * m), (int)((double)old.width * m));
                        Graphics2D g2 = img.createGraphics();
                        g2.rotate(Math.toRadians(90.0));
                        g2.translate(0.0, (double)(-old.height) * m);
                        this.c.setSize((int)((double)old.width * m), (int)((double)old.height * m));
                        this.c.paint(g2);
                        this.c.setSize(old);
                    } else {
                        img = (BufferedImage)this.c.createImage(old.height, old.width);
                        Graphics2D g2 = img.createGraphics();
                        g2.rotate(Math.toRadians(90.0));
                        g2.translate(0, -old.height);
                        this.c.paint(g2);
                    }
                    this.g.drawImage(img, 0, 0, this.c.getBackground(), this.c);
                } else if (cbFitIn.isSelected()) {
                    double m = Math.min(w / (double)old.width, h / (double)old.height);
                    this.c.setSize((int)((double)old.width * m), (int)((double)old.height * m));
                    this.c.paint(this.g);
                    this.c.setSize(old);
                } else {
                    this.c.paint(this.g);
                }
            }
        } else {
            this.c.paint(this.g);
        }
        return 0;
    }
}

