/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.hal;

import de.otto.edison.hal.Link;
import java.util.List;
import java.util.Optional;

public class CuriTemplate {
    private static final String REL_PLACEHOLDER = "{rel}";
    private final String relPrefix;
    private final String curiedRelPrefix;
    private final String relSuffix;
    private final Link curi;

    private CuriTemplate(Link curi) {
        if (!curi.getRel().equals("curies") || curi.getName().length() == 0) {
            throw new IllegalArgumentException("Parameter is not a CURI link.");
        }
        if (!curi.getHref().contains(REL_PLACEHOLDER)) {
            throw new IllegalArgumentException("Href of the CURI does not contain the required {rel} placeholder.");
        }
        String curiHref = curi.getHref();
        this.relPrefix = curi.getHref().substring(0, curiHref.indexOf(REL_PLACEHOLDER));
        this.curiedRelPrefix = curi.getName() + ":";
        this.relSuffix = curi.getHref().substring(curiHref.indexOf(REL_PLACEHOLDER) + REL_PLACEHOLDER.length(), curiHref.length());
        this.curi = curi;
    }

    public static CuriTemplate curiTemplateFor(Link curi) {
        return new CuriTemplate(curi);
    }

    public static Optional<CuriTemplate> matchingCuriTemplateFor(List<Link> curies, String rel) {
        return curies.stream().map(CuriTemplate::curiTemplateFor).filter(t -> t.isMatching(rel)).findAny();
    }

    public boolean isMatching(String rel) {
        return this.isMatchingExpandedRel(rel) || this.isMatchingCuriedRel(rel);
    }

    public boolean isMatchingCuriedRel(String rel) {
        return rel.startsWith(this.curiedRelPrefix);
    }

    public boolean isMatchingExpandedRel(String rel) {
        return rel.startsWith(this.relPrefix) && rel.endsWith(this.relSuffix);
    }

    public String relPlaceHolderFrom(String rel) {
        if (this.isMatchingCuriedRel(rel)) {
            return rel.substring(this.curiedRelPrefix.length());
        }
        if (this.isMatchingExpandedRel(rel)) {
            return rel.substring(this.relPrefix.length(), rel.length() - this.relSuffix.length());
        }
        throw new IllegalArgumentException("Rel does not match the CURI template.");
    }

    public String curiedRelFrom(String rel) {
        if (this.isMatchingCuriedRel(rel)) {
            return rel;
        }
        if (this.isMatchingExpandedRel(rel)) {
            return this.curi.getName() + ":" + this.relPlaceHolderFrom(rel);
        }
        throw new IllegalArgumentException("Rel does not match the CURI template.");
    }

    public String expandedRelFrom(String rel) {
        if (this.isMatchingCuriedRel(rel)) {
            return this.curi.getHrefAsTemplate().set("rel", (Object)this.relPlaceHolderFrom(rel)).expand();
        }
        if (this.isMatchingExpandedRel(rel)) {
            return rel;
        }
        throw new IllegalArgumentException("Rel does not match the CURI template.");
    }

    public Link getCuri() {
        return this.curi;
    }
}

