/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.hal;

import de.otto.edison.hal.CuriTemplate;
import de.otto.edison.hal.Link;
import de.otto.edison.hal.Links;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class Curies {
    private final List<Link> curies;

    private Curies() {
        this.curies = new ArrayList<Link>();
    }

    private Curies(List<Link> curies) {
        this.curies = new ArrayList<Link>();
        curies.forEach(this::register);
    }

    private Curies(Curies other) {
        this.curies = new ArrayList<Link>(other.curies);
    }

    public static Curies emptyCuries() {
        return new Curies();
    }

    public static Curies curies(Links links) {
        List<Link> curies = links.getLinksBy("curies");
        return Curies.curies(curies);
    }

    public static Curies curies(List<Link> curies) {
        return new Curies(curies);
    }

    public static Curies copyOf(Curies other) {
        return new Curies(other);
    }

    public void register(Link curi) {
        if (!curi.getRel().equals("curies")) {
            throw new IllegalArgumentException("Link must be a CURI");
        }
        boolean alreadyRegistered = this.curies.stream().anyMatch(link -> link.getHref().equals(curi.getHref()));
        if (alreadyRegistered) {
            this.curies.removeIf(link -> link.getName().equals(curi.getName()));
            this.curies.replaceAll(link -> link.getName().equals(curi.getName()) ? curi : link);
        }
        this.curies.add(curi);
    }

    public Curies mergeWith(Curies other) {
        Curies merged = Curies.copyOf(this);
        other.curies.forEach(merged::register);
        return merged;
    }

    public String resolve(String rel) {
        Optional<CuriTemplate> curiTemplate = CuriTemplate.matchingCuriTemplateFor(this.curies, rel);
        return curiTemplate.map(t -> t.curiedRelFrom(rel)).orElse(rel);
    }

    public String expand(String rel) {
        if (rel.contains(":")) {
            String name = rel.substring(0, rel.indexOf(":"));
            Optional<Link> curi = this.curies.stream().filter(c -> c.getName().equals(name)).findAny();
            return curi.map(c -> c.getHrefAsTemplate().set("rel", (Object)rel.substring(rel.indexOf(":") + 1)).expand()).orElse(rel);
        }
        return rel;
    }

    public List<Link> getCuries() {
        return this.curies;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Curies that = (Curies)o;
        return Objects.equals(this.curies, that.curies);
    }

    public int hashCode() {
        return Objects.hash(this.curies);
    }

    public String toString() {
        return "Curies{curies=" + this.curies + '}';
    }
}

