/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.hal;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import de.otto.edison.hal.Curies;
import de.otto.edison.hal.HalRepresentation;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@JsonSerialize(using=EmbeddedSerializer.class)
@JsonDeserialize(using=EmbeddedDeserializer.class)
public class Embedded {
    private final Map<String, Object> items;
    private final Curies curies;

    Embedded() {
        this.items = null;
        this.curies = Curies.emptyCuries();
    }

    private Embedded(Map<String, Object> items) {
        this.items = items;
        this.curies = Curies.emptyCuries();
    }

    private Embedded(Map<String, Object> items, Curies curies) {
        LinkedHashMap<String, Object> curiedItems = new LinkedHashMap<String, Object>();
        for (String rel : items.keySet()) {
            Object itemOrListOfItems = items.get(rel);
            if (itemOrListOfItems instanceof List) {
                curiedItems.put(curies.resolve(rel), ((List)itemOrListOfItems).stream().map(halRepresentation -> halRepresentation.mergeWithEmbedding(curies)).collect(Collectors.toList()));
                continue;
            }
            curiedItems.put(curies.resolve(rel), ((HalRepresentation)itemOrListOfItems).mergeWithEmbedding(curies));
        }
        this.items = curiedItems;
        this.curies = curies;
    }

    public static Embedded emptyEmbedded() {
        return new Embedded(null);
    }

    public static Embedded embedded(String rel, HalRepresentation embeddedItem) {
        return new Embedded(Collections.singletonMap(rel, embeddedItem));
    }

    public static Embedded embedded(String rel, List<? extends HalRepresentation> embeddedRepresentations) {
        return new Embedded(Collections.singletonMap(rel, new ArrayList<HalRepresentation>(embeddedRepresentations)));
    }

    public boolean hasItem(String rel) {
        String resolvedRel = this.curies.resolve(rel);
        return this.items != null && this.items.containsKey(resolvedRel);
    }

    public boolean isArray(String rel) {
        String resolvedRel = this.curies.resolve(rel);
        return this.hasItem(rel) && this.items.get(resolvedRel) instanceof List;
    }

    public static Builder embeddedBuilder() {
        return new Builder();
    }

    protected Embedded using(Curies curies) {
        return new Embedded(this.items, curies);
    }

    @JsonIgnore
    public Set<String> getRels() {
        return this.items != null ? this.items.keySet() : Collections.emptySet();
    }

    @JsonIgnore
    public List<HalRepresentation> getItemsBy(String rel) {
        if (!this.hasItem(rel)) {
            return Collections.emptyList();
        }
        Object item = this.items.get(this.curies.resolve(rel));
        return item instanceof List ? (List<HalRepresentation>)item : Collections.singletonList((HalRepresentation)item);
    }

    @JsonIgnore
    public <E extends HalRepresentation> List<E> getItemsBy(String rel, Class<E> asType) {
        return this.getItemsBy(rel).stream().map(asType::cast).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Embedded embedded = (Embedded)o;
        return this.items != null ? this.items.equals(embedded.items) : embedded.items == null;
    }

    public int hashCode() {
        return this.items != null ? this.items.hashCode() : 0;
    }

    public String toString() {
        return "Embedded{items=" + this.items + '}';
    }

    public boolean isEmpty() {
        return this.items == null || this.items.isEmpty();
    }

    public static class EmbeddedDeserializer
    extends JsonDeserializer<Embedded> {
        private static final TypeReference<Map<String, List<HalRepresentation>>> TYPE_REF_LIST_OF_HAL_REPRESENTATIONS = new TypeReference<Map<String, List<HalRepresentation>>>(){};

        public Embedded deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            try {
                Map items = (Map)p.readValueAs(TYPE_REF_LIST_OF_HAL_REPRESENTATIONS);
                return new Embedded(items);
            }
            catch (JsonMappingException e) {
                if (e.getMessage().contains("Can not deserialize instance of java.util.ArrayList out of START_OBJECT token")) {
                    throw new JsonMappingException((Closeable)p, "Can not deserialize single embedded items for a link-relation type. Try using the HalParser, or configure your ObjectMapper: 'objectMapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true)'.", (Throwable)e);
                }
                throw e;
            }
        }
    }

    public static class EmbeddedSerializer
    extends JsonSerializer<Embedded> {
        public void serialize(Embedded value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeObject((Object)value.items);
        }
    }

    public static final class Builder {
        private final Map<String, Object> _embedded = new LinkedHashMap<String, Object>();
        private Curies curies = Curies.emptyCuries();

        public static Builder copyOf(Embedded embedded) {
            Builder builder = new Builder();
            if (embedded != null && embedded.items != null) {
                builder._embedded.putAll(embedded.items);
            }
            return builder;
        }

        public Builder with(String rel, List<? extends HalRepresentation> embeddedRepresentations) {
            this._embedded.put(rel, new ArrayList<HalRepresentation>(embeddedRepresentations));
            return this;
        }

        public Builder with(String rel, HalRepresentation embeddedRepresentation) {
            this._embedded.put(rel, embeddedRepresentation);
            return this;
        }

        public Builder without(String rel) {
            this._embedded.remove(rel);
            return this;
        }

        public Builder using(Curies curies) {
            this.curies = curies;
            return this;
        }

        public Embedded build() {
            return this._embedded.isEmpty() ? Embedded.emptyEmbedded() : new Embedded(this._embedded, this.curies);
        }
    }
}

