/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.hal;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonNode;
import de.otto.edison.hal.Curies;
import de.otto.edison.hal.Embedded;
import de.otto.edison.hal.Link;
import de.otto.edison.hal.Links;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonPropertyOrder(alphabetic=false)
public class HalRepresentation {
    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private volatile Links links;
    @JsonProperty(value="_embedded")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private volatile Embedded embedded;
    @JsonAnySetter
    private Map<String, JsonNode> attributes = new LinkedHashMap<String, JsonNode>();
    @JsonIgnore
    private volatile Curies curies;

    public HalRepresentation() {
        this(null, null, Curies.emptyCuries());
    }

    public HalRepresentation(Links links) {
        this(links, null, Curies.emptyCuries());
    }

    @Deprecated
    public HalRepresentation(Links links, Curies curies) {
        this(links, null, curies);
    }

    @JsonCreator
    public HalRepresentation(@JsonProperty(value="_links") Links links, @JsonProperty(value="_embedded") Embedded embedded) {
        this.curies = Curies.emptyCuries();
        this.links = links == null || links.isEmpty() ? null : links.using(this.curies);
        this.embedded = embedded == null || embedded.isEmpty() ? null : embedded.using(this.curies);
    }

    @Deprecated
    public HalRepresentation(Links links, Embedded embedded, Curies curies) {
        this.curies = curies;
        this.links = links == null || links.isEmpty() ? null : links.using(this.curies);
        this.embedded = embedded == null || embedded.isEmpty() ? null : embedded.using(this.curies);
    }

    Curies getCuries() {
        return this.curies;
    }

    @JsonIgnore
    public Links getLinks() {
        return this.links != null ? this.links : Links.emptyLinks();
    }

    protected HalRepresentation add(Links links) {
        Links links2 = this.links = this.links != null ? Links.copyOf(this.links).with(links).build() : links.using(this.curies);
        if (this.embedded != null) {
            this.embedded = this.embedded.using(this.curies);
        }
        return this;
    }

    @JsonIgnore
    public Embedded getEmbedded() {
        return this.embedded != null ? this.embedded : Embedded.emptyEmbedded();
    }

    @JsonAnyGetter
    public Map<String, JsonNode> getAttributes() {
        if (!this.attributes.isEmpty()) {
            LinkedHashMap<String, JsonNode> orderedMap = new LinkedHashMap<String, JsonNode>();
            ArrayList<String> keys = new ArrayList<String>(this.attributes.keySet());
            Collections.reverse(keys);
            keys.forEach(k -> orderedMap.put((String)k, this.attributes.get(k)));
            return orderedMap;
        }
        return this.attributes;
    }

    @JsonIgnore
    public JsonNode getAttribute(String name) {
        return this.attributes.get(name);
    }

    protected HalRepresentation withEmbedded(String rel, List<? extends HalRepresentation> embeddedItems) {
        this.embedded = Embedded.Builder.copyOf(this.embedded).with(rel, embeddedItems).using(this.curies).build();
        return this;
    }

    protected HalRepresentation withEmbedded(String rel, HalRepresentation embeddedItem) {
        this.embedded = Embedded.Builder.copyOf(this.embedded).with(rel, embeddedItem).using(this.curies).build();
        return this;
    }

    HalRepresentation mergeWithEmbedding(Curies curies) {
        this.curies = this.curies.mergeWith(curies);
        if (this.links != null) {
            this.removeDuplicateCuriesFromEmbedding(curies);
            this.links = this.links.using(this.curies);
            if (this.embedded != null) {
                this.embedded = this.embedded.using(this.curies);
            }
        } else if (this.embedded != null) {
            this.embedded = this.embedded.using(curies);
        }
        return this;
    }

    private void removeDuplicateCuriesFromEmbedding(Curies curies) {
        if (this.links.hasLink("curies")) {
            ArrayList<Link> curiLinks = new ArrayList<Link>(this.links.getLinksBy("curies"));
            curies.getCuries().forEach(curi -> curiLinks.removeIf(link -> link.isEquivalentTo((Link)curi)));
            this.links = Links.copyOf(this.links).replace("curies", curiLinks).build();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HalRepresentation that = (HalRepresentation)o;
        if (this.links != null ? !this.links.equals(that.links) : that.links != null) {
            return false;
        }
        return this.embedded != null ? this.embedded.equals(that.embedded) : that.embedded == null;
    }

    public int hashCode() {
        int result = this.links != null ? this.links.hashCode() : 0;
        result = 31 * result + (this.embedded != null ? this.embedded.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "HalRepresentation{links=" + this.links + ", embedded=" + this.embedded + '}';
    }
}

