/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.hal;

import com.damnhandy.uri.template.UriTemplate;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
public class Link {
    @JsonIgnore
    private String rel;
    @JsonProperty
    private String href;
    @JsonProperty
    private Boolean templated;
    @JsonProperty
    private String type;
    @JsonProperty
    private String hreflang;
    @JsonProperty
    private String title;
    @JsonProperty
    private String name;
    @JsonProperty
    private String deprecation;
    @JsonProperty
    private String profile;

    private Link(String rel, String href) {
        this(rel, href, null, null, null, null, null, null);
    }

    private Link(String rel, String href, String type, String hrefLang, String title, String name, String profile, String deprecation) {
        this.rel = rel;
        this.href = href;
        this.type = type;
        this.hreflang = hrefLang;
        this.title = title;
        this.name = name;
        this.profile = profile;
        this.deprecation = deprecation;
        if (UriTemplate.fromTemplate((String)href).getVariables().length > 0) {
            this.templated = Boolean.TRUE;
        }
    }

    public static Link self(String href) {
        return new Link("self", href);
    }

    public static Link curi(String name, String relTemplate) {
        if (!relTemplate.contains("{rel}")) {
            throw new IllegalArgumentException("Not a CURI template. Template is required to contain a {rel} placeholder");
        }
        return new Link("curies", relTemplate, null, null, null, name, null, null);
    }

    public static Link profile(String href) {
        return new Link("profile", href);
    }

    public static Link item(String href) {
        return new Link("item", href);
    }

    public static Link collection(String href) {
        return new Link("collection", href);
    }

    public static Link link(String rel, String href) {
        return new Link(rel, href);
    }

    public static Builder linkBuilder(String rel, String href) {
        return new Builder(rel, href);
    }

    public static Builder copyOf(Link prototype) {
        return new Builder(prototype.rel, prototype.href).withType(prototype.type).withProfile(prototype.profile).withTitle(prototype.title).withName(prototype.name).withDeprecation(prototype.deprecation).withHrefLang(prototype.hreflang);
    }

    @JsonIgnore
    public String getRel() {
        return this.rel;
    }

    @JsonIgnore
    public String getHref() {
        return this.href;
    }

    @JsonIgnore
    public UriTemplate getHrefAsTemplate() {
        return UriTemplate.fromTemplate((String)this.href);
    }

    @JsonIgnore
    public boolean isTemplated() {
        return this.templated != null ? this.templated : false;
    }

    @JsonIgnore
    public String getType() {
        return this.type != null ? this.type : "";
    }

    @JsonIgnore
    public String getHreflang() {
        return this.hreflang != null ? this.hreflang : "";
    }

    @JsonIgnore
    public String getTitle() {
        return this.title != null ? this.title : "";
    }

    @JsonIgnore
    public String getName() {
        return this.name != null ? this.name : "";
    }

    @JsonIgnore
    public String getProfile() {
        return this.profile != null ? this.profile : "";
    }

    @JsonIgnore
    public String getDeprecation() {
        return this.deprecation != null ? this.deprecation : "";
    }

    public boolean isEquivalentTo(Link other) {
        return this.getRel().equals(other.getRel()) && this.getHref().equals(other.getHref()) && this.getType().equals(other.getType()) && this.getProfile().equals(other.getProfile());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Link link = (Link)o;
        if (this.rel != null ? !this.rel.equals(link.rel) : link.rel != null) {
            return false;
        }
        if (this.href != null ? !this.href.equals(link.href) : link.href != null) {
            return false;
        }
        if (this.templated != null ? !this.templated.equals(link.templated) : link.templated != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(link.type) : link.type != null) {
            return false;
        }
        if (this.hreflang != null ? !this.hreflang.equals(link.hreflang) : link.hreflang != null) {
            return false;
        }
        if (this.title != null ? !this.title.equals(link.title) : link.title != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(link.name) : link.name != null) {
            return false;
        }
        if (this.profile != null ? !this.profile.equals(link.profile) : link.profile != null) {
            return false;
        }
        return this.deprecation != null ? this.deprecation.equals(link.deprecation) : link.deprecation == null;
    }

    public int hashCode() {
        int result = this.rel != null ? this.rel.hashCode() : 0;
        result = 31 * result + (this.href != null ? this.href.hashCode() : 0);
        result = 31 * result + (this.templated != null ? this.templated.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.hreflang != null ? this.hreflang.hashCode() : 0);
        result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.profile != null ? this.profile.hashCode() : 0);
        result = 31 * result + (this.deprecation != null ? this.deprecation.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Link{rel='" + this.getRel() + '\'' + ", href='" + this.getHref() + '\'' + ", templated=" + this.isTemplated() + ", type='" + this.getType() + '\'' + ", hreflang='" + this.getHreflang() + '\'' + ", title='" + this.getTitle() + '\'' + ", name='" + this.getName() + '\'' + ", profile='" + this.getProfile() + '\'' + ", deprecation=" + this.getDeprecation() + '}';
    }

    public static class Builder {
        private String rel;
        private String href;
        private String type;
        private String hrefLang;
        private String title;
        private String name;
        private String profile;
        private String deprecation;

        private Builder(String rel, String href) {
            this.rel = rel;
            this.href = href;
        }

        public Builder withRel(String rel) {
            if (rel == null || rel.isEmpty()) {
                throw new IllegalArgumentException("The link-relation type is mandatory");
            }
            this.rel = rel;
            return this;
        }

        public Builder withHref(String href) {
            if (this.rel == null || this.rel.isEmpty()) {
                throw new IllegalArgumentException("The href parameter is mandatory");
            }
            this.href = href;
            return this;
        }

        public Builder withType(String type) {
            this.type = type;
            return this;
        }

        public Builder withHrefLang(String hrefLang) {
            this.hrefLang = hrefLang;
            return this;
        }

        public Builder withTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withProfile(String profile) {
            this.profile = profile;
            return this;
        }

        public Builder withDeprecation(String deprecation) {
            this.deprecation = deprecation;
            return this;
        }

        public Link build() {
            return new Link(this.rel, this.href, this.type, this.hrefLang, this.title, this.name, this.profile, this.deprecation);
        }
    }
}

