/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.hal;

import de.otto.edison.hal.Link;
import java.util.function.Predicate;

public final class LinkPredicates {
    private LinkPredicates() {
    }

    public static Predicate<Link> always() {
        return link -> true;
    }

    public static Predicate<Link> havingType(String type) {
        return link -> type.equals(link.getType());
    }

    public static Predicate<Link> optionallyHavingType(String type) {
        return LinkPredicates.havingType(type).or(LinkPredicates.havingType(""));
    }

    public static Predicate<Link> havingProfile(String profile) {
        return link -> profile.equals(link.getProfile());
    }

    public static Predicate<Link> optionallyHavingProfile(String profile) {
        return LinkPredicates.havingProfile(profile).or(LinkPredicates.havingProfile(""));
    }

    public static Predicate<Link> havingName(String name) {
        return link -> name.equals(link.getName());
    }

    public static Predicate<Link> optionallyHavingName(String name) {
        return LinkPredicates.havingName(name).or(LinkPredicates.havingName(""));
    }
}

