/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.hal;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import de.otto.edison.hal.Curies;
import de.otto.edison.hal.Link;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@JsonSerialize(using=LinksSerializer.class)
@JsonDeserialize(using=LinksDeserializer.class)
public class Links {
    private static final String CURIES_REL = "curies";
    private final Map<String, Object> links = new LinkedHashMap<String, Object>();
    private final Curies curies;

    Links() {
        this.curies = Curies.emptyCuries();
    }

    private Links(Map<String, Object> links, Curies curies) {
        this.curies = curies;
        List<Link> curiLinks = links.getOrDefault(CURIES_REL, Collections.emptyList());
        curiLinks.forEach(this.curies::register);
        links.keySet().forEach(rel -> this.links.put(curies.resolve((String)rel), links.get(rel)));
    }

    Links using(Curies curies) {
        return new Links(this.links, curies);
    }

    public static Links emptyLinks() {
        return new Links();
    }

    public static Builder linkingTo() {
        return new Builder();
    }

    public static Builder copyOf(Links prototype) {
        return new Builder().with(prototype);
    }

    public Stream<Link> stream() {
        return this.links.values().stream().map(obj -> {
            if (obj instanceof List) {
                return (List)obj;
            }
            return Collections.singletonList(obj);
        }).flatMap(Collection::stream);
    }

    @JsonIgnore
    public Set<String> getRels() {
        return this.links.keySet();
    }

    public Optional<Link> getLinkBy(String rel) {
        List<Link> links = this.getLinksBy(rel);
        return links.isEmpty() ? Optional.empty() : Optional.of(links.get(0));
    }

    public Optional<Link> getLinkBy(String rel, Predicate<Link> selector) {
        List<Link> links = this.getLinksBy(rel, selector);
        return links.isEmpty() ? Optional.empty() : Optional.of(links.get(0));
    }

    public List<Link> getLinksBy(String rel) {
        String curiedRel = this.curies.resolve(rel);
        if (this.links.containsKey(curiedRel)) {
            Object links = this.links.get(curiedRel);
            return links instanceof List ? (List<Link>)links : Collections.singletonList((Link)links);
        }
        return Collections.emptyList();
    }

    public List<Link> getLinksBy(String rel, Predicate<Link> selector) {
        return this.getLinksBy(rel).stream().filter(selector).collect(Collectors.toList());
    }

    public void remove(String rel) {
        this.links.remove(rel);
    }

    public boolean hasLink(String rel) {
        return this.links.containsKey(rel);
    }

    public boolean isArray(String rel) {
        return this.hasLink(rel) && this.links.get(rel) instanceof List;
    }

    public boolean isEmpty() {
        return this.links.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Links links1 = (Links)o;
        return this.links != null ? this.links.equals(links1.links) : links1.links == null;
    }

    public int hashCode() {
        return this.links != null ? this.links.hashCode() : 0;
    }

    public String toString() {
        return "Links{links=" + this.links + '}';
    }

    public static class LinksDeserializer
    extends JsonDeserializer<Links> {
        private static final TypeReference<Map<String, ?>> TYPE_REF_LINK_MAP = new TypeReference<Map<String, ?>>(){};

        public Links deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            Map linksMap = (Map)p.readValueAs(TYPE_REF_LINK_MAP);
            Map<String, Object> links = linksMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.asArrayOrObject((String)e.getKey(), e.getValue())));
            this.fixPossibleIssueWithCuriesAsSingleLinkObject(links);
            return new Links(links, Curies.emptyCuries());
        }

        private void fixPossibleIssueWithCuriesAsSingleLinkObject(final Map<String, Object> links) {
            if (links.containsKey(Links.CURIES_REL) && links.get(Links.CURIES_REL) instanceof Link) {
                links.put(Links.CURIES_REL, new ArrayList<Link>(){
                    {
                        this.add((Link)links.get(Links.CURIES_REL));
                    }
                });
            }
        }

        private Object asArrayOrObject(String rel, Object value) {
            if (value instanceof Map) {
                return this.asLink(rel, (Map)value);
            }
            try {
                return ((List)value).stream().map(o -> this.asLink(rel, (Map)o)).collect(Collectors.toList());
            }
            catch (ClassCastException e) {
                throw new IllegalStateException("Expected a single Link or a List of Links: rel=" + rel + " value=" + value);
            }
        }

        private Link asLink(String rel, Map value) {
            Link.Builder builder = Link.linkBuilder(rel, value.get("href").toString()).withHrefLang((String)value.get("hreflang")).withName((String)value.get("name")).withTitle((String)value.get("title")).withType((String)value.get("type")).withProfile((String)value.get("profile")).withDeprecation((String)value.get("deprecation"));
            return builder.build();
        }
    }

    public static class LinksSerializer
    extends JsonSerializer<Links> {
        public void serialize(Links links, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeStartObject();
            for (String rel : links.links.keySet()) {
                if (links.isArray(rel)) {
                    gen.writeArrayFieldStart(rel);
                    for (Link link : links.getLinksBy(rel)) {
                        gen.writeObject((Object)link);
                    }
                    gen.writeEndArray();
                    continue;
                }
                gen.writeObjectField(rel, (Object)links.getLinkBy(rel).orElseThrow(IllegalStateException::new));
            }
            gen.writeEndObject();
        }
    }

    public static class Builder {
        private final Map<String, Object> links = new LinkedHashMap<String, Object>();
        private Curies curies = Curies.emptyCuries();

        public Builder self(String href) {
            this.single(Link.self(href), new Link[0]);
            return this;
        }

        public Builder curi(String name, String relTemplate) {
            this.array(Link.curi(name, relTemplate), new Link[0]);
            return this;
        }

        public Builder collection(String href) {
            this.single(Link.collection(href), new Link[0]);
            return this;
        }

        public Builder item(String href) {
            this.array(Link.item(href), new Link[0]);
            return this;
        }

        public Builder single(Link link, Link ... more) {
            if (link.getRel().equals(Links.CURIES_REL)) {
                throw new IllegalArgumentException("According to the spec, curies must always be arrays of links, not single links.");
            }
            if (this.links.containsKey(link.getRel())) {
                throw new IllegalStateException("The Link-Relation Type '" + link.getRel() + "' of the Link is already present.");
            }
            this.links.put(link.getRel(), link);
            if (more != null) {
                Arrays.stream(more).forEach(x$0 -> this.single((Link)x$0, new Link[0]));
            }
            return this;
        }

        public Builder single(List<Link> singleLinkObjects) {
            if (singleLinkObjects.stream().map(Link::getRel).count() != (long)singleLinkObjects.size()) {
                throw new IllegalArgumentException("Unable to add links as single link objects as there are multiple links having the same link-relation type.");
            }
            singleLinkObjects.forEach(x$0 -> this.single((Link)x$0, new Link[0]));
            return this;
        }

        public Builder array(final Link link, final Link ... more) {
            this.array((List<Link>)new ArrayList<Link>(){
                {
                    this.add(link);
                    if (more != null) {
                        this.addAll(Arrays.asList(more));
                    }
                }
            });
            return this;
        }

        public Builder array(List<Link> links) {
            links.forEach(link -> {
                Object linkOrList;
                if (!this.links.containsKey(link.getRel())) {
                    this.links.put(link.getRel(), new ArrayList());
                }
                if ((linkOrList = this.links.get(link.getRel())) instanceof List) {
                    List linksForRel = (List)linkOrList;
                    boolean equivalentLinkExists = linksForRel.stream().anyMatch(l -> l.isEquivalentTo((Link)link));
                    if (!equivalentLinkExists) {
                        linksForRel.add(link);
                    }
                } else {
                    throw new IllegalStateException("Unable to add links with rel=" + link.getRel() + " as there is already a single Link Object added for this link-relation type");
                }
            });
            return this;
        }

        public Builder replace(String rel, List<Link> links) {
            if (!links.stream().allMatch(link -> link.getRel().equals(rel))) {
                throw new IllegalArgumentException("All links must have link-relation type " + rel);
            }
            if (!this.links.containsKey(rel)) {
                return this.array(links);
            }
            this.links.replace(rel, links);
            return this;
        }

        public Builder with(Links moreLinks) {
            for (String rel : moreLinks.getRels()) {
                if (moreLinks.isArray(rel)) {
                    this.array(moreLinks.getLinksBy(rel));
                    continue;
                }
                this.single(moreLinks.getLinksBy(rel));
            }
            return this;
        }

        public Builder without(String rel) {
            this.links.remove(rel);
            return this;
        }

        public Builder using(Curies curies) {
            this.curies = this.curies != null ? this.curies.mergeWith(curies) : curies;
            return this;
        }

        public Links build() {
            return new Links(this.links, this.curies);
        }
    }
}

