/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.hal.paging;

import com.damnhandy.uri.template.UriTemplate;
import de.otto.edison.hal.Link;
import de.otto.edison.hal.Links;
import de.otto.edison.hal.paging.PagingRel;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.OptionalInt;

public class SkipLimitPaging {
    public static final String SKIP_VAR = "skip";
    public static final String LIMIT_VAR = "limit";
    private final int skip;
    private final int limit;
    private final boolean hasMore;
    private final OptionalInt total;

    protected SkipLimitPaging(int skip, int limit, boolean hasMore) {
        if (skip < 0) {
            throw new IllegalArgumentException("Parameter 'skip' must not be less than zero");
        }
        if (limit <= 0) {
            throw new IllegalArgumentException("Parameter 'limit' must be greater zero");
        }
        if (hasMore && limit == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Unable to calculate next page for unbounded page sizes.");
        }
        this.skip = skip;
        this.limit = limit;
        this.total = OptionalInt.empty();
        this.hasMore = hasMore;
    }

    protected SkipLimitPaging(int skip, int limit, int totalCount) {
        if (skip < 0) {
            throw new IllegalArgumentException("Parameter 'skip' must not be less than zero");
        }
        if (limit <= 0) {
            throw new IllegalArgumentException("Parameter 'limit' must be greater zero");
        }
        if (totalCount < 0) {
            throw new IllegalArgumentException("Parameter 'totalCount' must be greater than or equal to zero");
        }
        if (totalCount < skip) {
            throw new IllegalArgumentException("Parameter 'totalCount' must be greater 'skip'");
        }
        this.skip = skip;
        this.limit = limit;
        this.total = OptionalInt.of(totalCount);
        this.hasMore = skip + limit < totalCount;
    }

    public static SkipLimitPaging skipLimitPage(int skip, int limit, boolean hasMore) {
        return new SkipLimitPaging(skip, limit, hasMore);
    }

    public static SkipLimitPaging skipLimitPage(int skip, int limit, int totalCount) {
        return new SkipLimitPaging(skip, limit, totalCount);
    }

    public final Links links(UriTemplate pageUriTemplate, EnumSet<PagingRel> rels) {
        ArrayList<Link> links = new ArrayList<Link>();
        if (rels.contains((Object)PagingRel.SELF)) {
            links.add(Link.self(this.pageUri(pageUriTemplate, this.skip, this.limit)));
        }
        if (rels.contains((Object)PagingRel.FIRST)) {
            links.add(Link.link("first", this.pageUri(pageUriTemplate, 0, this.limit)));
        }
        if (this.skip > 0 && rels.contains((Object)PagingRel.PREV)) {
            links.add(Link.link("prev", this.pageUri(pageUriTemplate, Integer.max(0, this.skip - this.limit), this.limit)));
        }
        if (this.hasMore && rels.contains((Object)PagingRel.NEXT)) {
            links.add(Link.link("next", this.pageUri(pageUriTemplate, this.skip + this.limit, this.limit)));
        }
        if (this.total.isPresent() && rels.contains((Object)PagingRel.LAST)) {
            int skip = this.calcLastPageSkip(this.total.getAsInt(), this.skip, this.limit);
            links.add(Link.link("last", this.pageUri(pageUriTemplate, skip, this.limit)));
        }
        return Links.linkingTo().single(links).build();
    }

    public int getSkip() {
        return this.skip;
    }

    public int getLimit() {
        return this.limit;
    }

    public boolean hasMore() {
        return this.hasMore;
    }

    public OptionalInt getTotal() {
        return this.total;
    }

    protected String skipVar() {
        return SKIP_VAR;
    }

    protected String limitVar() {
        return LIMIT_VAR;
    }

    private int calcLastPageSkip(int total, int skip, int limit) {
        if (skip > total - limit) {
            return skip;
        }
        if (total % limit > 0) {
            return total - total % limit;
        }
        return total - limit;
    }

    private String pageUri(UriTemplate uriTemplate, int skip, int limit) {
        if (limit == Integer.MAX_VALUE) {
            return uriTemplate.expand();
        }
        return uriTemplate.set(this.skipVar(), (Object)skip).set(this.limitVar(), (Object)limit).expand();
    }
}

