/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.hal.traverson;

import com.damnhandy.uri.template.UriTemplate;
import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.otto.edison.hal.EmbeddedTypeInfo;
import de.otto.edison.hal.HalParser;
import de.otto.edison.hal.HalRepresentation;
import de.otto.edison.hal.Link;
import de.otto.edison.hal.LinkPredicates;
import de.otto.edison.hal.traverson.LinkResolver;
import de.otto.edison.hal.traverson.PageHandler;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Traverson {
    private static final Logger LOG = LoggerFactory.getLogger(Traverson.class);
    public static final ObjectMapper DEFAULT_JSON_MAPPER = new ObjectMapper();
    private final ObjectMapper objectMapper;
    private final LinkResolver linkResolver;
    private URL startWith;
    private URL contextUrl;
    private List<? extends HalRepresentation> lastResult;
    private Hops hops = Hops.of();

    private Traverson(LinkResolver linkResolver, ObjectMapper objectMapper) {
        this.linkResolver = linkResolver;
        this.objectMapper = objectMapper;
    }

    public static Traverson traverson(LinkResolver linkResolver) {
        return new Traverson(linkResolver, DEFAULT_JSON_MAPPER);
    }

    public static Traverson traverson(LinkResolver linkResolver, ObjectMapper objectMapper) {
        if (objectMapper.isEnabled(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY)) {
            return new Traverson(linkResolver, objectMapper);
        }
        return new Traverson(linkResolver, objectMapper.copy().configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true));
    }

    public static Map<String, Object> withVars(String key, Object value, Object ... more) {
        if (more != null && more.length % 2 != 0) {
            throw new IllegalArgumentException("The number of template variables (key-value pairs) must be even");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(key, value);
        if (more != null) {
            for (int i = 0; i < more.length; i += 2) {
                map.put(more[i].toString(), more[i + 1]);
            }
        }
        return map;
    }

    public static List<String> hops(final String rel, final String ... moreRels) {
        if (moreRels != null) {
            return new ArrayList<String>(){
                {
                    this.add(Objects.requireNonNull(rel));
                    this.addAll(Arrays.asList(moreRels));
                }
            };
        }
        return Collections.singletonList(Objects.requireNonNull(rel));
    }

    public Traverson startWith(String uriTemplate, Map<String, Object> vars) {
        return this.startWith(UriTemplate.fromTemplate((String)uriTemplate).expand(vars));
    }

    public Traverson startWith(String uri) {
        this.contextUrl = this.startWith = Traverson.hrefToUrl(uri);
        this.lastResult = null;
        return this;
    }

    public Traverson startWith(HalRepresentation resource) {
        this.startWith = null;
        this.lastResult = Collections.singletonList(Objects.requireNonNull(resource));
        Optional<Link> self = resource.getLinks().getLinkBy("self");
        if (self.isPresent()) {
            this.contextUrl = Traverson.linkToUrl(self.get());
        } else {
            resource.getLinks().stream().filter(link -> !link.getHref().matches("http.*//.*")).findAny().ifPresent(link -> {
                throw new IllegalArgumentException("Unable to construct Traverson from HalRepresentation w/o self link but containing relative links. Please try Traverson.startWith(URL, HalRepresentation)");
            });
        }
        return this;
    }

    public Traverson startWith(URL contextUrl, HalRepresentation resource) {
        this.startWith = null;
        this.contextUrl = Objects.requireNonNull(contextUrl);
        this.lastResult = Collections.singletonList(Objects.requireNonNull(resource));
        return this;
    }

    public Traverson follow(String rel) {
        return this.follow(rel, LinkPredicates.always(), Collections.emptyMap());
    }

    public Traverson followLink(String rel) {
        return this.followLink(rel, LinkPredicates.always(), Collections.emptyMap());
    }

    public Traverson follow(String rel, Predicate<Link> predicate) {
        return this.follow(rel, predicate, Collections.emptyMap());
    }

    public Traverson followLink(String rel, Predicate<Link> predicate) {
        return this.followLink(rel, predicate, Collections.emptyMap());
    }

    public Traverson follow(List<String> rels) {
        return this.follow(rels, LinkPredicates.always(), Collections.emptyMap());
    }

    public Traverson follow(List<String> rels, Predicate<Link> predicate) {
        return this.follow(rels, predicate, Collections.emptyMap());
    }

    public Traverson follow(List<String> rels, Map<String, Object> vars) {
        for (String rel : rels) {
            this.follow(rel, LinkPredicates.always(), vars);
        }
        return this;
    }

    public Traverson follow(List<String> rels, Predicate<Link> predicate, Map<String, Object> vars) {
        for (String rel : rels) {
            this.follow(rel, predicate, vars);
        }
        return this;
    }

    public Traverson follow(String rel, Map<String, Object> vars) {
        return this.follow(rel, LinkPredicates.always(), vars);
    }

    public Traverson followLink(String rel, Map<String, Object> vars) {
        return this.followLink(rel, LinkPredicates.always(), vars);
    }

    public Traverson follow(String rel, Predicate<Link> predicate, Map<String, Object> vars) {
        this.checkState();
        this.hops.add(new Hop(rel, predicate, vars, false));
        return this;
    }

    public Traverson followLink(String rel, Predicate<Link> predicate, Map<String, Object> vars) {
        this.checkState();
        this.hops.add(new Hop(rel, predicate, vars, true));
        return this;
    }

    public void paginateNext(PageHandler pageHandler) throws IOException {
        this.paginateAs("next", HalRepresentation.class, null, pageHandler);
    }

    public void paginateNext(EmbeddedTypeInfo embeddedTypeInfo, PageHandler pageHandler) throws IOException {
        this.paginateAs("next", HalRepresentation.class, embeddedTypeInfo, pageHandler);
    }

    public <T extends HalRepresentation> void paginateNextAs(Class<T> pageType, PageHandler pageHandler) throws IOException {
        this.paginateAs("next", pageType, null, pageHandler);
    }

    public <T extends HalRepresentation> void paginateNextAs(Class<T> pageType, EmbeddedTypeInfo embeddedTypeInfo, PageHandler pageHandler) throws IOException {
        this.paginateAs("next", pageType, embeddedTypeInfo, pageHandler);
    }

    public void paginatePrev(PageHandler pageHandler) throws IOException {
        this.paginateAs("prev", HalRepresentation.class, null, pageHandler);
    }

    public void paginatePrev(EmbeddedTypeInfo embeddedTypeInfo, PageHandler pageHandler) throws IOException {
        this.paginateAs("prev", HalRepresentation.class, embeddedTypeInfo, pageHandler);
    }

    public <T extends HalRepresentation> void paginatePrevAs(Class<T> pageType, PageHandler pageHandler) throws IOException {
        this.paginateAs("prev", pageType, null, pageHandler);
    }

    public <T extends HalRepresentation> void paginatePrevAs(Class<T> pageType, EmbeddedTypeInfo embeddedTypeInfo, PageHandler pageHandler) throws IOException {
        this.paginateAs("prev", pageType, embeddedTypeInfo, pageHandler);
    }

    public <T extends HalRepresentation> void paginate(String rel, EmbeddedTypeInfo embeddedTypeInfo, PageHandler pageHandler) throws IOException {
        this.paginateAs(rel, HalRepresentation.class, embeddedTypeInfo, pageHandler);
    }

    public <T extends HalRepresentation> void paginateAs(String rel, Class<T> pageType, EmbeddedTypeInfo embeddedTypeInfo, PageHandler pageHandler) throws IOException {
        Optional<T> currentPage = this.getResourceAs(pageType, embeddedTypeInfo, new EmbeddedTypeInfo[0]);
        while (currentPage.isPresent() && pageHandler.apply(Traverson.traverson(this.linkResolver).startWith(this.contextUrl, (HalRepresentation)currentPage.get())) && ((HalRepresentation)currentPage.get()).getLinks().getRels().contains(rel)) {
            currentPage = this.follow(rel).getResourceAs(pageType, embeddedTypeInfo, new EmbeddedTypeInfo[0]);
        }
    }

    public Stream<HalRepresentation> stream() throws IOException {
        return this.streamAs(HalRepresentation.class, null);
    }

    public <T extends HalRepresentation> Stream<T> streamAs(Class<T> type) throws IOException {
        return this.streamAs(type, null);
    }

    public <T extends HalRepresentation> Stream<T> streamAs(Class<T> type, EmbeddedTypeInfo embeddedTypeInfo, EmbeddedTypeInfo ... moreEmbeddedTypeInfos) throws IOException {
        if (moreEmbeddedTypeInfos == null || moreEmbeddedTypeInfos.length == 0) {
            return this.streamAs(type, embeddedTypeInfo != null ? Collections.singletonList(embeddedTypeInfo) : Collections.emptyList());
        }
        ArrayList<EmbeddedTypeInfo> typeInfos = new ArrayList<EmbeddedTypeInfo>();
        typeInfos.add(Objects.requireNonNull(embeddedTypeInfo));
        typeInfos.addAll(Arrays.asList(moreEmbeddedTypeInfos));
        return this.streamAs(type, typeInfos);
    }

    public <T extends HalRepresentation> Stream<T> streamAs(Class<T> type, List<EmbeddedTypeInfo> embeddedTypeInfo) throws IOException {
        this.checkState();
        try {
            if (this.startWith != null) {
                this.lastResult = this.traverseInitialResource(type, embeddedTypeInfo, true);
            } else if (!this.hops.isEmpty()) {
                this.lastResult = this.traverseHop(this.lastResult.get(0), type, embeddedTypeInfo, true);
            }
            return this.lastResult.stream();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public Optional<HalRepresentation> getResource() throws IOException {
        return this.getResourceAs(HalRepresentation.class, null);
    }

    public <T extends HalRepresentation> Optional<T> getResourceAs(Class<T> type) throws IOException {
        return this.getResourceAs(type, null);
    }

    public <T extends HalRepresentation> Optional<T> getResourceAs(Class<T> type, EmbeddedTypeInfo embeddedTypeInfo, EmbeddedTypeInfo ... moreEmbeddedTypeInfos) throws IOException {
        if (moreEmbeddedTypeInfos == null || moreEmbeddedTypeInfos.length == 0) {
            return this.getResourceAs(type, embeddedTypeInfo != null ? Collections.singletonList(embeddedTypeInfo) : Collections.emptyList());
        }
        ArrayList<EmbeddedTypeInfo> typeInfos = new ArrayList<EmbeddedTypeInfo>();
        typeInfos.add(Objects.requireNonNull(embeddedTypeInfo));
        typeInfos.addAll(Arrays.asList(moreEmbeddedTypeInfos));
        return this.getResourceAs(type, typeInfos);
    }

    public <T extends HalRepresentation> Optional<T> getResourceAs(Class<T> type, List<EmbeddedTypeInfo> embeddedTypeInfos) throws IOException {
        this.checkState();
        try {
            if (this.startWith != null) {
                this.lastResult = this.traverseInitialResource(type, embeddedTypeInfos, false);
            } else if (!this.hops.isEmpty()) {
                this.lastResult = this.traverseHop(this.lastResult.get(0), type, embeddedTypeInfos, false);
            }
            if (this.lastResult.size() > 0) {
                return Optional.of(type.cast(this.lastResult.get(0)));
            }
            return Optional.empty();
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            throw e;
        }
    }

    public URL getCurrentContextUrl() {
        return this.contextUrl;
    }

    private <T extends HalRepresentation> List<T> traverseInitialResource(Class<T> resultType, List<EmbeddedTypeInfo> embeddedTypeInfo, boolean retrieveAll) throws IOException {
        HalRepresentation firstHop;
        Link initial = Link.self(this.startWith.toString());
        LOG.trace("Starting with {}", (Object)this.startWith);
        this.startWith = null;
        if (this.hops.isEmpty()) {
            return Collections.singletonList(this.getResource(initial, resultType, embeddedTypeInfo));
        }
        if (this.hops.size() == 1) {
            Hop hop = this.hops.get(0);
            firstHop = embeddedTypeInfo == null || embeddedTypeInfo.isEmpty() ? this.getResource(initial, HalRepresentation.class, EmbeddedTypeInfo.withEmbedded(hop.rel, resultType, new EmbeddedTypeInfo[0])) : this.getResource(initial, HalRepresentation.class, EmbeddedTypeInfo.withEmbedded(hop.rel, resultType, embeddedTypeInfo));
        } else {
            firstHop = this.getResource(initial, HalRepresentation.class, Traverson.embeddedTypeInfoFor(this.hops, resultType, embeddedTypeInfo));
        }
        return this.traverseHop(firstHop, resultType, embeddedTypeInfo, retrieveAll);
    }

    private <T extends HalRepresentation> List<T> traverseHop(HalRepresentation current, Class<T> resultType, List<EmbeddedTypeInfo> embeddedTypeInfo, boolean retrieveAll) throws IOException {
        List response;
        Hop currentHop = this.hops.pop();
        LOG.trace("Following {}", (Object)currentHop.rel);
        List<Link> links = current.getLinks().getLinksBy(currentHop.rel, currentHop.predicate);
        if (!currentHop.ignoreEmbedded || links.isEmpty()) {
            List<HalRepresentation> embeddedItems;
            List<HalRepresentation> list = embeddedItems = this.hops.isEmpty() ? current.getEmbedded().getItemsBy(currentHop.rel, resultType) : current.getEmbedded().getItemsBy(currentHop.rel);
            if (!embeddedItems.isEmpty()) {
                LOG.trace("Returning {} embedded {}", (Object)embeddedItems.size(), (Object)currentHop.rel);
                return this.hops.isEmpty() ? embeddedItems : this.traverseHop(embeddedItems.get(0), resultType, embeddedTypeInfo, retrieveAll);
            }
        }
        if (!links.isEmpty()) {
            Link expandedLink = Traverson.resolve(this.contextUrl, this.expand(links.get(0), currentHop.vars));
            if (this.hops.isEmpty()) {
                if (retrieveAll) {
                    LOG.trace("Following {} {} links", (Object)links.size(), (Object)currentHop.rel);
                    ArrayList representations = new ArrayList();
                    for (Link link : links) {
                        representations.add(this.getResource(Traverson.resolve(this.contextUrl, this.expand(link, currentHop.vars)), resultType, embeddedTypeInfo));
                    }
                    response = representations;
                } else {
                    this.contextUrl = Traverson.linkToUrl(expandedLink);
                    response = Collections.singletonList(this.getResource(expandedLink, resultType, embeddedTypeInfo));
                }
            } else {
                this.contextUrl = Traverson.linkToUrl(expandedLink);
                HalRepresentation resource = this.getResource(expandedLink, HalRepresentation.class, Traverson.embeddedTypeInfoFor(this.hops, resultType, embeddedTypeInfo));
                response = this.traverseHop(resource, resultType, embeddedTypeInfo, retrieveAll);
            }
        } else {
            String msg = String.format("Can not follow hop %s: no matching links found in resource %s", currentHop.rel, current);
            LOG.error(msg);
            response = Collections.emptyList();
        }
        return response;
    }

    private Link expand(Link link, Map<String, Object> vars) {
        if (link.isTemplated()) {
            String href = UriTemplate.fromTemplate((String)link.getHref()).expand(vars);
            return Link.copyOf(link).withHref(href).withRel(link.getRel()).build();
        }
        return link;
    }

    private <T extends HalRepresentation> T getResource(Link link, Class<T> resultType, EmbeddedTypeInfo embeddedTypeInfo) throws IOException {
        return this.getResource(link, resultType, Collections.singletonList(embeddedTypeInfo));
    }

    private <T extends HalRepresentation> T getResource(Link link, Class<T> type, List<EmbeddedTypeInfo> embeddedType) throws IOException {
        String json;
        LOG.trace("Fetching resource href={} rel={} as type={} with embeddedType={}", new Object[]{link.getHref(), link.getRel(), type.getSimpleName(), embeddedType});
        try {
            json = this.linkResolver.apply(link);
            LOG.trace("Got {}", (Object)json);
        }
        catch (IOException | RuntimeException e) {
            LOG.error("Failed to fetch resource href={}: {}", (Object)link.getHref(), (Object)e.getMessage());
            throw e;
        }
        try {
            return embeddedType != null && !embeddedType.isEmpty() ? HalParser.parse(json, this.objectMapper).as(type, embeddedType) : HalParser.parse(json, this.objectMapper).as(type);
        }
        catch (RuntimeException e) {
            LOG.error("Failed to parse resource href={} rel={} as type={} with embeddedType={}", new Object[]{link.getHref(), link.getRel(), type.getSimpleName(), embeddedType});
            throw e;
        }
    }

    private static Link resolve(URL contextUrl, Link link) {
        if (link != null && link.isTemplated()) {
            String msg = "Link must not be templated";
            LOG.error("Link must not be templated");
            throw new IllegalStateException("Link must not be templated");
        }
        if (link == null) {
            return Link.self(contextUrl.toString());
        }
        return Link.copyOf(link).withHref(Traverson.resolveHref(contextUrl, link.getHref()).toString()).build();
    }

    static EmbeddedTypeInfo embeddedTypeInfoFor(Hops hops, Class<? extends HalRepresentation> pageType, List<EmbeddedTypeInfo> embeddedTypeInfo) {
        if (hops.isEmpty()) {
            throw new IllegalArgumentException("Hops must not be empty");
        }
        EmbeddedTypeInfo typeInfo = embeddedTypeInfo != null && !embeddedTypeInfo.isEmpty() ? EmbeddedTypeInfo.withEmbedded(hops.get((int)(hops.size() - 1)).rel, pageType, embeddedTypeInfo) : EmbeddedTypeInfo.withEmbedded(hops.get((int)(hops.size() - 1)).rel, pageType, new EmbeddedTypeInfo[0]);
        for (int i = hops.size() - 2; i >= 0; --i) {
            typeInfo = EmbeddedTypeInfo.withEmbedded(hops.get((int)i).rel, HalRepresentation.class, typeInfo);
        }
        return typeInfo;
    }

    private static URL linkToUrl(Link link) {
        if (link.isTemplated()) {
            String msg = String.format("Unable to create URL from templated link %s", link);
            LOG.error(msg);
            throw new IllegalArgumentException(msg);
        }
        return Traverson.hrefToUrl(link.getHref());
    }

    private static URL hrefToUrl(String href) {
        try {
            return new URL(href);
        }
        catch (MalformedURLException e) {
            String msg = String.format("Unable to create URL from href '%s': %s", href, e.getMessage());
            LOG.error(msg, (Throwable)e);
            throw new IllegalArgumentException(msg, e);
        }
    }

    private static URL resolveHref(URL contextUrl, String href) {
        try {
            return contextUrl == null ? new URL(href) : new URL(contextUrl, href);
        }
        catch (MalformedURLException e) {
            String msg = String.format("Unable to resolve URL from contextUrl %s and href '%s': %s", contextUrl, href, e.getMessage());
            LOG.error(msg, (Throwable)e);
            throw new IllegalArgumentException(msg, e);
        }
    }

    private void checkState() {
        if (this.startWith == null && this.lastResult == null) {
            String msg = "Please call startWith(uri) first.";
            LOG.error("Please call startWith(uri) first.");
            throw new IllegalStateException("Please call startWith(uri) first.");
        }
    }

    static {
        DEFAULT_JSON_MAPPER.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        DEFAULT_JSON_MAPPER.findAndRegisterModules();
    }

    static class Hops {
        private static final JsonPointer CURRENT = JsonPointer.compile((String)"");
        private final List<Hop> hops = new ArrayList<Hop>();

        Hops(Hop ... hops) {
            if (hops.length > 0) {
                this.hops.addAll(Arrays.asList(hops));
            }
        }

        public static Hops of() {
            return new Hops(new Hop[0]);
        }

        public static Hops of(Hop ... hops) {
            return new Hops(hops);
        }

        void add(Hop hop) {
            if (this.hops.size() > 0) {
                this.hops.add(hop);
            } else {
                this.hops.add(hop);
            }
        }

        public Hop get(int index) {
            return this.hops.get(index);
        }

        public boolean isEmpty() {
            return this.hops.isEmpty();
        }

        public int size() {
            return this.hops.size();
        }

        public Hop pop() {
            return this.hops.remove(0);
        }
    }

    static class Hop {
        private static final JsonPointer EMPTY = JsonPointer.compile((String)"");
        final String rel;
        final Predicate<Link> predicate;
        final Map<String, Object> vars;
        final boolean ignoreEmbedded;

        Hop(String rel, Predicate<Link> predicate, Map<String, Object> vars, boolean ignoreEmbedded) {
            this.rel = rel;
            this.predicate = predicate;
            this.vars = vars;
            this.ignoreEmbedded = ignoreEmbedded;
        }
    }
}

