/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.hal;

import de.otto.edison.hal.HalRepresentation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class EmbeddedTypeInfo {
    private final String rel;
    private final Class<? extends HalRepresentation> type;
    private final List<EmbeddedTypeInfo> nestedTypeInfo;

    private EmbeddedTypeInfo(String rel, Class<? extends HalRepresentation> type, List<EmbeddedTypeInfo> nestedTypeInfo) {
        this.rel = rel;
        this.type = type;
        this.nestedTypeInfo = nestedTypeInfo;
    }

    public static EmbeddedTypeInfo withEmbedded(String rel, Class<? extends HalRepresentation> embeddedType, EmbeddedTypeInfo ... nestedTypeInfo) {
        if (nestedTypeInfo == null || nestedTypeInfo.length == 0) {
            return new EmbeddedTypeInfo(rel, embeddedType, Collections.emptyList());
        }
        return new EmbeddedTypeInfo(rel, embeddedType, Arrays.asList(nestedTypeInfo));
    }

    public static EmbeddedTypeInfo withEmbedded(String rel, Class<? extends HalRepresentation> embeddedType, List<EmbeddedTypeInfo> nestedTypeInfo) {
        return new EmbeddedTypeInfo(rel, embeddedType, nestedTypeInfo);
    }

    public String getRel() {
        return this.rel;
    }

    public Class<? extends HalRepresentation> getType() {
        return this.type;
    }

    public List<EmbeddedTypeInfo> getNestedTypeInfo() {
        return this.nestedTypeInfo != null ? this.nestedTypeInfo : Collections.emptyList();
    }

    public String toString() {
        return "EmbeddedTypeInfo{rel='" + this.rel + "', type=" + this.type.getSimpleName() + ", nestedTypeInfo=" + String.valueOf(this.nestedTypeInfo) + "}";
    }
}

