/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.hal;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.otto.edison.hal.Curies;
import de.otto.edison.hal.EmbeddedTypeInfo;
import de.otto.edison.hal.HalRepresentation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HalParser {
    private static final Logger LOG = LoggerFactory.getLogger(HalParser.class);
    public static final ObjectMapper DEFAULT_JSON_MAPPER = new ObjectMapper();
    private final ObjectMapper objectMapper;
    private final String json;

    private HalParser(String json, ObjectMapper objectMapper) {
        this.json = json;
        this.objectMapper = objectMapper;
    }

    public static HalParser parse(String json) {
        return new HalParser(json, DEFAULT_JSON_MAPPER);
    }

    public static HalParser parse(String json, ObjectMapper objectMapper) {
        if (objectMapper.isEnabled(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY)) {
            return new HalParser(json, objectMapper);
        }
        return new HalParser(json, objectMapper.copy().configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true));
    }

    public <T extends HalRepresentation> T as(Class<T> type) throws IOException {
        return (T)((HalRepresentation)this.objectMapper.readValue(this.json, type));
    }

    public <T extends HalRepresentation> T as(Class<T> type, EmbeddedTypeInfo typeInfo, EmbeddedTypeInfo ... moreTypeInfo) throws IOException {
        ArrayList<EmbeddedTypeInfo> typeInfos = new ArrayList<EmbeddedTypeInfo>();
        typeInfos.add(typeInfo);
        if (moreTypeInfo != null) {
            typeInfos.addAll(Arrays.asList(moreTypeInfo));
        }
        return this.as(type, typeInfos);
    }

    public <T extends HalRepresentation> T as(Class<T> type, List<EmbeddedTypeInfo> typeInfo) throws IOException {
        JsonNode jsonNode = this.objectMapper.readTree(this.json);
        HalRepresentation halRepresentation = (HalRepresentation)this.objectMapper.convertValue((Object)jsonNode, type);
        this.resolveEmbeddedTypeInfo(typeInfo, jsonNode, halRepresentation);
        return (T)halRepresentation;
    }

    private <T extends HalRepresentation> void resolveEmbeddedTypeInfo(List<EmbeddedTypeInfo> typeInfos, JsonNode itemNode, T item) {
        if (!itemNode.isMissingNode()) {
            typeInfos.forEach(typeInfo -> {
                Optional<JsonNode> embeddedNodeForRel = this.findPossiblyCuriedEmbeddedNode(item, itemNode, typeInfo.getRel());
                embeddedNodeForRel.ifPresent(node -> this.resolveEmbeddedTypeInfoForRel((EmbeddedTypeInfo)typeInfo, item, (JsonNode)node));
            });
        }
    }

    private <T extends HalRepresentation> void resolveEmbeddedTypeInfoForRel(EmbeddedTypeInfo typeInfo, T parent, JsonNode embeddedNodeForRel) {
        ArrayList<HalRepresentation> embeddedValues = new ArrayList<HalRepresentation>();
        if (embeddedNodeForRel.isArray()) {
            for (int i = 0; i < embeddedNodeForRel.size(); ++i) {
                JsonNode embeddedNode = embeddedNodeForRel.get(i);
                embeddedValues.addAll(this.resolveSingleEmbedded(typeInfo, parent.getCuries(), embeddedNode));
            }
        } else {
            embeddedValues.addAll(this.resolveSingleEmbedded(typeInfo, parent.getCuries(), embeddedNodeForRel));
        }
        parent.withEmbedded(typeInfo.getRel(), embeddedValues);
    }

    private List<? extends HalRepresentation> resolveSingleEmbedded(EmbeddedTypeInfo typeInfo, Curies parentCuries, JsonNode embeddedNodeForRel) {
        ArrayList<HalRepresentation> embeddedValues = new ArrayList<HalRepresentation>();
        HalRepresentation embedded = ((HalRepresentation)this.objectMapper.convertValue((Object)embeddedNodeForRel, typeInfo.getType())).mergeWithEmbedding(parentCuries);
        if (embedded != null) {
            typeInfo.getNestedTypeInfo().forEach(nestedTypeInfo -> this.findPossiblyCuriedEmbeddedNode(embedded, embeddedNodeForRel, nestedTypeInfo.getRel()).ifPresent(nestedNodeForRel -> this.resolveEmbeddedTypeInfoForRel((EmbeddedTypeInfo)nestedTypeInfo, (HalRepresentation)embedded, (JsonNode)nestedNodeForRel)));
            embeddedValues.add(embedded);
        }
        return embeddedValues;
    }

    private Optional<JsonNode> findPossiblyCuriedEmbeddedNode(HalRepresentation halRepresentation, JsonNode jsonNode, String rel) {
        JsonNode embedded = jsonNode.get("_embedded");
        if (embedded != null) {
            Curies curies = halRepresentation.getCuries();
            JsonNode curiedNode = embedded.get(curies.resolve(rel));
            if (curiedNode == null) {
                return Optional.ofNullable(embedded.get(curies.expand(rel)));
            }
            return Optional.of(curiedNode);
        }
        return Optional.empty();
    }

    static {
        DEFAULT_JSON_MAPPER.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        DEFAULT_JSON_MAPPER.findAndRegisterModules();
    }
}

