/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.hal.paging;

import com.damnhandy.uri.template.UriTemplate;
import de.otto.edison.hal.Link;
import de.otto.edison.hal.Links;
import de.otto.edison.hal.paging.PagingRel;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.OptionalInt;

public class NumberedPaging {
    public static final String PAGE_NUMBER_VAR = "page";
    public static final String PAGE_SIZE_VAR = "pageSize";
    private final int firstPage;
    private final int pageNumber;
    private final int pageSize;
    private final boolean hasMore;
    private final OptionalInt total;

    protected NumberedPaging(int firstPage, int pageNumber, int pageSize, boolean hasMore) {
        if (firstPage != 0 && firstPage != 1) {
            throw new IllegalArgumentException("Parameter 'firstPage' must be 0 or 1");
        }
        if (pageNumber < firstPage) {
            throw new IllegalArgumentException("Parameter 'pageNumber' must not be less than " + firstPage);
        }
        if (pageSize <= 0) {
            throw new IllegalArgumentException("Parameter 'pageSize' must be greater 0");
        }
        if (hasMore && pageSize == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Unable to calculate next page for unbounded page sizes.");
        }
        this.pageNumber = pageNumber;
        this.pageSize = pageSize;
        this.hasMore = hasMore;
        this.total = OptionalInt.empty();
        this.firstPage = firstPage;
    }

    protected NumberedPaging(int firstPage, int pageNumber, int pageSize, int total) {
        if (firstPage != 0 && firstPage != 1) {
            throw new IllegalArgumentException("Parameter 'firstPage' must be 0 or 1");
        }
        if (pageNumber < firstPage) {
            throw new IllegalArgumentException("Parameter 'pageNumber' must not be less than " + firstPage);
        }
        if (pageSize <= 0) {
            throw new IllegalArgumentException("Parameter 'pageSize' must be greater 0");
        }
        if (total < 0) {
            throw new IllegalArgumentException("Parameter 'total' must be greater or equal 0");
        }
        this.pageNumber = pageNumber;
        this.pageSize = pageSize;
        int pageOffset = firstPage == 0 ? 1 : 0;
        this.hasMore = (pageNumber + pageOffset) * pageSize < total;
        this.total = OptionalInt.of(total);
        this.firstPage = firstPage;
    }

    public static NumberedPaging zeroBasedNumberedPaging(int pageNumber, int pageSize, boolean hasMore) {
        return new NumberedPaging(0, pageNumber, pageSize, hasMore);
    }

    public static NumberedPaging zeroBasedNumberedPaging(int pageNumber, int pageSize, int totalCount) {
        return new NumberedPaging(0, pageNumber, pageSize, totalCount);
    }

    public static NumberedPaging oneBasedNumberedPaging(int pageNumber, int pageSize, boolean hasMore) {
        return new NumberedPaging(1, pageNumber, pageSize, hasMore);
    }

    public static NumberedPaging oneBasedNumberedPaging(int pageNumber, int pageSize, int totalCount) {
        return new NumberedPaging(1, pageNumber, pageSize, totalCount);
    }

    public final Links links(UriTemplate pageUriTemplate, EnumSet<PagingRel> rels) {
        ArrayList<Link> links = new ArrayList<Link>();
        if (rels.contains((Object)PagingRel.SELF)) {
            links.add(Link.self(this.pageUri(pageUriTemplate, this.pageNumber, this.pageSize)));
        }
        if (rels.contains((Object)PagingRel.FIRST)) {
            links.add(Link.link("first", this.pageUri(pageUriTemplate, this.firstPage, this.pageSize)));
        }
        if (this.pageNumber > this.firstPage && rels.contains((Object)PagingRel.PREV)) {
            links.add(Link.link("prev", this.pageUri(pageUriTemplate, this.pageNumber - 1, this.pageSize)));
        }
        if (this.hasMore && rels.contains((Object)PagingRel.NEXT)) {
            links.add(Link.link("next", this.pageUri(pageUriTemplate, this.pageNumber + 1, this.pageSize)));
        }
        if (this.total.isPresent() && rels.contains((Object)PagingRel.LAST)) {
            links.add(Link.link("last", this.pageUri(pageUriTemplate, this.calcLastPage(this.total.getAsInt(), this.pageSize), this.pageSize)));
        }
        return Links.linkingTo().single(links).build();
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public boolean hasMore() {
        return this.hasMore;
    }

    public OptionalInt getTotal() {
        return this.total;
    }

    public OptionalInt getLastPage() {
        if (this.total.isPresent()) {
            return OptionalInt.of(this.calcLastPage(this.total.getAsInt(), this.pageSize));
        }
        return OptionalInt.empty();
    }

    protected String pageNumberVar() {
        return PAGE_NUMBER_VAR;
    }

    protected String pageSizeVar() {
        return PAGE_SIZE_VAR;
    }

    private int calcLastPage(int total, int pageSize) {
        if (total == 0) {
            return this.firstPage;
        }
        int zeroBasedPageNo = total % pageSize > 0 ? total / pageSize : total / pageSize - 1;
        return this.firstPage + zeroBasedPageNo;
    }

    private String pageUri(UriTemplate uriTemplate, int pageNumber, int pageSize) {
        if (pageSize == Integer.MAX_VALUE) {
            return uriTemplate.expand();
        }
        return uriTemplate.set(this.pageNumberVar(), (Object)pageNumber).set(this.pageSizeVar(), (Object)pageSize).expand();
    }
}

