/*
 * Decompiled with CFR 0.152.
 */
package de.otto.flummi;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.otto.flummi.InvalidElasticsearchResponseException;
import de.otto.flummi.RequestBuilderUtil;
import de.otto.flummi.request.CreateIndexRequestBuilder;
import de.otto.flummi.request.DeleteIndexRequestBuilder;
import de.otto.flummi.request.ForceMergeRequestBuilder;
import de.otto.flummi.request.GsonHelper;
import de.otto.flummi.request.IndicesExistsRequestBuilder;
import de.otto.flummi.request.RefreshRequestBuilder;
import de.otto.flummi.request.UpdateIndexSettingsRequestBuilder;
import de.otto.flummi.util.HttpClientWrapper;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.Response;

public class IndicesAdminClient {
    private HttpClientWrapper httpClient;
    private Gson gson = new Gson();

    public IndicesAdminClient(HttpClientWrapper httpClient) {
        this.httpClient = httpClient;
    }

    public CreateIndexRequestBuilder prepareCreate(String indexName) {
        return new CreateIndexRequestBuilder(this.httpClient, indexName);
    }

    public IndicesExistsRequestBuilder prepareExists(String indexName) {
        return new IndicesExistsRequestBuilder(this.httpClient, indexName);
    }

    public DeleteIndexRequestBuilder prepareDelete(Stream<String> indexNameSupplier) {
        return new DeleteIndexRequestBuilder(this.httpClient, indexNameSupplier);
    }

    public DeleteIndexRequestBuilder prepareDelete(String ... indexNames) {
        return new DeleteIndexRequestBuilder(this.httpClient, Stream.of(indexNames));
    }

    public RefreshRequestBuilder prepareRefresh(String indexName) {
        return new RefreshRequestBuilder(this.httpClient, indexName);
    }

    public ForceMergeRequestBuilder forceMerge(String indexName) {
        return new ForceMergeRequestBuilder(this.httpClient, indexName);
    }

    public UpdateIndexSettingsRequestBuilder prepareUpdateSettings(String indexName) {
        return new UpdateIndexSettingsRequestBuilder(this.httpClient, indexName);
    }

    public JsonObject getIndexSettings() {
        try {
            Response response = (Response)((BoundRequestBuilder)this.httpClient.prepareGet("/_all/_settings").addHeader((CharSequence)"Content-Type", "application/json")).execute().get();
            if (response.getStatusCode() != 200) {
                throw RequestBuilderUtil.toHttpServerErrorException(response);
            }
            String jsonString = null;
            jsonString = response.getResponseBody();
            return (JsonObject)this.gson.fromJson(jsonString, JsonObject.class);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public JsonObject getIndexMapping(String indexName) {
        try {
            Response response = (Response)((BoundRequestBuilder)this.httpClient.prepareGet("/" + indexName + "/_mapping").addHeader((CharSequence)"Content-Type", "application/json")).execute().get();
            if (response.getStatusCode() != 200) {
                throw RequestBuilderUtil.toHttpServerErrorException(response);
            }
            String jsonString = null;
            jsonString = response.getResponseBody();
            return (JsonObject)this.gson.fromJson(jsonString, JsonObject.class);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> getAllIndexNames() {
        try {
            Response response = (Response)((BoundRequestBuilder)this.httpClient.prepareGet("/_all").addHeader((CharSequence)"Content-Type", "application/json")).execute().get();
            if (response.getStatusCode() != 200) {
                throw RequestBuilderUtil.toHttpServerErrorException(response);
            }
            String jsonString = response.getResponseBody();
            JsonObject responseObject = (JsonObject)this.gson.fromJson(jsonString, JsonObject.class);
            return responseObject.entrySet().stream().map(Map.Entry::getKey).collect(Collectors.toList());
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public Optional<String> getIndexNameForAlias(String aliasName) {
        try {
            Response response = (Response)((BoundRequestBuilder)this.httpClient.prepareGet("/_aliases").addHeader((CharSequence)"Content-Type", "application/json")).execute().get();
            if (response.getStatusCode() != 200) {
                throw RequestBuilderUtil.toHttpServerErrorException(response);
            }
            String jsonString = response.getResponseBody();
            return ((JsonObject)this.gson.fromJson(jsonString, JsonObject.class)).entrySet().stream().filter(e -> e.getValue() != null && ((JsonElement)e.getValue()).isJsonObject() && ((JsonElement)e.getValue()).getAsJsonObject().get("aliases") != null && ((JsonElement)e.getValue()).getAsJsonObject().get("aliases").isJsonObject() && ((JsonElement)e.getValue()).getAsJsonObject().get("aliases").getAsJsonObject().has(aliasName)).map(e -> (String)e.getKey()).findFirst();
        }
        catch (InterruptedException | ExecutionException e2) {
            throw new RuntimeException(e2);
        }
    }

    public void pointAliasToCurrentIndex(String aliasName, String indexName) {
        try {
            JsonArray actions = new JsonArray();
            actions.add((JsonElement)GsonHelper.object("remove", (JsonElement)GsonHelper.object("index", "*", "alias", aliasName)));
            actions.add((JsonElement)GsonHelper.object("add", (JsonElement)GsonHelper.object("index", indexName, "alias", aliasName)));
            JsonObject jsonObject = GsonHelper.object("actions", (JsonElement)actions);
            Response response = (Response)((BoundRequestBuilder)((BoundRequestBuilder)this.httpClient.preparePost("/_aliases").addHeader((CharSequence)"Content-Type", "application/json")).setBody(this.gson.toJson((JsonElement)jsonObject))).execute().get();
            if (response.getStatusCode() >= 300) {
                throw RequestBuilderUtil.toHttpServerErrorException(response);
            }
            JsonObject responseObject = (JsonObject)this.gson.fromJson(response.getResponseBody(), JsonObject.class);
            if (!responseObject.has("acknowledged")) {
                throw new InvalidElasticsearchResponseException("Response does not contain field 'acknowledged': " + responseObject);
            }
            if (!responseObject.get("acknowledged").getAsBoolean()) {
                throw new RuntimeException("Pointing product alias to current index not acknowledged");
            }
            return;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean aliasExists(String aliasName) {
        try {
            Response response = (Response)((BoundRequestBuilder)this.httpClient.prepareGet("/_aliases").addHeader((CharSequence)"Content-Type", "application/json")).execute().get();
            if (response.getStatusCode() != 200) {
                throw RequestBuilderUtil.toHttpServerErrorException(response);
            }
            String jsonString = response.getResponseBody();
            JsonObject responseObject = (JsonObject)this.gson.fromJson(jsonString, JsonObject.class);
            return responseObject.entrySet().stream().filter(e -> e.getValue() != null && ((JsonElement)e.getValue()).isJsonObject() && ((JsonElement)e.getValue()).getAsJsonObject().get("aliases") != null && ((JsonElement)e.getValue()).getAsJsonObject().get("aliases").isJsonObject() && ((JsonElement)e.getValue()).getAsJsonObject().get("aliases").getAsJsonObject().has(aliasName)).count() > 0L;
        }
        catch (InterruptedException e2) {
            throw new RuntimeException(e2);
        }
        catch (ExecutionException e3) {
            throw new RuntimeException(e3);
        }
    }
}

