/*
 * Decompiled with CFR 0.152.
 */
package de.otto.flummi.aggregations;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import de.otto.flummi.GsonCollectors;
import de.otto.flummi.aggregations.AggregationResultParser;
import de.otto.flummi.aggregations.Range;
import de.otto.flummi.aggregations.SubAggregationBuilder;
import de.otto.flummi.request.GsonHelper;
import de.otto.flummi.response.AggregationResult;
import java.util.ArrayList;
import java.util.List;

public class RangeBuilder
extends SubAggregationBuilder<RangeBuilder> {
    private String fieldName;
    private final List<Range> ranges = new ArrayList<Range>();

    public RangeBuilder(String name) {
        super(name);
    }

    @Override
    public JsonObject build() {
        JsonObject rangeAggregatorObject = GsonHelper.object("field", (JsonElement)new JsonPrimitive(this.fieldName), "ranges", (JsonElement)this.ranges.stream().map(this::rangeToJson).collect(GsonCollectors.toJsonArray()));
        return GsonHelper.object("range", (JsonElement)rangeAggregatorObject);
    }

    private JsonObject rangeToJson(Range r) {
        JsonObject result = GsonHelper.object("key", (JsonElement)new JsonPrimitive(r.getKey()));
        if (r.getFrom() != null) {
            result.add("from", (JsonElement)new JsonPrimitive((Number)r.getFrom()));
        }
        if (r.getTo() != null) {
            result.add("to", (JsonElement)new JsonPrimitive((Number)r.getTo()));
        }
        return result;
    }

    public RangeBuilder field(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    public RangeBuilder addRange(String key, double from, double to) {
        this.ranges.add(new Range(key, from, to));
        return this;
    }

    public RangeBuilder addUnboundedTo(String key, double to) {
        this.ranges.add(new Range(key, null, to));
        return this;
    }

    public RangeBuilder addUnboundedFrom(String key, double from) {
        this.ranges.add(new Range(key, from, null));
        return this;
    }

    @Override
    public AggregationResult parseResponse(JsonObject jsonObject) {
        return AggregationResultParser.parseBuckets(jsonObject);
    }
}

