/*
 * Decompiled with CFR 0.152.
 */
package de.otto.flummi.aggregations;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.otto.flummi.aggregations.AggregationBuilder;
import de.otto.flummi.aggregations.NestedAggregationBuilder;
import de.otto.flummi.aggregations.SubAggregationBuilder;
import de.otto.flummi.request.GsonHelper;
import de.otto.flummi.response.AggregationResult;
import de.otto.flummi.response.Bucket;
import de.otto.flummi.response.BucketAggregationResult;
import java.util.ArrayList;

public class ReverseNestedBuilder
extends SubAggregationBuilder<ReverseNestedBuilder> {
    private final SubAggregationBuilder<?> innerAggregation;
    private NestedAggregationBuilder nestedAggregation;

    public ReverseNestedBuilder(String name, String nestedPath, SubAggregationBuilder<?> innerAggregation) {
        super(name);
        this.innerAggregation = innerAggregation;
        this.nestedAggregation = (NestedAggregationBuilder)new NestedAggregationBuilder(name).path(nestedPath).subAggregation(innerAggregation);
    }

    @Override
    public ReverseNestedBuilder subAggregation(AggregationBuilder subAggregation) {
        throw new IllegalStateException("ReverseNestedBuilder does not support further nested aggregations");
    }

    @Override
    public JsonObject build() {
        JsonObject result = this.nestedAggregation.build();
        JsonObject innerAggregationJson = result.getAsJsonObject("aggregations").getAsJsonObject(this.innerAggregation.getName());
        innerAggregationJson.add("aggs", (JsonElement)GsonHelper.object(this.getName(), (JsonElement)GsonHelper.object("reverse_nested", (JsonElement)GsonHelper.object())));
        return result;
    }

    @Override
    public AggregationResult parseResponse(JsonObject jsonObject) {
        BucketAggregationResult aggregation = null;
        JsonObject innerAggregation = jsonObject.getAsJsonObject(this.getName());
        JsonElement bucketsElement = innerAggregation.get("buckets");
        if (bucketsElement != null) {
            JsonArray bucketsArray = bucketsElement.getAsJsonArray();
            ArrayList<Bucket> bucketList = new ArrayList<Bucket>();
            for (JsonElement elem : bucketsArray) {
                JsonObject outerBucket = elem.getAsJsonObject();
                JsonObject innerBucket = outerBucket.getAsJsonObject(this.getName());
                if (innerBucket == null) {
                    throw new RuntimeException("No reverse nested aggregation result for " + this.getName());
                }
                bucketList.add(new Bucket(outerBucket.get("key").getAsString(), innerBucket.get("doc_count").getAsLong()));
            }
            aggregation = new BucketAggregationResult(bucketList);
        }
        return aggregation;
    }
}

