/*
 * Decompiled with CFR 0.152.
 */
package de.otto.flummi.aggregations;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import de.otto.flummi.SortOrder;
import de.otto.flummi.aggregations.AggregationBuilder;
import de.otto.flummi.aggregations.AggregationResultParser;
import de.otto.flummi.aggregations.SubAggregationBuilder;
import de.otto.flummi.response.AggregationResult;
import de.otto.flummi.response.Bucket;
import de.otto.flummi.response.BucketAggregationResult;
import de.otto.flummi.util.Pair;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.stream.Collector;

public class TermsBuilder
extends SubAggregationBuilder<TermsBuilder> {
    private String fieldName;
    private Integer size;
    private Integer minDocCount;
    private ArrayList<Pair<String, SortOrder>> orders;

    public TermsBuilder(String name) {
        super(name);
    }

    public TermsBuilder field(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    public TermsBuilder size(int size) {
        this.size = size;
        return this;
    }

    public TermsBuilder minDocCount(int minDocCount) {
        this.minDocCount = minDocCount;
        return this;
    }

    public TermsBuilder order(String fieldName, SortOrder order) {
        if (this.orders == null) {
            this.orders = new ArrayList();
        }
        this.orders.add(new Pair<String, SortOrder>(fieldName, order));
        return this;
    }

    @Override
    public JsonObject build() {
        if (this.fieldName == null || this.fieldName.isEmpty()) {
            throw new RuntimeException("missing property 'field'");
        }
        JsonObject jsonObject = new JsonObject();
        JsonObject fields = new JsonObject();
        jsonObject.add("terms", (JsonElement)fields);
        fields.add("field", (JsonElement)new JsonPrimitive(this.fieldName));
        if (this.size != null) {
            fields.add("size", (JsonElement)new JsonPrimitive((Number)this.size));
        }
        if (this.minDocCount != null) {
            fields.add("min_doc_count", (JsonElement)new JsonPrimitive((Number)this.minDocCount));
        }
        if (this.orders != null) {
            JsonObject orderObject = new JsonObject();
            this.orders.forEach((Consumer<Pair<String, SortOrder>>)((Consumer<Pair>)e -> orderObject.add((String)e.getKey(), (JsonElement)new JsonPrimitive(((SortOrder)((Object)((Object)e.getValue()))).toString()))));
            fields.add("order", (JsonElement)orderObject);
        }
        if (this.subAggregations != null) {
            JsonObject subAggregationsObject = this.subAggregations.stream().collect(TermsBuilder.toJsonObject());
            jsonObject.add("aggregations", (JsonElement)subAggregationsObject);
        }
        return jsonObject;
    }

    private static Collector<AggregationBuilder, JsonObject, JsonObject> toJsonObject() {
        return Collector.of(JsonObject::new, (json, a) -> json.add(a.getName(), (JsonElement)a.build()), (left, right) -> left, new Collector.Characteristics[0]);
    }

    @Override
    public AggregationResult parseResponse(JsonObject jsonObject) {
        BucketAggregationResult aggregation = null;
        JsonElement bucketsElement = jsonObject.get("buckets");
        if (bucketsElement != null) {
            JsonArray bucketsArray = bucketsElement.getAsJsonArray();
            ArrayList<Bucket> bucketList = new ArrayList<Bucket>();
            for (JsonElement elem : bucketsArray) {
                JsonObject elemObject = elem.getAsJsonObject();
                AggregationResult subAggregationResult = AggregationResultParser.parseSubAggregations(elemObject, this.subAggregations);
                Bucket bucket = new Bucket(elemObject.get("key").getAsString(), elemObject.get("doc_count").getAsLong(), subAggregationResult.getNestedAggregations());
                bucketList.add(bucket);
            }
            aggregation = new BucketAggregationResult(bucketList);
        }
        return aggregation;
    }
}

