/*
 * Decompiled with CFR 0.152.
 */
package de.otto.flummi.bulkactions;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import de.otto.flummi.bulkactions.BulkActionBuilder;
import de.otto.flummi.bulkactions.IndexOpType;
import de.otto.flummi.request.GsonHelper;

public class IndexActionBuilder
implements BulkActionBuilder {
    private final String index;
    private final Gson gson;
    private String id;
    private JsonObject source;
    private IndexOpType opType;
    private String parent;

    public IndexActionBuilder(String index) {
        this.index = index;
        this.gson = new Gson();
    }

    public IndexActionBuilder setOpType(IndexOpType opType) {
        this.opType = opType;
        return this;
    }

    public IndexActionBuilder setId(String id) {
        this.id = id;
        return this;
    }

    public IndexActionBuilder setSource(JsonObject source) {
        this.source = source;
        return this;
    }

    public IndexActionBuilder setParent(String parent) {
        this.parent = parent;
        return this;
    }

    @Override
    public String toBulkRequestAction() {
        if (this.index == null || this.index.isEmpty()) {
            throw new RuntimeException("missing property 'index'");
        }
        if (this.opType == null) {
            throw new RuntimeException("missing property 'opType'");
        }
        JsonObject bulkObject = GsonHelper.object("_index", this.index);
        if (this.id != null && !this.id.isEmpty()) {
            bulkObject.add("_id", (JsonElement)new JsonPrimitive(this.id));
        }
        if (this.parent != null && !this.parent.isEmpty()) {
            bulkObject.add("parent", (JsonElement)new JsonPrimitive(this.parent));
        }
        JsonObject jsonObject = GsonHelper.object(this.opType.opCode(), (JsonElement)bulkObject);
        if (IndexOpType.UPDATE.equals((Object)this.opType)) {
            JsonObject docObject = new JsonObject();
            docObject.add("doc", (JsonElement)this.source);
            return this.gson.toJson((JsonElement)jsonObject) + "\n" + this.gson.toJson((JsonElement)docObject);
        }
        return this.gson.toJson((JsonElement)jsonObject) + "\n" + this.gson.toJson((JsonElement)this.source);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexActionBuilder that = (IndexActionBuilder)o;
        if (this.index != null ? !this.index.equals(that.index) : that.index != null) {
            return false;
        }
        if (this.gson != null ? !this.gson.equals(that.gson) : that.gson != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.source != null ? !this.source.equals((Object)that.source) : that.source != null) {
            return false;
        }
        return this.opType == that.opType;
    }

    public int hashCode() {
        int result = this.index != null ? this.index.hashCode() : 0;
        result = 31 * result + (this.gson != null ? this.gson.hashCode() : 0);
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.source != null ? this.source.hashCode() : 0);
        result = 31 * result + (this.opType != null ? this.opType.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "IndexActionBuilder{index='" + this.index + '\'' + ", gson=" + this.gson + ", id='" + this.id + '\'' + ", source=" + this.source + ", opType=" + (Object)((Object)this.opType) + '}';
    }
}

