/*
 * Decompiled with CFR 0.152.
 */
package de.otto.flummi.extensions;

import com.google.gson.JsonObject;
import de.otto.flummi.IndicesAdminClient;
import java.util.Comparator;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RollingIndexBehavior {
    private static final Logger LOG = LoggerFactory.getLogger(RollingIndexBehavior.class);
    private final IndicesAdminClient client;
    private final String aliasName;
    private final String indexPrefixName;
    private final int survivor;
    private final Function<String, String> indexNameFunction;

    RollingIndexBehavior(IndicesAdminClient client, String aliasName, String indexPrefixName, int survivor, Function<String, String> indexNameFunction) {
        this.client = client;
        this.aliasName = aliasName;
        this.indexPrefixName = indexPrefixName;
        this.survivor = survivor;
        this.indexNameFunction = indexNameFunction;
    }

    public String createNewIndex(JsonObject settings, JsonObject mappings) {
        String indexName = this.newIndexName();
        this.client.prepareCreate(indexName).setSettings(settings).setMappings(mappings).execute();
        return indexName;
    }

    public String createNewIndex() {
        String indexName = this.newIndexName();
        this.client.prepareCreate(indexName).execute();
        LOG.info("Index created {}", (Object)indexName);
        return indexName;
    }

    public void abort(String newIndexName) {
        this.client.prepareDelete(newIndexName).execute();
        LOG.warn("Index deleted {}", (Object)newIndexName);
    }

    public Set<String> commit(String indexName) {
        this.client.pointAliasToCurrentIndex(this.aliasName, indexName);
        LOG.info("Alias switched to index name {}", (Object)indexName);
        return this.deleteOldIndices(this.aliasName, this.indexPrefixName, this.survivor);
    }

    private String newIndexName() {
        return this.indexNameFunction.apply(this.indexPrefixName);
    }

    Set<String> deleteOldIndices(String alias, String prefix, int survivor) {
        if (survivor < 1) {
            throw new IllegalArgumentException("must have one survivor");
        }
        Optional<String> aliasToIndex = this.client.getIndexNameForAlias(alias);
        Set<String> names = this.client.getAllIndexNames().stream().filter(RollingIndexBehavior.startsWith(prefix)).sorted(Comparator.reverseOrder()).skip(survivor).filter(RollingIndexBehavior.skipAlias(aliasToIndex)).collect(Collectors.toSet());
        if (!names.isEmpty()) {
            this.client.prepareDelete(names.stream()).execute();
        }
        LOG.info("Indices deleted {}", names);
        return names;
    }

    private static Predicate<String> startsWith(String prefix) {
        return s -> s.startsWith(prefix);
    }

    private static Predicate<String> skipAlias(Optional<String> indexName) {
        return s -> !indexName.isPresent() || !s.equals(indexName.get());
    }
}

