/*
 * Decompiled with CFR 0.152.
 */
package de.otto.flummi.query;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import de.otto.flummi.query.QueryBuilder;
import de.otto.flummi.request.GsonHelper;

public class BoolQueryBuilder
implements QueryBuilder {
    private JsonArray mustFilter = GsonHelper.array(new JsonElement[0]);
    private JsonArray mustNotFilter = GsonHelper.array(new JsonElement[0]);
    private JsonArray shouldFilter = GsonHelper.array(new JsonElement[0]);
    private String minimumShouldMatch = null;

    @Override
    public JsonObject build() {
        if (this.mustFilter.size() == 0 && this.mustNotFilter.size() == 0 && this.shouldFilter.size() == 0) {
            throw new RuntimeException("mustFilter and mustNotFilter are empty");
        }
        JsonObject jsonObject = new JsonObject();
        JsonObject boolObject = new JsonObject();
        jsonObject.add("bool", (JsonElement)boolObject);
        if (this.mustFilter.size() > 0) {
            if (this.mustFilter.size() == 1) {
                boolObject.add("must", this.mustFilter.get(0));
            } else {
                boolObject.add("must", (JsonElement)this.mustFilter);
            }
        }
        if (this.mustNotFilter.size() > 0) {
            if (this.mustNotFilter.size() == 1) {
                boolObject.add("must_not", this.mustNotFilter.get(0));
            } else {
                boolObject.add("must_not", (JsonElement)this.mustNotFilter);
            }
        }
        if (this.shouldFilter.size() > 0) {
            if (this.shouldFilter.size() == 1) {
                boolObject.add("should", this.shouldFilter.get(0));
            } else {
                boolObject.add("should", (JsonElement)this.shouldFilter);
            }
        }
        if (this.minimumShouldMatch != null) {
            boolObject.add("minimum_should_match", (JsonElement)new JsonPrimitive(this.minimumShouldMatch));
        }
        return jsonObject;
    }

    public boolean isEmpty() {
        return this.mustFilter.size() == 0 && this.mustNotFilter.size() == 0 && this.shouldFilter.size() == 0;
    }

    public BoolQueryBuilder must(JsonObject filter) {
        this.mustFilter.add((JsonElement)filter);
        return this;
    }

    public BoolQueryBuilder mustNot(JsonObject filter) {
        this.mustNotFilter.add((JsonElement)filter);
        return this;
    }

    public BoolQueryBuilder must(QueryBuilder queryBuilder) {
        this.must(queryBuilder.build());
        return this;
    }

    public BoolQueryBuilder should(QueryBuilder queryBuilder) {
        this.should(queryBuilder.build());
        return this;
    }

    public BoolQueryBuilder should(JsonObject shouldFilter) {
        this.shouldFilter.add((JsonElement)shouldFilter);
        return this;
    }

    public BoolQueryBuilder mustNot(QueryBuilder queryBuilder) {
        this.mustNot(queryBuilder.build());
        return this;
    }

    public BoolQueryBuilder minimumShouldMatch(String s) {
        this.minimumShouldMatch = s;
        return this;
    }
}

