/*
 * Decompiled with CFR 0.152.
 */
package de.otto.flummi.query;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import de.otto.flummi.query.QueryBuilder;
import de.otto.flummi.request.GsonHelper;

public class FuzzyQueryBuilder
implements QueryBuilder {
    private final String fieldName;
    private final String value;
    private int boost = 1;
    private int maxExpansions = 50;
    private Integer fuzziness = null;
    private int prefixLength = 0;

    public FuzzyQueryBuilder(String fieldName, String value) {
        this.fieldName = fieldName;
        this.value = value;
    }

    public FuzzyQueryBuilder boost(int boost) {
        this.boost = boost;
        return this;
    }

    public FuzzyQueryBuilder maxExpansions(int maxExpansions) {
        this.maxExpansions = maxExpansions;
        return this;
    }

    public FuzzyQueryBuilder prefixLength(int prefixLength) {
        this.prefixLength = prefixLength;
        return this;
    }

    public FuzzyQueryBuilder fuzziness(int fuzziness) {
        this.fuzziness = fuzziness;
        return this;
    }

    @Override
    public JsonObject build() {
        JsonObject options = GsonHelper.object("value", this.value);
        if (this.boost != 1) {
            options.add("boost", (JsonElement)new JsonPrimitive((Number)this.boost));
        }
        if (this.maxExpansions != 50) {
            options.add("max_expansions", (JsonElement)new JsonPrimitive((Number)this.maxExpansions));
        }
        if (this.fuzziness != null) {
            options.add("fuzziness", (JsonElement)new JsonPrimitive((Number)this.fuzziness));
        }
        if (this.prefixLength != 0) {
            options.add("prefix_length", (JsonElement)new JsonPrimitive((Number)this.prefixLength));
        }
        return GsonHelper.object("fuzzy", (JsonElement)GsonHelper.object(this.fieldName, (JsonElement)options));
    }
}

