/*
 * Decompiled with CFR 0.152.
 */
package de.otto.flummi.query;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import de.otto.flummi.GsonCollectors;
import de.otto.flummi.query.AndQueryBuilder;
import de.otto.flummi.query.BoolQueryBuilder;
import de.otto.flummi.query.DateRangeQueryBuilder;
import de.otto.flummi.query.FunctionScoreQueryBuilder;
import de.otto.flummi.query.FuzzyQueryBuilder;
import de.otto.flummi.query.GeoDistanceQueryBuilder;
import de.otto.flummi.query.HasParentQueryBuilder;
import de.otto.flummi.query.NumberRangeQueryBuilder;
import de.otto.flummi.query.QueryBuilder;
import de.otto.flummi.query.RegexpQueryBuilder;
import de.otto.flummi.query.TermQueryBuilder;
import de.otto.flummi.query.TermsQueryBuilder;
import de.otto.flummi.query.WildcardQueryBuilder;
import de.otto.flummi.request.GsonHelper;
import java.util.Arrays;
import java.util.List;

public class QueryBuilders {
    public static QueryBuilder matchAll() {
        return () -> {
            JsonObject query = new JsonObject();
            query.add("match_all", (JsonElement)new JsonObject());
            return query;
        };
    }

    public static QueryBuilder filteredQuery(QueryBuilder query, JsonObject filter) {
        return () -> {
            JsonObject outerQuery = new JsonObject();
            JsonObject filtered = new JsonObject();
            outerQuery.add("bool", (JsonElement)filtered);
            filtered.add("must", (JsonElement)query.build());
            filtered.add("filter", (JsonElement)filter);
            return outerQuery;
        };
    }

    public static QueryBuilder query(QueryBuilder query) {
        return () -> {
            JsonObject search = new JsonObject();
            search.add("query", (JsonElement)query.build());
            return search;
        };
    }

    public static TermsQueryBuilder termsQuery(String name, JsonElement values) {
        return new TermsQueryBuilder(name, values);
    }

    public static TermsQueryBuilder termsQuery(String name, String ... values) {
        return new TermsQueryBuilder(name, (JsonElement)Arrays.stream(values).map(JsonPrimitive::new).collect(GsonCollectors.toJsonArray()));
    }

    public static TermsQueryBuilder termsQuery(String name, Boolean ... values) {
        return new TermsQueryBuilder(name, (JsonElement)Arrays.stream(values).map(JsonPrimitive::new).collect(GsonCollectors.toJsonArray()));
    }

    public static TermsQueryBuilder termsQuery(String name, Number ... values) {
        return new TermsQueryBuilder(name, (JsonElement)Arrays.stream(values).map(JsonPrimitive::new).collect(GsonCollectors.toJsonArray()));
    }

    public static TermsQueryBuilder termsQuery(String name, List<String> values) {
        return new TermsQueryBuilder(name, (JsonElement)values.stream().map(JsonPrimitive::new).collect(GsonCollectors.toJsonArray()));
    }

    public static TermQueryBuilder termQuery(String name, JsonElement value) {
        return new TermQueryBuilder(name, value);
    }

    public static TermQueryBuilder termQuery(String name, String value) {
        return new TermQueryBuilder(name, (JsonElement)new JsonPrimitive(value));
    }

    public static TermQueryBuilder termQuery(String name, Boolean value) {
        return new TermQueryBuilder(name, (JsonElement)new JsonPrimitive(value));
    }

    public static TermQueryBuilder termQuery(String name, Number value) {
        return new TermQueryBuilder(name, (JsonElement)new JsonPrimitive(value));
    }

    public static WildcardQueryBuilder wildcardQuery(String name, String value) {
        return QueryBuilders.wildcardQuery(name, (JsonElement)new JsonPrimitive(value));
    }

    public static WildcardQueryBuilder wildcardQuery(String name, JsonElement value) {
        return new WildcardQueryBuilder(name, value);
    }

    public static RegexpQueryBuilder regexpQuery(String name, String value) {
        return QueryBuilders.regexpQuery(name, (JsonElement)new JsonPrimitive(value));
    }

    public static RegexpQueryBuilder regexpQuery(String name, JsonElement value) {
        return new RegexpQueryBuilder(name, value);
    }

    public static BoolQueryBuilder bool() {
        return new BoolQueryBuilder();
    }

    public static QueryBuilder notQuery(QueryBuilder nestedFilter) {
        return () -> GsonHelper.object("not", (JsonElement)nestedFilter.build());
    }

    public static QueryBuilder nestedQuery(String path, QueryBuilder queryBuilder) {
        return () -> {
            JsonObject jsonObject = new JsonObject();
            JsonObject nested = new JsonObject();
            nested.add("query", (JsonElement)queryBuilder.build());
            nested.add("path", (JsonElement)new JsonPrimitive(path));
            jsonObject.add("nested", (JsonElement)nested);
            return jsonObject;
        };
    }

    public static QueryBuilder prefixFilter(String name, String prefix) {
        return () -> {
            JsonObject jsonObject = new JsonObject();
            JsonObject value = new JsonObject();
            value.add(name, (JsonElement)new JsonPrimitive(prefix));
            jsonObject.add("prefix", (JsonElement)value);
            return jsonObject;
        };
    }

    public static JsonObject existsFilter(String fieldName) {
        JsonObject jsonObject = new JsonObject();
        JsonObject existsObject = new JsonObject();
        jsonObject.add("exists", (JsonElement)existsObject);
        existsObject.add("field", (JsonElement)new JsonPrimitive(fieldName));
        return jsonObject;
    }

    public static AndQueryBuilder andQuery(QueryBuilder ... queries) {
        return new AndQueryBuilder(queries);
    }

    public static AndQueryBuilder andQuery(List<QueryBuilder> queries) {
        return new AndQueryBuilder(queries);
    }

    public static NumberRangeQueryBuilder numberRangeFilter(String fieldName) {
        return new NumberRangeQueryBuilder(fieldName);
    }

    public static DateRangeQueryBuilder dateRangeFilter(String fieldName) {
        return new DateRangeQueryBuilder(fieldName);
    }

    public static HasParentQueryBuilder hasParent(String type, QueryBuilder query) {
        return new HasParentQueryBuilder(type, query);
    }

    public static FunctionScoreQueryBuilder functionScoreQuery(QueryBuilder innerQuery) {
        return new FunctionScoreQueryBuilder(innerQuery);
    }

    public static QueryBuilder boostingQuery(QueryBuilder positive, QueryBuilder negative, double negativeBoost) {
        return () -> GsonHelper.object("boosting", (JsonElement)GsonHelper.object("positive", (JsonElement)positive.build(), "negative", (JsonElement)negative.build(), "negative_boost", (JsonElement)new JsonPrimitive((Number)negativeBoost)));
    }

    public static FuzzyQueryBuilder fuzzyQuery(String fieldName, String value) {
        return new FuzzyQueryBuilder(fieldName, value);
    }

    public static GeoDistanceQueryBuilder geoDistanceQuery(String name) {
        return new GeoDistanceQueryBuilder(name);
    }
}

