/*
 * Decompiled with CFR 0.152.
 */
package de.otto.flummi.query;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import de.otto.flummi.query.QueryBuilder;
import de.otto.flummi.request.GsonHelper;

public class TermQueryBuilder
implements QueryBuilder {
    private final String name;
    private final JsonElement value;
    private int boost = 1;

    public TermQueryBuilder(String name, JsonElement value) {
        this.name = name;
        this.value = value;
    }

    public TermQueryBuilder boost(int boost) {
        this.boost = boost;
        return this;
    }

    @Override
    public JsonObject build() {
        if (this.name == null || this.name.isEmpty()) {
            throw new RuntimeException("missing property 'name'");
        }
        if (this.value == null) {
            throw new RuntimeException("missing property 'value'");
        }
        JsonObject term = GsonHelper.object(this.name, this.value);
        if (this.boost != 1) {
            term.add("boost", (JsonElement)new JsonPrimitive((Number)this.boost));
        }
        return GsonHelper.object("term", (JsonElement)term);
    }
}

