/*
 * Decompiled with CFR 0.152.
 */
package de.otto.flummi.request;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import de.otto.flummi.RequestBuilderUtil;
import de.otto.flummi.request.RequestBuilder;
import de.otto.flummi.response.AnalyzeResponse;
import de.otto.flummi.response.Token;
import de.otto.flummi.util.HttpClientWrapper;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyzeRequestBuilder
implements RequestBuilder<AnalyzeResponse> {
    private HttpClientWrapper httpClient;
    private final Gson gson;
    private String indexName;
    private final String text;
    private String tokenizer;
    private String analyzer;
    private String field;
    private JsonArray filters;
    private JsonArray characterFilters;
    public static final Logger LOG = LoggerFactory.getLogger(AnalyzeRequestBuilder.class);

    public AnalyzeRequestBuilder(HttpClientWrapper httpClient, String text) {
        this.httpClient = httpClient;
        this.text = text;
        this.gson = new Gson();
    }

    @Override
    public AnalyzeResponse execute() {
        JsonObject body = new JsonObject();
        try {
            Response response;
            String url = this.buildUrl();
            if (this.text != null) {
                body.add("text", (JsonElement)new JsonPrimitive(this.text));
            }
            if (this.analyzer != null) {
                body.add("analyzer", (JsonElement)new JsonPrimitive(this.analyzer));
            }
            if (this.tokenizer != null) {
                body.add("tokenizer", (JsonElement)new JsonPrimitive(this.tokenizer));
            }
            if (this.field != null) {
                body.add("field", (JsonElement)new JsonPrimitive(this.field));
            }
            if (this.filters != null) {
                body.add("filter", (JsonElement)this.filters);
            }
            if (this.characterFilters != null) {
                body.add("char_filter", (JsonElement)this.characterFilters);
            }
            if ((response = (Response)((BoundRequestBuilder)((BoundRequestBuilder)((BoundRequestBuilder)this.httpClient.prepareGet(url).setCharset(Charset.forName("UTF-8"))).addHeader((CharSequence)"Content-Type", "application/json")).setBody(this.gson.toJson((JsonElement)body))).execute().get()).getStatusCode() != 200) {
                throw RequestBuilderUtil.toHttpServerErrorException(response);
            }
            JsonObject jsonResponse = (JsonObject)this.gson.fromJson(response.getResponseBody(), JsonObject.class);
            AnalyzeResponse.Builder analyzeResponse = AnalyzeRequestBuilder.parseResponse(jsonResponse);
            return analyzeResponse.build();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private String buildUrl() {
        StringBuilder urlBuilder = new StringBuilder();
        if (this.indexName != null) {
            urlBuilder.append("/").append(this.indexName);
        }
        urlBuilder.append("/").append("_analyze");
        return urlBuilder.toString();
    }

    public AnalyzeRequestBuilder setTokenizer(String tokenizer) {
        this.tokenizer = tokenizer;
        return this;
    }

    public AnalyzeRequestBuilder setAnalyzer(String analyzer) {
        this.analyzer = analyzer;
        return this;
    }

    public AnalyzeRequestBuilder setIndexName(String indexName) {
        this.indexName = indexName;
        return this;
    }

    public AnalyzeRequestBuilder appendFilter(String filter) {
        if (this.filters == null) {
            this.filters = new JsonArray();
        }
        this.filters.add((JsonElement)new JsonPrimitive(filter));
        return this;
    }

    public AnalyzeRequestBuilder appendCharacterFilter(String characterFilter) {
        if (this.characterFilters == null) {
            this.characterFilters = new JsonArray();
        }
        this.characterFilters.add((JsonElement)new JsonPrimitive(characterFilter));
        return this;
    }

    public AnalyzeRequestBuilder setField(String field) {
        this.field = field;
        return this;
    }

    public static AnalyzeResponse.Builder parseResponse(JsonObject jsonObject) {
        AnalyzeResponse.Builder analyzeResponse = AnalyzeResponse.builder();
        JsonArray tokensArray = jsonObject.get("tokens").getAsJsonArray();
        ArrayList<Token> tokens = new ArrayList<Token>();
        for (JsonElement element : tokensArray) {
            JsonObject asJsonObject = element.getAsJsonObject();
            String token = asJsonObject.get("token").getAsString();
            String type = asJsonObject.get("type").getAsString();
            Integer position = asJsonObject.get("position").getAsInt();
            Integer startOffset = asJsonObject.get("start_offset").getAsInt();
            Integer endOffset = asJsonObject.get("end_offset").getAsInt();
            Token t = new Token(token, type, position, startOffset, endOffset);
            tokens.add(t);
        }
        analyzeResponse.setHits(tokens);
        return analyzeResponse;
    }
}

