/*
 * Decompiled with CFR 0.152.
 */
package de.otto.flummi.request;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import de.otto.flummi.RequestBuilderUtil;
import de.otto.flummi.request.RequestBuilder;
import de.otto.flummi.util.HttpClientWrapper;
import java.util.concurrent.ExecutionException;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CountRequestBuilder
implements RequestBuilder<Long> {
    private final String[] indices;
    private final Gson gson;
    private String[] types;
    public static final Logger LOG = LoggerFactory.getLogger(CountRequestBuilder.class);
    private HttpClientWrapper httpClient;

    public CountRequestBuilder(HttpClientWrapper httpClient, String ... indices) {
        this.httpClient = httpClient;
        this.indices = indices;
        this.gson = new Gson();
    }

    public CountRequestBuilder setTypes(String ... types) {
        this.types = types;
        return this;
    }

    @Override
    public Long execute() {
        try {
            String url = RequestBuilderUtil.buildUrl(this.indices, this.types, "_count");
            Response response = (Response)((BoundRequestBuilder)this.httpClient.prepareGet(url).addHeader((CharSequence)"Content-Type", "application/json")).execute().get();
            if (response.getStatusCode() >= 300) {
                throw RequestBuilderUtil.toHttpServerErrorException(response);
            }
            String jsonString = response.getResponseBody();
            JsonObject responseObject = (JsonObject)this.gson.fromJson(jsonString, JsonObject.class);
            return responseObject.get("count").getAsLong();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

