/*
 * Decompiled with CFR 0.152.
 */
package de.otto.flummi.request;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.otto.flummi.InvalidElasticsearchResponseException;
import de.otto.flummi.RequestBuilderUtil;
import de.otto.flummi.request.RequestBuilder;
import de.otto.flummi.util.HttpClientWrapper;
import java.nio.charset.Charset;
import java.util.concurrent.ExecutionException;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateIndexRequestBuilder
implements RequestBuilder<Void> {
    private final Gson gson;
    private final String indexName;
    private JsonObject settings;
    private JsonObject mappings;
    private final HttpClientWrapper httpClient;
    public static final Logger LOG = LoggerFactory.getLogger(CreateIndexRequestBuilder.class);

    public CreateIndexRequestBuilder(HttpClientWrapper httpClient, String indexName) {
        this.httpClient = httpClient;
        this.indexName = indexName;
        this.gson = new Gson();
    }

    public CreateIndexRequestBuilder setSettings(JsonObject settings) {
        this.settings = settings;
        return this;
    }

    public CreateIndexRequestBuilder setMappings(JsonObject mappings) {
        this.mappings = mappings;
        return this;
    }

    @Override
    public Void execute() {
        JsonObject jsonObject = new JsonObject();
        if (this.settings != null) {
            jsonObject.add("settings", (JsonElement)this.settings);
        }
        if (this.mappings != null) {
            jsonObject.add("mappings", (JsonElement)this.mappings);
        }
        try {
            Response response = (Response)((BoundRequestBuilder)((BoundRequestBuilder)((BoundRequestBuilder)this.httpClient.preparePut("/" + this.indexName).setBody(jsonObject.toString())).setCharset(Charset.forName("UTF-8"))).addHeader((CharSequence)"Content-Type", "application/json")).execute().get();
            if (response.getStatusCode() >= 300) {
                throw RequestBuilderUtil.toHttpServerErrorException(response);
            }
            String jsonString = response.getResponseBody();
            JsonObject responseObject = (JsonObject)this.gson.fromJson(jsonString, JsonObject.class);
            if (!responseObject.has("acknowledged") || !responseObject.get("acknowledged").getAsBoolean()) {
                throw new InvalidElasticsearchResponseException("Invalid reply from Elastic Search: " + jsonString);
            }
            return null;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

