/*
 * Decompiled with CFR 0.152.
 */
package de.otto.flummi.request;

import de.otto.flummi.RequestBuilderUtil;
import de.otto.flummi.request.RequestBuilder;
import de.otto.flummi.util.HttpClientWrapper;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.Response;

public class DeleteIndexRequestBuilder
implements RequestBuilder<Void> {
    private final HttpClientWrapper httpClient;
    private final String[] indexNames;

    public DeleteIndexRequestBuilder(HttpClientWrapper httpClient, Stream<String> indexNames) {
        this.httpClient = httpClient;
        this.indexNames = this.toArray(indexNames);
    }

    @Override
    public Void execute() {
        if (this.indexNames.length == 0) {
            throw new RuntimeException("index names are missing");
        }
        try {
            String url = RequestBuilderUtil.buildUrl(this.indexNames, null, null);
            Response response = (Response)((BoundRequestBuilder)this.httpClient.prepareDelete(url).addHeader((CharSequence)"Content-Type", "application/json")).execute().get();
            if (response.getStatusCode() >= 300 && response.getStatusCode() != 404) {
                throw RequestBuilderUtil.toHttpServerErrorException(response);
            }
            return null;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private String[] toArray(Stream<String> indexNames) {
        return indexNames == null ? null : indexNames.collect(Collectors.toList()).toArray(new String[0]);
    }
}

