/*
 * Decompiled with CFR 0.152.
 */
package de.otto.flummi.request;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import de.otto.flummi.RequestBuilderUtil;
import de.otto.flummi.request.RequestBuilder;
import de.otto.flummi.response.GetResponse;
import de.otto.flummi.util.HttpClientWrapper;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URLEncoder;
import java.util.concurrent.ExecutionException;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetRequestBuilder
implements RequestBuilder<GetResponse> {
    private HttpClientWrapper httpClient;
    private final String indexName;
    private final String documentType;
    private final String id;
    private final Gson gson;
    public static final Logger LOG = LoggerFactory.getLogger(GetRequestBuilder.class);

    public GetRequestBuilder(HttpClientWrapper httpClient, String indexName, String documentType, String id) {
        this.httpClient = httpClient;
        this.indexName = indexName;
        this.documentType = documentType;
        this.id = id;
        this.gson = new Gson();
    }

    @Override
    public GetResponse execute() {
        try {
            String url = RequestBuilderUtil.buildUrl(this.indexName, this.documentType, URLEncoder.encode(this.id, "UTF-8"));
            Response response = (Response)((BoundRequestBuilder)this.httpClient.prepareGet(url).addHeader((CharSequence)"Content-Type", "application/json")).execute().get();
            if (response.getStatusCode() >= 300 && 404 != response.getStatusCode()) {
                throw RequestBuilderUtil.toHttpServerErrorException(response);
            }
            if (404 == response.getStatusCode()) {
                return new GetResponse(false, null, this.id);
            }
            String jsonString = response.getResponseBody();
            JsonObject responseObject = (JsonObject)this.gson.fromJson(jsonString, JsonObject.class);
            return new GetResponse(true, responseObject != null && responseObject.get("_source") != null ? responseObject.get("_source").getAsJsonObject() : null, responseObject.get("_id").getAsString());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

