/*
 * Decompiled with CFR 0.152.
 */
package de.otto.flummi.request;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import de.otto.flummi.RequestBuilderUtil;
import de.otto.flummi.domain.index.Index;
import de.otto.flummi.request.RequestBuilder;
import de.otto.flummi.util.HttpClientWrapper;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.concurrent.ExecutionException;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexRequestBuilder
implements RequestBuilder<Void> {
    private final Gson gson;
    private JsonPrimitive id;
    private String indexName;
    private String documentType;
    private JsonObject source;
    private String parent;
    public static final Logger LOG = LoggerFactory.getLogger(IndexRequestBuilder.class);
    private HttpClientWrapper httpClient;
    private Index index;

    public IndexRequestBuilder(HttpClientWrapper httpClient) {
        this.httpClient = httpClient;
        this.gson = new Gson();
    }

    public IndexRequestBuilder setId(String id) {
        this.id = new JsonPrimitive(id);
        return this;
    }

    public IndexRequestBuilder setId(int id) {
        this.id = new JsonPrimitive((Number)id);
        return this;
    }

    public IndexRequestBuilder setIndexName(String indexName) {
        this.indexName = indexName;
        return this;
    }

    public IndexRequestBuilder setDocumentType(String documentType) {
        this.documentType = documentType;
        return this;
    }

    public IndexRequestBuilder setSource(JsonObject source) {
        this.source = source;
        return this;
    }

    public IndexRequestBuilder setIndex(Index index) {
        this.index = index;
        return this;
    }

    public IndexRequestBuilder setParent(String parent) {
        this.parent = parent;
        return this;
    }

    @Override
    public Void execute() {
        if (this.source == null) {
            if (this.index == null) {
                throw new IllegalStateException("either source or indexSettings must exist");
            }
        } else if (this.index != null) {
            throw new IllegalStateException("either source or indexSettings is allowed to specified");
        }
        try {
            String body;
            Response response;
            BoundRequestBuilder reqBuilder;
            String url;
            if (this.id != null) {
                url = RequestBuilderUtil.buildUrl(this.indexName, this.documentType, URLEncoder.encode(this.id.getAsString(), "UTF-8"));
                reqBuilder = this.httpClient.preparePut(url);
            } else {
                url = RequestBuilderUtil.buildUrl(this.indexName, this.documentType);
                reqBuilder = this.httpClient.preparePost(url);
            }
            if (this.parent != null) {
                reqBuilder.addQueryParam("parent", this.parent);
            }
            if ((response = (Response)((BoundRequestBuilder)((BoundRequestBuilder)((BoundRequestBuilder)reqBuilder.setBody(body = this.createBody())).setCharset(Charset.forName("UTF-8"))).addHeader((CharSequence)"Content-Type", "application/json")).execute().get()).getStatusCode() >= 300) {
                throw RequestBuilderUtil.toHttpServerErrorException(response);
            }
            return null;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private String createBody() {
        if (this.source != null) {
            return this.gson.toJson((JsonElement)this.source);
        }
        if (this.index != null) {
            return this.gson.toJson((Object)this.index);
        }
        throw new IllegalStateException();
    }
}

