/*
 * Decompiled with CFR 0.152.
 */
package de.otto.flummi.request;

import de.otto.flummi.request.RequestBuilder;
import de.otto.flummi.response.HttpServerErrorException;
import de.otto.flummi.util.HttpClientWrapper;
import java.util.concurrent.ExecutionException;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndicesExistsRequestBuilder
implements RequestBuilder<Boolean> {
    private final String indexName;
    public static final Logger LOG = LoggerFactory.getLogger(IndicesExistsRequestBuilder.class);
    private HttpClientWrapper httpClient;

    public IndicesExistsRequestBuilder(HttpClientWrapper httpClient, String indexName) {
        this.indexName = indexName;
        this.httpClient = httpClient;
    }

    @Override
    public Boolean execute() {
        try {
            Response response = (Response)((BoundRequestBuilder)this.httpClient.prepareHead("/" + this.indexName).addHeader((CharSequence)"Content-Type", "application/json")).execute().get();
            int statusCode = response.getStatusCode();
            if (statusCode >= 300 && response.getStatusCode() != 404) {
                throw new HttpServerErrorException(response.getStatusCode(), response.getStatusText(), response.getResponseBody());
            }
            return statusCode < 300;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

