/*
 * Decompiled with CFR 0.152.
 */
package de.otto.flummi.request;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import de.otto.flummi.RequestBuilderUtil;
import de.otto.flummi.request.GsonHelper;
import de.otto.flummi.request.RequestBuilder;
import de.otto.flummi.response.MultiGetRequestDocument;
import de.otto.flummi.response.MultiGetResponse;
import de.otto.flummi.response.MultiGetResponseDocument;
import de.otto.flummi.util.HttpClientWrapper;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiGetRequestBuilder
implements RequestBuilder<MultiGetResponse> {
    private final String[] indices;
    private final Gson gson = new Gson();
    private final HttpClientWrapper httpClient;
    private String[] types;
    private Integer timeoutMillis;
    private List<MultiGetRequestDocument> documents;
    public static final Logger LOG = LoggerFactory.getLogger(MultiGetRequestBuilder.class);

    public MultiGetRequestBuilder(HttpClientWrapper httpClient, String ... indices) {
        this.httpClient = httpClient;
        this.indices = indices;
    }

    public MultiGetRequestBuilder setRequestDocuments(List<MultiGetRequestDocument> requestDocument) {
        this.documents = requestDocument;
        return this;
    }

    public MultiGetRequestBuilder setTypes(String ... types) {
        this.types = types;
        return this;
    }

    public MultiGetRequestBuilder setTimeoutMillis(Integer timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
        return this;
    }

    @Override
    public MultiGetResponse execute() {
        try {
            String url = RequestBuilderUtil.buildUrl(this.indices, this.types, "_mget");
            JsonObject body = new JsonObject();
            if (this.documents != null) {
                body.add("docs", (JsonElement)GsonHelper.array(this.documents.stream().map(d -> this.create((MultiGetRequestDocument)d)).collect(Collectors.toList())));
            }
            BoundRequestBuilder boundRequestBuilder = (BoundRequestBuilder)this.httpClient.preparePost(url).setCharset(Charset.forName("UTF-8"));
            if (this.timeoutMillis != null) {
                boundRequestBuilder.setRequestTimeout(this.timeoutMillis.intValue());
            }
            long start = System.currentTimeMillis();
            Response response = (Response)((BoundRequestBuilder)((BoundRequestBuilder)boundRequestBuilder.setBody(this.gson.toJson((JsonElement)body))).addHeader((CharSequence)"Content-Type", "application/json")).execute().get();
            long tookInMillis = System.currentTimeMillis() - start;
            if (response.getStatusCode() == 404) {
                return new MultiGetResponse(Collections.emptyList(), tookInMillis);
            }
            if (response.getStatusCode() >= 300) {
                throw RequestBuilderUtil.toHttpServerErrorException(response);
            }
            JsonObject jsonObject = (JsonObject)this.gson.fromJson(response.getResponseBody(), JsonObject.class);
            JsonArray docs = jsonObject.get("docs").getAsJsonArray();
            ArrayList<MultiGetResponseDocument> documents = new ArrayList<MultiGetResponseDocument>();
            for (JsonElement doc : docs) {
                JsonObject jsonDoc = doc.getAsJsonObject();
                String id = jsonDoc.get("_id").getAsString();
                JsonObject source = new JsonObject();
                boolean found = jsonDoc.get("found").getAsBoolean();
                if (found) {
                    source = jsonDoc.get("_source").getAsJsonObject();
                }
                documents.add(new MultiGetResponseDocument(id, found, source));
            }
            return new MultiGetResponse(documents, tookInMillis);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private JsonObject create(MultiGetRequestDocument multiGetRequestDocument) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("_id", (JsonElement)new JsonPrimitive(multiGetRequestDocument.getId()));
        if (multiGetRequestDocument.getType() != null) {
            jsonObject.add("_type", (JsonElement)new JsonPrimitive(multiGetRequestDocument.getType()));
        }
        if (multiGetRequestDocument.getIndex() != null) {
            jsonObject.add("_index", (JsonElement)new JsonPrimitive(multiGetRequestDocument.getIndex()));
        }
        if (multiGetRequestDocument.getFields() != null && multiGetRequestDocument.getFields().length > 0) {
            ArrayList<JsonElement> fieldList = new ArrayList<JsonElement>();
            for (String field : multiGetRequestDocument.getFields()) {
                fieldList.add((JsonElement)new JsonPrimitive(field));
            }
            jsonObject.add("fields", (JsonElement)GsonHelper.array(fieldList));
        }
        return jsonObject;
    }
}

