/*
 * Decompiled with CFR 0.152.
 */
package de.otto.flummi.request;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import de.otto.flummi.RequestBuilderUtil;
import de.otto.flummi.SortOrder;
import de.otto.flummi.aggregations.AggregationBuilder;
import de.otto.flummi.query.QueryBuilder;
import de.otto.flummi.query.sort.FieldSortBuilder;
import de.otto.flummi.query.sort.SortBuilder;
import de.otto.flummi.request.RequestBuilder;
import de.otto.flummi.response.AggregationResult;
import de.otto.flummi.response.ScrollingSearchHits;
import de.otto.flummi.response.SearchHit;
import de.otto.flummi.response.SearchResponse;
import de.otto.flummi.response.SimpleSearchHits;
import de.otto.flummi.util.HttpClientWrapper;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collector;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchRequestBuilder
implements RequestBuilder<SearchResponse> {
    private static final JsonObject EMPTY_JSON_OBJECT = new JsonObject();
    private HttpClientWrapper httpClient;
    private final String[] indices;
    private final Gson gson;
    private String[] types;
    private JsonObject query;
    private Integer from;
    private Integer size;
    private Integer timeoutMillis;
    private JsonArray sorts;
    private JsonArray storedFields;
    private JsonArray sourceFilters;
    private String scroll;
    private QueryBuilder postFilter;
    private List<AggregationBuilder> aggregations;
    public static final Logger LOG = LoggerFactory.getLogger(SearchRequestBuilder.class);

    public SearchRequestBuilder(HttpClientWrapper httpClient, String ... indices) {
        this.httpClient = httpClient;
        this.indices = indices;
        this.gson = new Gson();
    }

    public SearchRequestBuilder setScroll(String scroll) {
        this.scroll = scroll;
        return this;
    }

    public SearchRequestBuilder setTypes(String ... types) {
        this.types = types;
        return this;
    }

    public SearchRequestBuilder setQuery(JsonObject query) {
        this.query = query;
        return this;
    }

    public SearchRequestBuilder addAggregation(AggregationBuilder AggregationBuilder2) {
        if (this.aggregations == null) {
            this.aggregations = new ArrayList<AggregationBuilder>();
        }
        this.aggregations.add(AggregationBuilder2);
        return this;
    }

    public SearchRequestBuilder addSort(String key, SortOrder order) {
        return this.addSort(new FieldSortBuilder(key).setOrder(order));
    }

    public SearchRequestBuilder addSort(SortBuilder builder) {
        if (this.sorts == null) {
            this.sorts = new JsonArray();
        }
        this.sorts.add((JsonElement)builder.build());
        return this;
    }

    public SearchRequestBuilder setFrom(int from) {
        this.from = from;
        return this;
    }

    public SearchRequestBuilder setSize(int size) {
        this.size = size;
        return this;
    }

    public SearchRequestBuilder addStoredField(String fieldName) {
        if (this.storedFields == null) {
            this.storedFields = new JsonArray();
        }
        this.storedFields.add((JsonElement)new JsonPrimitive(fieldName));
        return this;
    }

    public SearchRequestBuilder addSourceFilter(String filter) {
        if (this.sourceFilters == null) {
            this.sourceFilters = new JsonArray();
        }
        this.sourceFilters.add((JsonElement)new JsonPrimitive(filter));
        return this;
    }

    public SearchRequestBuilder setTimeoutMillis(Integer timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
        return this;
    }

    @Override
    public SearchResponse execute() {
        JsonObject body = new JsonObject();
        try {
            Response response;
            String url = RequestBuilderUtil.buildUrl(this.indices, this.types, "_search");
            if (this.query != null) {
                body.add("query", (JsonElement)this.query);
            }
            if (this.storedFields != null) {
                body.add("stored_fields", (JsonElement)this.storedFields);
            }
            if (this.sourceFilters != null) {
                body.add("_source", (JsonElement)this.sourceFilters);
            }
            if (this.from != null) {
                body.add("from", (JsonElement)new JsonPrimitive((Number)this.from));
            }
            if (this.size != null) {
                body.add("size", (JsonElement)new JsonPrimitive((Number)this.size));
            }
            if (this.sorts != null) {
                body.add("sort", (JsonElement)this.sorts);
            }
            if (this.postFilter != null) {
                body.add("post_filter", (JsonElement)this.postFilter.build());
            }
            if (this.aggregations != null) {
                JsonObject jsonObject = this.aggregations.stream().collect(SearchRequestBuilder.toJsonObject());
                body.add("aggregations", (JsonElement)jsonObject);
            }
            BoundRequestBuilder boundRequestBuilder = (BoundRequestBuilder)this.httpClient.preparePost(url).setCharset(Charset.forName("UTF-8"));
            if (this.timeoutMillis != null) {
                boundRequestBuilder.setRequestTimeout(this.timeoutMillis.intValue());
            }
            if (this.scroll != null) {
                boundRequestBuilder.addQueryParam("scroll", this.scroll);
            }
            if ((response = (Response)((BoundRequestBuilder)((BoundRequestBuilder)boundRequestBuilder.setBody(this.gson.toJson((JsonElement)body))).addHeader((CharSequence)"Content-Type", "application/json")).execute().get()).getStatusCode() == 404) {
                return SearchResponse.emptyResponse();
            }
            if (response.getStatusCode() >= 300) {
                throw RequestBuilderUtil.toHttpServerErrorException(response);
            }
            JsonObject jsonResponse = (JsonObject)this.gson.fromJson(response.getResponseBody(), JsonObject.class);
            SearchResponse.Builder searchResponse = SearchRequestBuilder.parseResponse(jsonResponse, this.scroll, this.httpClient);
            JsonElement aggregationsJsonElement = jsonResponse.get("aggregations");
            if (aggregationsJsonElement != null) {
                JsonObject aggregationsJsonObject = aggregationsJsonElement.getAsJsonObject();
                this.aggregations.forEach(a -> {
                    JsonElement aggregationElement = aggregationsJsonObject.get(a.getName());
                    if (aggregationElement != null) {
                        AggregationResult aggregation = a.parseResponse(aggregationElement.getAsJsonObject());
                        searchResponse.addAggregation(a.getName(), aggregation);
                    }
                });
            }
            return searchResponse.build();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(body.toString(), e);
        }
    }

    private static Collector<AggregationBuilder, JsonObject, JsonObject> toJsonObject() {
        return Collector.of(JsonObject::new, (json, a) -> json.add(a.getName(), (JsonElement)a.build()), (left, right) -> left, new Collector.Characteristics[0]);
    }

    public static SearchResponse.Builder parseResponse(JsonObject jsonObject, String scroll, HttpClientWrapper client) {
        SearchResponse.Builder searchResponse = SearchResponse.builder();
        searchResponse.setTookInMillis(jsonObject.get("took").getAsLong());
        JsonObject hits = jsonObject.get("hits").getAsJsonObject();
        JsonElement total = hits.get("total");
        long totalHits = 0L;
        if (total.isJsonPrimitive()) {
            totalHits = total.getAsLong();
        } else if (total.isJsonObject() && "eq".equals(total.getAsJsonObject().get("relation").getAsString())) {
            totalHits = total.getAsJsonObject().get("value").getAsLong();
        }
        JsonElement max_score = hits.get("max_score");
        Float maxScore = max_score.isJsonPrimitive() ? Float.valueOf(max_score.getAsFloat()) : null;
        JsonElement scroll_id = jsonObject.get("_scroll_id");
        if (scroll_id != null) {
            searchResponse.setScrollId(scroll_id.getAsString());
        }
        JsonArray hitsArray = hits.get("hits").getAsJsonArray();
        ArrayList<SearchHit> searchHitsCurrentPage = new ArrayList<SearchHit>();
        for (JsonElement element : hitsArray) {
            JsonObject asJsonObject = element.getAsJsonObject();
            JsonElement scoreElem = asJsonObject.get("_score");
            Float score = scoreElem.isJsonNull() ? null : Float.valueOf(scoreElem.getAsFloat());
            String id = asJsonObject.get("_id").getAsString();
            JsonElement source = asJsonObject.get("_source");
            JsonElement hitFields = asJsonObject.get("fields");
            SearchHit hit = new SearchHit(id, source != null ? source.getAsJsonObject() : null, hitFields != null ? hitFields.getAsJsonObject() : EMPTY_JSON_OBJECT, score);
            searchHitsCurrentPage.add(hit);
        }
        if (scroll != null && scroll_id != null) {
            searchResponse.setHits(new ScrollingSearchHits(totalHits, maxScore, scroll_id.getAsString(), scroll, searchHitsCurrentPage, client));
        } else {
            searchResponse.setHits(new SimpleSearchHits(totalHits, maxScore, searchHitsCurrentPage));
        }
        return searchResponse;
    }

    public SearchRequestBuilder setPostFilter(QueryBuilder postFilter) {
        this.postFilter = postFilter;
        return this;
    }
}

