/*
 * Decompiled with CFR 0.152.
 */
package de.otto.flummi.request;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import de.otto.flummi.RequestBuilderUtil;
import de.otto.flummi.request.RequestBuilder;
import de.otto.flummi.util.HttpClientWrapper;
import java.nio.charset.Charset;
import java.util.concurrent.ExecutionException;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateIndexSettingsRequestBuilder
implements RequestBuilder<Void> {
    private final Gson gson;
    private final String indexName;
    private JsonObject settings;
    private final HttpClientWrapper httpClient;
    public static final Logger LOG = LoggerFactory.getLogger(UpdateIndexSettingsRequestBuilder.class);

    public UpdateIndexSettingsRequestBuilder(HttpClientWrapper httpClient, String indexName) {
        this.httpClient = httpClient;
        this.indexName = indexName;
        this.gson = new Gson();
    }

    public UpdateIndexSettingsRequestBuilder setSettings(JsonObject settings) {
        this.settings = settings;
        return this;
    }

    @Override
    public Void execute() {
        try {
            Response response = (Response)((BoundRequestBuilder)((BoundRequestBuilder)((BoundRequestBuilder)this.httpClient.preparePut("/" + this.indexName + "/_settings").setBody(this.settings.toString())).setCharset(Charset.forName("UTF-8"))).addHeader((CharSequence)"Content-Type", "application/json")).execute().get();
            if (response.getStatusCode() >= 300) {
                throw RequestBuilderUtil.toHttpServerErrorException(response);
            }
            return null;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

