/*
 * Decompiled with CFR 0.152.
 */
package de.otto.flummi.response;

import de.otto.flummi.response.AggregationResult;
import java.util.Collections;
import java.util.Map;

public class Bucket {
    private final String key;
    private final Long docCount;
    private final Map<String, AggregationResult> aggregations;

    public Bucket(String key, Long docCount) {
        this(key, docCount, Collections.emptyMap());
    }

    public Bucket(String key, Long docCount, Map<String, AggregationResult> aggregations) {
        this.key = key;
        this.docCount = docCount;
        this.aggregations = aggregations;
    }

    public String getKey() {
        return this.key;
    }

    public Long getDocCount() {
        return this.docCount;
    }

    public Map<String, AggregationResult> getAggregations() {
        return this.aggregations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Bucket bucket = (Bucket)o;
        if (this.key != null ? !this.key.equals(bucket.key) : bucket.key != null) {
            return false;
        }
        if (this.docCount != null ? !this.docCount.equals(bucket.docCount) : bucket.docCount != null) {
            return false;
        }
        return this.aggregations != null ? this.aggregations.equals(bucket.aggregations) : bucket.aggregations == null;
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.docCount != null ? this.docCount.hashCode() : 0);
        result = 31 * result + (this.aggregations != null ? this.aggregations.hashCode() : 0);
        return result;
    }
}

