/*
 * Decompiled with CFR 0.152.
 */
package de.otto.flummi.response;

import de.otto.flummi.request.SearchScrollRequestBuilder;
import de.otto.flummi.response.SearchHit;
import de.otto.flummi.response.SearchHits;
import de.otto.flummi.response.SearchResponse;
import de.otto.flummi.response.SimpleSearchHits;
import de.otto.flummi.util.HttpClientWrapper;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScrollingSearchHits
implements SearchHits {
    private final long totalHits;
    private final Float maxScore;
    private final String scrollId;
    private final String scroll;
    private final HttpClientWrapper client;
    private List<SearchHit> hitsCurrentPage;
    private boolean dirty;
    public static final Logger LOG = LoggerFactory.getLogger(ScrollingSearchHits.class);

    public ScrollingSearchHits(long totalHits, Float maxScore, String scrollId, String scroll, List<SearchHit> hitsCurrentPage, HttpClientWrapper client) {
        this.totalHits = totalHits;
        this.maxScore = maxScore;
        this.scrollId = scrollId;
        this.scroll = scroll;
        this.hitsCurrentPage = hitsCurrentPage;
        this.client = client;
    }

    @Override
    public long getTotalHits() {
        return this.totalHits;
    }

    @Override
    public Float getMaxScore() {
        return this.maxScore;
    }

    @Override
    public Iterator<SearchHit> iterator() {
        this.assertNotDirty();
        return new Iterator<SearchHit>(){
            int currentPageIdx = 0;

            @Override
            public boolean hasNext() {
                if (this.currentPageIdx < ScrollingSearchHits.this.hitsCurrentPage.size()) {
                    return true;
                }
                if (ScrollingSearchHits.this.hitsCurrentPage.isEmpty()) {
                    return false;
                }
                ScrollingSearchHits.this.fetchNextPage();
                this.currentPageIdx = 0;
                return !ScrollingSearchHits.this.hitsCurrentPage.isEmpty();
            }

            @Override
            public SearchHit next() {
                if (this.currentPageIdx > 0 && this.currentPageIdx == ScrollingSearchHits.this.hitsCurrentPage.size()) {
                    ScrollingSearchHits.this.fetchNextPage();
                    this.currentPageIdx = 0;
                }
                return (SearchHit)ScrollingSearchHits.this.hitsCurrentPage.get(this.currentPageIdx++);
            }
        };
    }

    private void assertNotDirty() {
        if (this.dirty) {
            throw new IllegalStateException("Result was already iterated / streamed before");
        }
    }

    private void fetchNextPage() {
        this.dirty = true;
        SearchResponse response = new SearchScrollRequestBuilder(this.client).setScroll(this.scroll).setScrollId(this.scrollId).execute();
        this.hitsCurrentPage = ((SimpleSearchHits)response.getHits()).getHits();
    }

    @Override
    public void forEach(Consumer<? super SearchHit> action) {
        this.assertNotDirty();
        while (!this.hitsCurrentPage.isEmpty()) {
            this.hitsCurrentPage.forEach(action);
            this.fetchNextPage();
        }
    }

    @Override
    public Spliterator<SearchHit> spliterator() {
        this.assertNotDirty();
        return new Spliterator<SearchHit>(){
            Iterator<SearchHit> iterator;
            {
                this.iterator = ScrollingSearchHits.this.iterator();
            }

            @Override
            public boolean tryAdvance(Consumer<? super SearchHit> action) {
                if (this.iterator.hasNext()) {
                    action.accept(this.iterator.next());
                    return true;
                }
                return false;
            }

            @Override
            public Spliterator<SearchHit> trySplit() {
                return null;
            }

            @Override
            public long estimateSize() {
                return ScrollingSearchHits.this.totalHits;
            }

            @Override
            public int characteristics() {
                return 1360;
            }
        };
    }

    @Override
    public Stream<SearchHit> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }
}

