/*
 * Decompiled with CFR 0.152.
 */
package de.otto.flummi.util;

import io.netty.handler.codec.http.HttpHeaderNames;
import java.io.UnsupportedEncodingException;
import java.util.Base64;
import java.util.Objects;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.BoundRequestBuilder;

public class HttpClientWrapper {
    private final AsyncHttpClient asyncHttpClient;
    private final String baseUrl;
    private final String username;
    private final String password;

    public HttpClientWrapper(AsyncHttpClient asyncHttpClient, String baseUrl) {
        this(asyncHttpClient, baseUrl, null, null);
    }

    public HttpClientWrapper(AsyncHttpClient asyncHttpClient, String baseUrl, String username, String password) {
        this.asyncHttpClient = asyncHttpClient;
        this.baseUrl = baseUrl;
        this.username = username;
        this.password = password;
    }

    public BoundRequestBuilder prepareGet(String url) {
        return this.withBasicAuth(this.asyncHttpClient.prepareGet(this.baseUrl + url));
    }

    public BoundRequestBuilder preparePost(String url) {
        return this.withBasicAuth(this.asyncHttpClient.preparePost(this.baseUrl + url));
    }

    public BoundRequestBuilder preparePut(String url) {
        return this.withBasicAuth(this.asyncHttpClient.preparePut(this.baseUrl + url));
    }

    public BoundRequestBuilder prepareDelete(String url) {
        return this.withBasicAuth(this.asyncHttpClient.prepareDelete(this.baseUrl + url));
    }

    public BoundRequestBuilder prepareHead(String url) {
        return this.withBasicAuth(this.asyncHttpClient.prepareHead(this.baseUrl + url));
    }

    private BoundRequestBuilder withBasicAuth(BoundRequestBuilder boundRequestBuilder) {
        if (Objects.nonNull(this.username) && Objects.nonNull(this.password)) {
            boundRequestBuilder.addHeader((CharSequence)HttpHeaderNames.AUTHORIZATION, this.getAuthorizationHeaderValue(this.username, this.password));
        }
        return boundRequestBuilder;
    }

    private String getAuthorizationHeaderValue(String username, String password) {
        try {
            return "Basic " + Base64.getEncoder().encodeToString((username + ":" + password).getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }
}

