/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import de.otto.jlineup.config.JobConfig;
import java.lang.invoke.MethodHandles;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final AtomicInteger threadCounter = new AtomicInteger();
    public static final String JLINEUP_FILE_APPENDER = "JLineupFileAppender";
    public static final String SIFTING_APPENDER_NAME_IN_LOGBACK_XML = "SIFT";

    public static String readVersion() {
        Properties prop = new Properties();
        try {
            prop.load(Utils.class.getClassLoader().getResourceAsStream("version.properties"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return prop.getProperty("jlineup.version");
    }

    public static String readCommit() {
        Properties prop = new Properties();
        try {
            prop.load(Utils.class.getClassLoader().getResourceAsStream("version.properties"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return prop.getProperty("jlineup.commit");
    }

    public static ExecutorService createThreadPool(int threads, String baseName) {
        if (threads < 1) {
            threads = 1;
        }
        ThreadFactory factory = target -> {
            String name = String.format("%s-%d", baseName, threadCounter.getAndIncrement());
            Thread thread = new Thread(target, name);
            LOG.debug("Created new worker thread.");
            thread.setUncaughtExceptionHandler((t, e) -> LOG.error("Exception", e));
            return thread;
        };
        LOG.info("Using a thread pool with {} thread(s) to make screenshots.", (Object)threads);
        return Executors.newFixedThreadPool(threads, factory);
    }

    public static void setLogLevelToDebug() {
        ch.qos.logback.classic.Logger otto = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"de.otto");
        otto.setLevel(Level.DEBUG);
    }

    public static void setDebugLogLevelsOfSelectedThirdPartyLibsToWarn() {
        ch.qos.logback.classic.Logger apache = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"org.apache.hc");
        apache.setLevel(Level.WARN);
    }

    public static void logToFile(String workingDir) {
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        PatternLayoutEncoder ple = new PatternLayoutEncoder();
        ple.setPattern("%date %level [%thread] %logger{10} [%file:%line] %msg%n");
        ple.setContext((Context)lc);
        ple.start();
        FileAppender fileAppender = new FileAppender();
        fileAppender.setName(JLINEUP_FILE_APPENDER);
        fileAppender.setFile(workingDir + "/jlineup.log");
        fileAppender.setEncoder((Encoder)ple);
        fileAppender.setContext((Context)lc);
        fileAppender.start();
        ch.qos.logback.classic.Logger logger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"ROOT");
        logger.addAppender((Appender)fileAppender);
        logger.setLevel(Level.DEBUG);
    }

    public static void stopFileLoggers() {
        ch.qos.logback.classic.Logger logger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"ROOT");
        Appender appender = logger.getAppender(JLINEUP_FILE_APPENDER);
        if (appender != null) {
            appender.stop();
        }
        if ((appender = logger.getAppender(SIFTING_APPENDER_NAME_IN_LOGBACK_XML)) != null) {
            appender.stop();
        }
    }

    public static boolean shouldUseLegacyReportFormat(JobConfig jobConfig) {
        boolean bl;
        if (jobConfig.reportFormat != null && jobConfig.reportFormat == 1) {
            bl = true;
        } else {
            if (jobConfig.reportFormat == null) {
                // empty if block
            }
            bl = false;
        }
        return bl;
    }

    public static String getVersion() {
        return String.format("%s [%s]%n", Utils.readVersion(), Utils.readCommit());
    }

    public static void writeInfosForCommonErrors(String message) {
        if (message.contains("session deleted because of page crash")) {
            System.err.println("\n=====\n");
            System.err.println("It looks like you're using Google Chrome or Chromium and it crashes while browsing to your configured page.");
            System.err.println("Are you running inside a Docker container? Try to run JLineup with --chrome-parameter \"--disable-dev-shm-usage\" and this error might be gone.");
            System.err.println("\n=====\n");
        }
    }
}

