/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.browser;

import de.otto.jlineup.browser.CloudBrowser;
import de.otto.jlineup.config.JobConfig;
import de.otto.jlineup.file.FileService;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudBrowserFactory {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static CloudBrowser createCloudBrowser(JobConfig jobConfig, FileService fileService) {
        try {
            Class<?> lambdaBrowserClass = Class.forName("de.otto.jlineup.lambda.LambdaBrowser");
            Constructor<?> lambdaBrowserConstructor = lambdaBrowserClass.getConstructor(JobConfig.class, FileService.class);
            return (CloudBrowser)lambdaBrowserConstructor.newInstance(jobConfig, fileService);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LOG.error("No LambdaBrowser reachable.", (Throwable)e);
            throw new RuntimeException("Could not create any CloudBrowser instance.");
        }
    }
}

