/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.browser;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import de.otto.jlineup.browser.BrowserStep;
import de.otto.jlineup.config.Cookie;
import de.otto.jlineup.config.DeviceConfig;
import de.otto.jlineup.config.UrlConfig;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@JsonDeserialize(builder=Builder.class)
public final class ScreenshotContext {
    public final String url;
    public final String urlSubPath;
    public final DeviceConfig deviceConfig;
    public final List<Cookie> cookies;
    @JsonIgnore
    public final BrowserStep step;
    @JsonIgnore
    public final UrlConfig urlConfig;
    @JsonIgnore
    final String fullPathOfReportDir;
    @JsonIgnore
    final boolean dontShareBrowser;
    @JsonIgnore
    public final String urlKey;

    ScreenshotContext(String url, String urlSubPath, DeviceConfig deviceConfig, List<Cookie> cookies, BrowserStep step, UrlConfig urlConfig, String fullPathOfReportDir, boolean dontShareBrowser, String urlKey) {
        this.url = url;
        this.urlSubPath = urlSubPath;
        this.deviceConfig = deviceConfig;
        this.cookies = cookies;
        this.step = step;
        this.urlConfig = urlConfig;
        this.fullPathOfReportDir = fullPathOfReportDir;
        this.dontShareBrowser = dontShareBrowser;
        this.urlKey = urlKey;
    }

    private ScreenshotContext() {
        this(ScreenshotContext.screenshotContextBuilder());
    }

    private ScreenshotContext(Builder builder) {
        this.url = builder.url;
        this.urlSubPath = builder.urlSubPath;
        this.deviceConfig = builder.deviceConfig;
        this.cookies = builder.cookies;
        this.step = builder.step;
        this.urlConfig = builder.urlConfig;
        this.fullPathOfReportDir = builder.fullPathOfReportDir;
        this.dontShareBrowser = builder.dontShareBrowser;
        this.urlKey = builder.urlKey;
    }

    public static ScreenshotContext of(String url, String path, DeviceConfig deviceConfig, BrowserStep step, UrlConfig urlConfig, List<Cookie> cookies, String urlKey) {
        return new ScreenshotContext(url, path, deviceConfig, cookies, step, urlConfig, null, false, urlKey);
    }

    public static ScreenshotContext of(String url, String path, DeviceConfig deviceConfig, BrowserStep step, UrlConfig urlConfig, List<Cookie> cookies) {
        return new ScreenshotContext(url, path, deviceConfig, cookies, step, urlConfig, null, false, url);
    }

    public static ScreenshotContext of(String url, String path, DeviceConfig deviceConfig, BrowserStep step, UrlConfig urlConfig) {
        return new ScreenshotContext(url, path, deviceConfig, urlConfig.cookies, step, urlConfig, null, false, url);
    }

    public static Builder screenshotContextBuilder() {
        return new Builder();
    }

    public static Builder copyOfBuilder(ScreenshotContext copy) {
        Builder builder = new Builder();
        builder.url = copy.url;
        builder.urlSubPath = copy.urlSubPath;
        builder.deviceConfig = copy.deviceConfig;
        builder.cookies = copy.cookies;
        builder.step = copy.step;
        builder.urlConfig = copy.urlConfig;
        builder.fullPathOfReportDir = copy.fullPathOfReportDir;
        builder.dontShareBrowser = copy.dontShareBrowser;
        builder.urlKey = copy.urlKey;
        return builder;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUrlSubPath() {
        return this.urlSubPath;
    }

    public DeviceConfig getDeviceConfig() {
        return this.deviceConfig;
    }

    public List<Cookie> getCookies() {
        return this.cookies;
    }

    public int contextHash() {
        return Objects.hash(this.urlKey, this.urlSubPath, this.deviceConfig, this.cookies != null ? this.cookies.stream().filter(Cookie::isScreenshotContextGiving).collect(Collectors.toList()) : null);
    }

    public boolean equalsIgnoreStep(ScreenshotContext that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        return Objects.equals(this.url, that.url) && Objects.equals(this.urlSubPath, that.urlSubPath) && Objects.equals(this.deviceConfig, that.deviceConfig) && Objects.equals(this.urlConfig, that.urlConfig) && Objects.equals(this.fullPathOfReportDir, that.fullPathOfReportDir) && Objects.equals(this.urlKey, that.urlKey);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScreenshotContext that = (ScreenshotContext)o;
        return this.dontShareBrowser == that.dontShareBrowser && Objects.equals(this.url, that.url) && Objects.equals(this.urlSubPath, that.urlSubPath) && Objects.equals(this.deviceConfig, that.deviceConfig) && Objects.equals(this.cookies, that.cookies) && this.step == that.step && Objects.equals(this.urlConfig, that.urlConfig) && Objects.equals(this.fullPathOfReportDir, that.fullPathOfReportDir) && Objects.equals(this.urlKey, that.urlKey);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.url, this.urlSubPath, this.deviceConfig, this.cookies, this.step, this.urlConfig, this.fullPathOfReportDir, this.dontShareBrowser, this.urlKey});
    }

    public String toString() {
        return "ScreenshotContext{url='" + this.url + "', urlSubPath='" + this.urlSubPath + "', deviceConfig=" + this.deviceConfig + ", cookies=" + this.cookies + ", step=" + this.step + ", urlConfig=" + this.urlConfig + ", fullPathOfReportDir='" + this.fullPathOfReportDir + "', dontShareBrowser=" + this.dontShareBrowser + ", urlKey='" + this.urlKey + "'}";
    }

    @JsonIgnore
    public String getShortDescription() {
        if (!this.deviceConfig.isSpecificMobile()) {
            return this.url + " with device " + this.deviceConfig.deviceName + " (" + this.deviceConfig.width + "x" + this.deviceConfig.height + ")";
        }
        return this.url + " with device " + this.deviceConfig.deviceName;
    }

    public static final class Builder {
        private String url;
        private String urlSubPath;
        private DeviceConfig deviceConfig;
        private List<Cookie> cookies = Collections.emptyList();
        private BrowserStep step;
        private UrlConfig urlConfig;
        private String fullPathOfReportDir;
        private boolean dontShareBrowser;
        private String urlKey;

        private Builder() {
        }

        public Builder withUrl(String val) {
            this.url = val;
            return this;
        }

        public Builder withUrlSubPath(String val) {
            this.urlSubPath = val;
            return this;
        }

        public Builder withDeviceConfig(DeviceConfig val) {
            this.deviceConfig = val;
            return this;
        }

        public Builder withCookies(List<Cookie> val) {
            this.cookies = val;
            return this;
        }

        public Builder withStep(BrowserStep val) {
            this.step = val;
            return this;
        }

        public Builder withUrlConfig(UrlConfig val) {
            this.urlConfig = val;
            return this;
        }

        public Builder withFullPathOfReportDir(String val) {
            this.fullPathOfReportDir = val;
            return this;
        }

        public Builder withDontShareBrowser(boolean val) {
            this.dontShareBrowser = val;
            return this;
        }

        public Builder withUrlKey(String val) {
            this.urlKey = val;
            return this;
        }

        public ScreenshotContext build() {
            return new ScreenshotContext(this);
        }
    }
}

