/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.config;

import com.google.common.collect.ImmutableMap;
import de.otto.jlineup.config.JobConfig;
import de.otto.jlineup.config.UrlConfig;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigMerger {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static JobConfig mergeJobConfigWithMergeConfig(JobConfig mainGlobalConfig, JobConfig mergeGlobalConfig) {
        JobConfig.Builder mergedJobConfigBuilder = JobConfig.jobConfigBuilder();
        ConfigMerger.mergeGlobalScopeConfigItems(mainGlobalConfig, mergeGlobalConfig, mergedJobConfigBuilder);
        Map<String, UrlConfig> urls = mainGlobalConfig.urls;
        for (Map.Entry<String, UrlConfig> mainUrlConfigEntry : urls.entrySet()) {
            UrlConfig mainUrlConfig = mainUrlConfigEntry.getValue();
            Map<String, UrlConfig> mergeUrls = mergeGlobalConfig.urls;
            for (Map.Entry<String, UrlConfig> mergeUrlConfigEntry : mergeUrls.entrySet()) {
                if (!mainUrlConfigEntry.getKey().matches(mergeUrlConfigEntry.getKey())) continue;
                LOG.info("Merging merge config for '{}' into '{}'", (Object)mergeUrlConfigEntry.getKey(), (Object)mainUrlConfigEntry.getKey());
                UrlConfig mergeUrlConfig = mergeUrlConfigEntry.getValue();
                UrlConfig.Builder urlConfigBuilder = UrlConfig.urlConfigBuilder();
                urlConfigBuilder.withUrl(mainUrlConfig.url);
                urlConfigBuilder.withAlternatingCookies(ConfigMerger.merge(mainUrlConfig.alternatingCookies, mergeUrlConfig.alternatingCookies));
                urlConfigBuilder.withCleanupPaths(ConfigMerger.merge(mainUrlConfig.cleanupPaths, mergeUrlConfig.cleanupPaths));
                urlConfigBuilder.withCookies(ConfigMerger.merge(mainUrlConfig.cookies, mergeUrlConfig.cookies));
                urlConfigBuilder.withDevices(ConfigMerger.merge(mainUrlConfig.devices, mergeUrlConfig.devices));
                urlConfigBuilder.withEnvMapping(ConfigMerger.merge(mainUrlConfig.envMapping, mergeUrlConfig.envMapping));
                urlConfigBuilder.withFailIfSelectorsNotFound(mainUrlConfig.failIfSelectorsNotFound || mergeUrlConfig.failIfSelectorsNotFound);
                urlConfigBuilder.withHideImages(mainUrlConfig.hideImages || mergeUrlConfig.hideImages);
                urlConfigBuilder.withHttpCheck(mainUrlConfig.httpCheck != JobConfig.DEFAULT_HTTP_CHECK_CONFIG ? mainUrlConfig.httpCheck : mergeUrlConfig.httpCheck);
                urlConfigBuilder.withIgnoreAntiAliasing(mainUrlConfig.ignoreAntiAliasing || mergeUrlConfig.ignoreAntiAliasing);
                urlConfigBuilder.withJavaScript(mainUrlConfig.javaScript == null && mergeUrlConfig.javaScript == null ? null : mainUrlConfig.javaScript + ";" + mergeUrlConfig.javaScript);
                urlConfigBuilder.withLocalStorage(ConfigMerger.merge(mainUrlConfig.localStorage, mergeUrlConfig.localStorage));
                urlConfigBuilder.withMaxColorDistance(mainUrlConfig.maxColorDistance != 2.3f ? mainUrlConfig.maxColorDistance : mergeUrlConfig.maxColorDistance);
                urlConfigBuilder.withMaxDiff(mainUrlConfig.maxDiff != 0.0 ? mainUrlConfig.maxDiff : mergeUrlConfig.maxDiff);
                urlConfigBuilder.withMaxScrollHeight(mainUrlConfig.maxScrollHeight != 100000 ? mainUrlConfig.maxScrollHeight : mergeUrlConfig.maxScrollHeight);
                urlConfigBuilder.withPaths(ConfigMerger.merge(mainUrlConfig.paths, mergeUrlConfig.paths));
                urlConfigBuilder.withRemoveSelectors(ConfigMerger.merge(mainUrlConfig.removeSelectors, mergeUrlConfig.removeSelectors));
                urlConfigBuilder.withSessionStorage(ConfigMerger.merge(mainUrlConfig.sessionStorage, mergeUrlConfig.sessionStorage));
                urlConfigBuilder.withSetupPaths(ConfigMerger.merge(mainUrlConfig.setupPaths, mergeUrlConfig.setupPaths));
                urlConfigBuilder.withStrictColorComparison(mainUrlConfig.strictColorComparison || mergeUrlConfig.strictColorComparison);
                urlConfigBuilder.withWaitAfterPageLoad(mainUrlConfig.waitAfterPageLoad != 0.0f ? mainUrlConfig.waitAfterPageLoad : mergeUrlConfig.waitAfterPageLoad);
                urlConfigBuilder.withWaitAfterScroll(mainUrlConfig.waitAfterScroll != 0.0f ? mainUrlConfig.waitAfterScroll : mergeUrlConfig.waitAfterScroll);
                urlConfigBuilder.withWaitForFontsTime(mainUrlConfig.waitForFontsTime != 0.0f ? mainUrlConfig.waitForFontsTime : mergeUrlConfig.waitForFontsTime);
                urlConfigBuilder.withWaitForNoAnimationAfterScroll(mainUrlConfig.waitForNoAnimationAfterScroll != 0.0f ? mainUrlConfig.waitForNoAnimationAfterScroll : mergeUrlConfig.waitForNoAnimationAfterScroll);
                urlConfigBuilder.withWaitForSelectors(ConfigMerger.merge(mainUrlConfig.waitForSelectors, mergeUrlConfig.waitForSelectors));
                urlConfigBuilder.withWaitForSelectorsTimeout(mainUrlConfig.waitForSelectorsTimeout != 10.0f ? mainUrlConfig.waitForSelectorsTimeout : mergeUrlConfig.waitForSelectorsTimeout);
                urlConfigBuilder.withWarmupBrowserCacheTime(mainUrlConfig.warmupBrowserCacheTime != 0.0f ? mainUrlConfig.warmupBrowserCacheTime : mergeUrlConfig.warmupBrowserCacheTime);
                urlConfigBuilder.withWindowWidths(ConfigMerger.merge(mainUrlConfig.windowWidths, mergeUrlConfig.windowWidths));
                mainUrlConfig = urlConfigBuilder.build();
            }
            mergedJobConfigBuilder.addUrlConfig(mainUrlConfigEntry.getKey(), mainUrlConfig);
        }
        return mergedJobConfigBuilder.build();
    }

    private static <T> Set<T> merge(Set<T> one, Set<T> two) {
        if (one == null && two == null) {
            return null;
        }
        return Stream.concat(one != null ? one.stream() : Stream.empty(), two != null ? two.stream() : Stream.empty()).collect(Collectors.toSet());
    }

    private static <T> List<T> merge(List<T> one, List<T> two) {
        if (one == null && two == null) {
            return null;
        }
        return Stream.concat(one != null ? one.stream() : Stream.empty(), two != null ? two.stream() : Stream.empty()).distinct().collect(Collectors.toList());
    }

    private static <T, U> Map<T, U> merge(Map<T, U> one, Map<T, U> two) {
        if (one == null && two == null) {
            return null;
        }
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        if (two != null) {
            mapBuilder.putAll(two);
        }
        if (one != null) {
            mapBuilder.putAll(one);
        }
        return mapBuilder.buildKeepingLast();
    }

    private static void mergeGlobalScopeConfigItems(JobConfig originalConfig, JobConfig mergeConfig, JobConfig.Builder mergedJobConfigBuilder) {
        mergedJobConfigBuilder.withBrowser(originalConfig.browser != JobConfig.DEFAULT_BROWSER ? originalConfig.browser : mergeConfig.browser);
        mergedJobConfigBuilder.withCheckForErrorsInLog(originalConfig.checkForErrorsInLog || mergeConfig.checkForErrorsInLog);
        mergedJobConfigBuilder.withDebug(originalConfig.debug || mergeConfig.debug);
        mergedJobConfigBuilder.withGlobalTimeout(originalConfig.globalTimeout != 1800 ? originalConfig.globalTimeout : mergeConfig.globalTimeout);
        mergedJobConfigBuilder.withGlobalWaitAfterPageLoad((originalConfig.globalWaitAfterPageLoad.floatValue() != 0.0f ? originalConfig.globalWaitAfterPageLoad : mergeConfig.globalWaitAfterPageLoad).floatValue());
        mergedJobConfigBuilder.withHttpCheck(!originalConfig.httpCheck.equals(JobConfig.DEFAULT_HTTP_CHECK_CONFIG) ? originalConfig.httpCheck : mergeConfig.httpCheck);
        mergedJobConfigBuilder.withLogToFile(originalConfig.logToFile || mergeConfig.logToFile);
        mergedJobConfigBuilder.withName(originalConfig.name != null ? originalConfig.name : mergeConfig.name);
        mergedJobConfigBuilder.withPageLoadTimeout(originalConfig.pageLoadTimeout != 120 ? originalConfig.pageLoadTimeout : mergeConfig.pageLoadTimeout);
        mergedJobConfigBuilder.withReportFormat(originalConfig.reportFormat != 2 ? originalConfig.reportFormat : mergeConfig.reportFormat);
        mergedJobConfigBuilder.withScreenshotRetries(originalConfig.screenshotRetries != 0 ? originalConfig.screenshotRetries : mergeConfig.screenshotRetries);
        mergedJobConfigBuilder.withThreads(originalConfig.threads != 0 ? originalConfig.threads : mergeConfig.threads);
        mergedJobConfigBuilder.withWindowHeight(originalConfig.windowHeight != null ? originalConfig.windowHeight : mergeConfig.windowHeight);
    }
}

