/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.config;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import de.otto.jlineup.config.CustomDateDeserializer;
import java.util.Date;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public class Cookie {
    public static final String COOKIE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ssXXX";
    public final String name;
    public final String value;
    public final String domain;
    public final String path;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ssXXX", timezone="UTC")
    @JsonDeserialize(using=CustomDateDeserializer.class)
    public final Date expiry;
    public final boolean secure;
    public final Boolean showInReport;
    @JsonIgnore
    public final boolean screenshotContextGiving;

    public Cookie(String name, String value, String domain, String path, Date expiry, boolean secure, Boolean showInReport, boolean screenshotContextGiving) {
        this.name = name;
        this.value = value;
        this.domain = domain;
        this.path = path;
        this.expiry = expiry;
        this.secure = secure;
        this.showInReport = showInReport;
        this.screenshotContextGiving = screenshotContextGiving;
    }

    public Cookie(String name, String value) {
        this.name = name;
        this.value = value;
        this.domain = null;
        this.path = null;
        this.expiry = null;
        this.secure = false;
        this.showInReport = null;
        this.screenshotContextGiving = false;
    }

    private Cookie(Builder builder) {
        this.name = builder.name;
        this.value = builder.value;
        this.domain = builder.domain;
        this.path = builder.path;
        this.expiry = builder.expiry;
        this.secure = builder.secure;
        this.showInReport = builder.showInReport;
        this.screenshotContextGiving = builder.screenshotContextGiving;
    }

    public static Builder cookieBuilder() {
        return new Builder();
    }

    public static Builder copyOfBuilder(Cookie copy) {
        Builder builder = new Builder();
        builder.name = copy.getName();
        builder.value = copy.getValue();
        builder.domain = copy.getDomain();
        builder.path = copy.getPath();
        builder.expiry = copy.getExpiry();
        builder.secure = copy.isSecure();
        builder.showInReport = copy.getShowInReport();
        builder.screenshotContextGiving = copy.isScreenshotContextGiving();
        return builder;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getPath() {
        return this.path;
    }

    public Date getExpiry() {
        return this.expiry;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public Boolean getShowInReport() {
        return this.showInReport;
    }

    public boolean isScreenshotContextGiving() {
        return this.screenshotContextGiving;
    }

    public String toString() {
        return "Cookie{name='" + this.name + "', value='" + this.value + "', domain='" + this.domain + "', path='" + this.path + "', expiry=" + this.expiry + ", secure=" + this.secure + ", showInReport=" + this.showInReport + ", screenshotContextGiving=" + this.screenshotContextGiving + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Cookie cookie = (Cookie)o;
        return this.secure == cookie.secure && this.screenshotContextGiving == cookie.screenshotContextGiving && Objects.equals(this.name, cookie.name) && Objects.equals(this.value, cookie.value) && Objects.equals(this.domain, cookie.domain) && Objects.equals(this.path, cookie.path) && Objects.equals(this.expiry, cookie.expiry) && Objects.equals(this.showInReport, cookie.showInReport);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value, this.domain, this.path, this.expiry, this.secure, this.showInReport, this.screenshotContextGiving);
    }

    public static final class Builder {
        private String name;
        private String value;
        private String domain;
        private String path;
        private Date expiry;
        private boolean secure;
        public Boolean showInReport;
        public boolean screenshotContextGiving;

        private Builder() {
        }

        public Builder withName(String val) {
            this.name = val;
            return this;
        }

        public Builder withValue(String val) {
            this.value = val;
            return this;
        }

        public Builder withDomain(String val) {
            this.domain = val;
            return this;
        }

        public Builder withPath(String val) {
            this.path = val;
            return this;
        }

        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ssXXX", timezone="UTC")
        @JsonDeserialize(using=CustomDateDeserializer.class)
        public Builder withExpiry(Date val) {
            this.expiry = val;
            return this;
        }

        public Builder withSecure(boolean val) {
            this.secure = val;
            return this;
        }

        public Builder withShowInReport(Boolean val) {
            this.showInReport = val;
            return this;
        }

        public Builder withScreenshotContextGiving(boolean val) {
            this.screenshotContextGiving = val;
            return this;
        }

        public Cookie build() {
            return new Cookie(this);
        }
    }
}

